## Thinking Forward and Backward: Effective Backward Planning with Large Language Model

### Installation

```console
conda env create -f environment.yml
conda activate llm-backward
pip install -e .
```

For Blocksworld, copy the two folders `PR2` and `VAL` [here](https://github.com/karthikv792/LLMs-Planning/tree/main/planner_tools) to this directory. And clone `downward` package to this directory too
```console
git clone https://github.com/aibasel/downward.git
```

### Experiments

Below are instructions for replicating Table 1 in each planning domain.

#### Graph Planning

For running experiments, choose `mode` from `{fwd, back, flip, fwd-back, fwd-flip}`, `num_node' from `{10, 12}`, `edge_rate
 from `{0.2, 0.3}`, and `directed`.
```console
python graph/run.py --num_run 200 --api_key <api_key> --mode <mode> --num_node <num_node> --edge_rate <edge_rate> --directed
```
Data will saved under `result/graph` and the success rate will be reported at the end of experiments.

#### Array Transformation

For running experiments, choose `mode` from `{fwd, back, flip, fwd-back, fwd-flip}`, `funcs' from `{reverse_swap_repeat_cut, reverse_swap_shift, shift_repeat_cut}`
```console
python arrayt/run.py --num_run 200 -api_key <api_key> --mode <mode> --funcs <funcs>
```
Data will saved under `result/arrayt` and the success rate will be reported at the end of experiments.

#### Blocksworld

For running experiments, choose `mode` from `{fwd, back, flip, fwd-back, fwd-flip}`
```console
python plan-bench/run.py --num_run 200 -api_key <api_key> --mode <mode>
```
Data will saved under `result/blocksworld`, and then run evaluation with `<result>` replaced with the saved data path.
```console
python plan-bench/evaluate.py --mode <mode> --result <result>
```
