fwd_prompt_header = """
A random sequence of three of the below functions transform the initial array into the final array.
Given initial and final, output the sequence of transformations.

def reverse(x):
  # reverse the sequence
  return x[::-1]

def shift_left(x):
  # shift the sequence to the left by one
  return x[1:] + x[:1]

def shift_right(x):
  # shift the sequence to the right by one
  return [x[-1]] + x[:-1]

def swap(x):
  # swap the first and last elements
  return x[-1:] + x[1:-1] + x[0:1]

***** Examples:
"""

back_prompt_header = """
A random sequence of three of the below functions transform the initial array into the final array.
Given initial and final, output the backwards sequence of transformations.

def reverse(x):
  # reverse the sequence
  return x[::-1]

def shift_left(x):
  # shift the sequence to the left by one
  return x[1:] + x[:1]

def shift_right(x):
  # shift the sequence to the right by one
  return [x[-1]] + x[:-1]

def swap(x):
  # swap the first and last elements
  return x[-1:] + x[1:-1] + x[0:1]

***** Examples:
"""
flip_prompt_header = fwd_prompt_header

verify_prompt_fixed = """
A random sequence of three of the below functions transform the initial array into the final array.
Given initial and final, output the sequence of transformations.

def reverse(x):
  # reverse the sequence
  return x[::-1]

def shift_left(x):
  # shift the sequence to the left by one
  return x[1:] + x[:1]

def shift_right(x):
  # shift the sequence to the right by one
  return x[-1:] + x[:-1]

def swap(x):
  # swap the first and last elements
  return x[-1:] + x[1:-1] + x[0:1]

***** Examples:
Initial: [1, 5, 7, 1, 2]
Desired Final: [1, 7, 5, 2, 1]
Functions: [reverse, swap, shift_left]
Verify initial to final steps:
  reverse: [1, 5, 7, 1, 2][::-1] -> [2, 1, 7, 5, 1]
  swap: [2, 1, 7, 5, 1][-1:] + [2, 1, 7, 5, 1][1:-1] + [2, 1, 7, 5, 1][:1] -> [1, 1, 7, 5, 2]
  shift_left: [1, 1, 7, 5, 2][1:] + [1, 1, 7, 5, 2][:1] -> [1, 7, 5, 2, 1]
  actual final: [1, 7, 5, 2, 1], desired final: [1, 7, 5, 2, 1], match
  Correct

Initial: [0, 8, 8, 3, 6]
Desired Final: [3, 0, 8, 8, 6]
Functions: [shift_right, swap, reverse]
Verify initial to final steps:
  shift_right: [0, 8, 8, 3, 6][-1:] + [0, 8, 8, 3, 6][:-1] -> [6, 0, 8, 8, 3]
  swap: [6, 0, 8, 8, 3][-1:] + [6, 0, 8, 8, 3][1:-1] + [6, 0, 8, 8, 3][:1] -> [3, 0, 8, 8, 6]
  reverse: [3, 0, 8, 8, 6][::-1] -> [6, 8, 8, 0, 3]
  actual final: [6, 8, 8, 0, 3], desired final: [3, 0, 8, 8, 6], does not match
  Incorrect

Initial: [5, 5, 0, 2, 4]
Desired Final: [4, 2, 0, 5, 5]
Functions: [swap, reverse, swap]
Verify initial to final steps:
  swap: [5, 5, 0, 2, 4][-1:] + [5, 5, 0, 2, 4][1:-1] + [5, 5, 0, 2, 4][:1] -> [4, 5, 0, 2, 5]
  reverse: [4, 5, 0, 2, 5][::-1] -> [5, 2, 0, 5, 4]
  swap: [5, 2, 0, 5, 4][-1:] + [5, 2, 0, 5, 4][1:-1] + [5, 2, 0, 5, 4][:1] -> [4, 2, 0, 5, 5]
  actual final: [4, 2, 0, 5, 5], desired final: [4, 2, 0, 5, 5], match
  Correct

Initial: [2, 5, 9, 1, 5]
Desired Final: [5, 5, 9, 1, 2]
Functions: [shift_left, reverse, shift_right, swap]
Verify initial to final steps:
  shift_left: [2, 5, 9, 1, 5][1:] + [2, 5, 9, 1, 5][:1] -> [5, 9, 1, 5, 2]
  reverse: [5, 9, 1, 5, 2][::-1] -> [2, 5, 1, 9, 5]
  shift_right: [2, 5, 1, 9, 5][-1:] + [2, 5, 1, 9, 5][:-1] -> [5, 2, 5, 1, 9]
  swap: [5, 2, 5, 1, 9][-1:] + [5, 2, 5, 1, 9][1:-1] + [5, 2, 5, 1, 9][:1] -> [9, 2, 5, 1, 5]
  actual final: [9, 2, 5, 1, 5], desired final: [5, 5, 9, 1, 2], does not match
  Incorrect
"""