fwd_prompt_header = """
A random sequence of three of the below functions transform the initial array into the final array.
Given initial and final, output the sequence of transformations.

def shift_left(x):
  # shift the sequence to the left by one
  return x[1:] + x[:1]

def shift_right(x):
  # shift the sequence to the right by one
  return [x[-1]] + x[:-1]

def repeat(x):
  # repeat the sequence once
  return x + x

def cut(x):
  # cut the sequence in half
  assert x[:len(x) // 2] == x[len(x) // 2:]
  return x[:len(x) // 2]

***** Examples:
"""

back_prompt_header = """
A random sequence of three of the below functions transform the initial array into the final array.
Given initial and final, output the backwards sequence of transformations.

def shift_left(x):
  # shift the sequence to the left by one
  return x[1:] + x[:1]

def shift_right(x):
  # shift the sequence to the right by one
  return [x[-1]] + x[:-1]

def repeat(x):
  # repeat the sequence once
  return x + x

def cut(x):
  # cut the sequence in half
  assert x[:len(x) // 2] == x[len(x) // 2:]
  return x[:len(x) // 2]

***** Examples:
"""

flip_prompt_header = fwd_prompt_header


verify_prompt_fixed = """
A random sequence of three of the below functions transform the initial array into the final array.
Given initial and final, output the sequence of transformations.

def shift_left(x):
  # shift the sequence to the left by one
  return x[1:] + x[:1]

def shift_right(x):
  # shift the sequence to the right by one
  return [x[-1]] + x[:-1]

def repeat(x):
  # repeat the sequence once
  return x + x

def cut(x):
  # cut the sequence in half
  assert x[:len(x) // 2] == x[len(x) // 2:]
  return x[:len(x) // 2]

***** Examples:
Initial: [3, 0, 8, 8, 3, 0, 8, 8]
Desired Final: [8, 8, 0, 3]
Functions: [shift_left, cut, shift_right]
Verify initial to final steps:
  shift_left: [3, 0, 8, 8, 3, 0, 8, 8][1:] + [3, 0, 8, 8, 3, 0, 8, 8][:1] -> [0, 8, 8, 3, 0, 8, 8, 3]
  cut: [0, 8, 8, 3, 0, 8, 8, 3] half -> [0, 8, 8, 3] and [0, 8, 8, 3] equal -> [0, 8, 8, 3]
  shift_right: [[0, 8, 8, 3][-1]] + [0, 8, 8, 3][:-1] -> [3, 0, 8, 8]
  actual final: [3, 0, 8, 8], desired final: [8, 8, 0, 3], does not match
  Incorrect

Initial: [1, 5, 7, 2]
Desired Final: [7, 2, 1, 5, 7, 2, 1, 5]
Functions: [shift_right, shift_right, repeat]
Verify initial to final steps:
  shift_right: [[1, 5, 7, 2][-1]] + [1, 5, 7, 2][:-1] -> [2, 1, 5, 7]
  shift_right: [[2, 1, 5, 7][-1]] + [2, 1, 5, 7][:-1] -> [7, 2, 1, 5]
  repeat: [7, 2, 1, 5] + [7, 2, 1, 5] -> [7, 2, 1, 5, 7, 2, 1, 5]
  actual final: [7, 2, 1, 5, 7, 2, 1, 5], desired final: [7, 2, 1, 5, 7, 2, 1, 5], match
  Correct

Initial: [5, 5, 0, 2, 5, 5, 3, 2]
Desired Final: [4, 2, 0, 5, 5]
Functions: [shift_left, cut, shift_right]
Verify initial to final steps:
  shift_left: [5, 5, 0, 2, 5, 5, 3, 2][1:] + [5, 5, 0, 2, 5, 5, 3, 2][:1] -> [5, 0, 2, 5, 5, 3, 2, 5]
  cut: [5, 0, 2, 5, 5, 3, 2, 5] half -> [5, 0, 2, 5] and [5, 3, 2, 5] not equal -> cut failed
  Incorrect

Initial: [2, 5, 9, 5]
Desired Final: [2, 5, 9, 5, 2, 5, 9, 5]
Functions: [shift_right, repeat, shift_left]
Verify initial to final steps:
  shift_right: [[2, 5, 9, 5][-1]] + [2, 5, 9, 5][:-1] -> [5, 2, 5, 9]
  repeat: [5, 2, 5, 9] + [5, 2, 5, 9] -> [5, 2, 5, 9, 5, 2, 5, 9]
  shift_left: [5, 2, 5, 9, 5, 2, 5, 9][1:] + [5, 2, 5, 9, 5, 2, 5, 9][:1] -> [2, 5, 9, 5, 2, 5, 9, 5]
  actual final: [2, 5, 9, 5, 2, 5, 9, 5], desired final: [2, 5, 9, 5, 2, 5, 9, 5], match
  Correct
"""