import os
import sys
sys.path.append("../../SLD")
sys.path.append("")
from dotenv import load_dotenv

load_dotenv()



from openai import OpenAI
import json
from tqdm import tqdm
import time
import requests
import base64

client = OpenAI(organization=os.getenv("ORGANIZATION"), api_key=os.getenv("API_KEY"))
IMAGE_DIR = "FILL INITIAL IMAGE DIRECTORY HERE"


def main():
    with open("FILL DATASET HERE", 'r') as file:
        dataset = json.load(file)["data"]

    os.makedirs(IMAGE_DIR, exist_ok=True)

    for data in tqdm(dataset[:]):
        if data["update_prompt"]:
            prompt = data["update_prompt"].split("\n")[0]
        else:
            prompt = data["prompt"]
        image_id = data["id"]
        while True:
            try:
                response =  client.images.generate(
                    model="gpt-image-1",
                    prompt=prompt,
                    n=1,
                    size="1024x1024",        # Allowed sizes: "1024x1024", "1024x1536", "1536x1024"
                    quality="low",          # Options: "low", "medium", "high"
                    output_format="png",     # Options: "png", "jpeg", "webp"
                    background="auto",       # Options: "auto", "transparent", "opaque"
                    moderation="auto",       # Content filtering: "auto" or "low"
                )

                b64_image = response.data[0].b64_json
                image_data = base64.b64decode(b64_image)
                save_file = os.path.join(IMAGE_DIR, f"{image_id}.png")
                print(f"Image saved as {save_file}")
                with open(save_file, "wb") as f:
                    f.write(image_data)
                break
            except Exception as e:
                print("error", e)
                time.sleep(5)
        

if __name__ == "__main__":
    main()
