import os
import sys
from generators import GEN
from planners import PLAN, OPENAI_KEY, SYS_PROMPT, EXAMPLES
from editors import EDIT
from diffusers.utils import make_image_grid
import json
from tqdm import tqdm
import shutil

IMG_DIR = "FILL INITIAL IMAGE HERE"
IMG_RESULT_DIR = "FILL DIRECTORY OF RESULTS HERE"

if __name__ == "__main__":
    
    dataset = []
    data_file = "FILL YOUR FILE HERE"
    with open(data_file, 'r') as file:
        dataset = json.load(file)["data"]
    
    if not os.path.exists(IMG_RESULT_DIR):
        os.makedirs(IMG_RESULT_DIR, exist_ok=True)

    planner = PLAN("gpt4o", SYS_PROMPT, EXAMPLES) #options : ['gpt4o', 'Qwen/Qwen2-VL-72B-Instruct', 'Qwen/Qwen2-VL-7B-Instruct']
    editor = EDIT('InstructPix2Pix', "FILL LOCATION OF WEIGHT OF EDITING ACTION HERE")
    for data in tqdm(dataset):
        PROMPT = data["prompt"]
        img_id = data["id"] + ".png"

        init_image_file = os.path.join(IMG_DIR, "resize_" + img_id)
        save_img_name = os.path.join(IMG_RESULT_DIR, img_id)
        plans = planner.generate(init_image_file, PROMPT)
        # plans = ['Reposition the dog to be on the back of the cat in the right image']
        if len(plans) == 0:
            shutil.copy(init_image_file, save_img_name)
            continue
        _, I = editor.edit(init_image_file, plans)
        if len(I) == 0:
            print("Error")
            shutil.copy(init_image_file, save_img_name)
            continue

        print("Sucessful Edit. Save file at", save_img_name)
        result_image = I[-1]
        result_image.save(save_img_name)
