function completed = example_linearSysDT_observe_03_tank
% example_linearSysDT_observe_03_tank - example for guaranteed state
%    estimation of linear discrete-time systems from a unit test; shows the
%    solution of the linearSysDT class for a linearized tank example from [1].
%
% Syntax:
%    completed = example_linearSysDT_observe_03_tank
%
% Inputs:
%    -
%
% Outputs:
%    completed - true/false 
%
% Reference:
%    [1] M. Althoff. Guaranteed State Estimation in CORA 2021. 
%        Proc. of the 8th International Workshop on Applied Verification 
%        for Continuous and Hybrid Systems, 2021.

% Authors:       Matthias Althoff
% Written:       12-June-2021
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% load pedestrian model
% load tankModel_lin_dim30 tank params options simRes
[tank,params,options,simRes] = aux_load_model();

% observe
options.alg = 'FRad-C'; % observer approach
estSet = observe(tank,params,options);

% plot results
for iDim = 1:6
    figure; hold on;
    % plot time elapse
    plotOverTime(estSet,iDim);
    % plot simulation
    plotOverTime(simRes,iDim);

    % label plot
    title(options.alg);
    xlabel('t');
    ylabel(['x_{',num2str(iDim),'}']);
end

% example completed
completed = true;

end


% Auxiliary functions -----------------------------------------------------

function [tank,params,options,simRes] = aux_load_model()

% generated semi-automatically using printSystem, printSet, etc. 
% from saved .mat file

% build system
name = 'tankSystemLin_30';
A = [ 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.2480000000000000 0.7630000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9970000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0030000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2480000000000000 0.7610000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2480000000000000 0.7300000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9970000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0030000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2480000000000000 0.7420000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9970000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0030000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2480000000000000 0.7420000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0040000000000000 0.9960000000000000 ];
B = [ 0.5000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0330000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0330000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0330000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0330000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0330000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0330000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0330000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0330000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0330000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0330000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ];
c = [ 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ];
C = [ 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 1.0000000000000000 0.0000000000000000 ];
D = [];
k = [];
E = zeros(size(A,1),30);
F = zeros(size(C,1),21);
dt = 0.5000000000000000;
tank = linearSysDT(name,A,B,c,C,D,k,E,F,dt);
% build params
params = struct( ...
    'tFinal', 117.5000000000000000, ...
    'R0', zonotope([ 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ], [ 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 4.0000000000000000 ]), ...
    'V', zonotope([ 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ], [ 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.2000000000000000 ]), ...
    'W', zonotope([ 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ], [ 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 0.0000000000000000 ; 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0000000000000000 0.0010000000000000 ]), ...
    'u', [ ... % u
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2050000000000001, 0.2100000000000001, 0.2150000000000001, 0.2200000000000001, 0.2250000000000001, 0.2300000000000001, 0.2350000000000001, 0.2400000000000001, 0.2450000000000001, 0.2500000000000001, 0.2575000000000001, 0.2650000000000001, 0.2725000000000001, 0.2800000000000001, 0.2875000000000001, 0.2950000000000002, 0.3025000000000002, 0.3100000000000002, 0.3175000000000002, 0.3250000000000002, 0.3325000000000002, 0.3400000000000002, 0.3475000000000002, 0.3550000000000002, 0.3625000000000002, 0.3700000000000002, 0.3775000000000002, 0.3850000000000002, 0.3925000000000002, 0.4000000000000002, 0.4050000000000002, 0.4100000000000003, 0.4150000000000003, 0.4200000000000003, 0.4250000000000003, 0.4300000000000003, 0.4350000000000003, 0.4400000000000003, 0.4450000000000003, 0.4500000000000003, 0.4550000000000003, 0.4600000000000003, 0.4650000000000003, 0.4700000000000003, 0.4750000000000003, 0.4800000000000003, 0.4850000000000003, 0.4900000000000003, 0.4950000000000003, 0.5000000000000003, 0.5025000000000003, 0.5050000000000002, 0.5075000000000002, 0.5100000000000001, 0.5125000000000001, 0.5150000000000000, 0.5175000000000000, 0.5199999999999999, 0.5224999999999999, 0.5249999999999998, 0.5274999999999997, 0.5299999999999997, 0.5324999999999996, 0.5349999999999996, 0.5374999999999995, 0.5399999999999995, 0.5424999999999994, 0.5449999999999994, 0.5474999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5474999999999993, 0.5449999999999994, 0.5424999999999994, 0.5399999999999995, 0.5374999999999995, 0.5349999999999996, 0.5324999999999996, 0.5299999999999997, 0.5274999999999997, 0.5249999999999998, 0.5224999999999999, 0.5199999999999999, 0.5175000000000000, 0.5150000000000000, 0.5125000000000001, 0.5100000000000001, 0.5075000000000002, 0.5050000000000002, 0.5025000000000003, 0.5000000000000003, 0.4925000000000003, 0.4850000000000003, 0.4775000000000003, 0.4700000000000003, 0.4625000000000003, 0.4550000000000003, 0.4475000000000003, 0.4400000000000003, 0.4325000000000003, 0.4250000000000003, 0.4175000000000003, 0.4100000000000003, 0.4025000000000002, 0.3950000000000002, 0.3875000000000002, 0.3800000000000002, 0.3725000000000002, 0.3650000000000002, 0.3575000000000002, 0.3500000000000002, 0.3425000000000002, 0.3350000000000002, 0.3275000000000002, 0.3200000000000002, 0.3125000000000002, 0.3050000000000002, 0.2975000000000002, 0.2900000000000001, 0.2825000000000001, 0.2750000000000001, 0.2675000000000001, 0.2600000000000001, 0.2525000000000001, 0.2450000000000001, 0.2375000000000001, 0.2300000000000001, 0.2225000000000001, 0.2150000000000001, 0.2075000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000 ; ... % u1
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1525000000000001, 0.1550000000000001, 0.1575000000000001, 0.1600000000000001, 0.1625000000000001, 0.1650000000000001, 0.1675000000000001, 0.1700000000000001, 0.1725000000000001, 0.1750000000000001, 0.1775000000000001, 0.1800000000000001, 0.1825000000000001, 0.1850000000000001, 0.1875000000000001, 0.1900000000000001, 0.1925000000000001, 0.1950000000000001, 0.1975000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000, 0.1475000000000000, 0.1450000000000000, 0.1425000000000000, 0.1400000000000000, 0.1375000000000000, 0.1350000000000000, 0.1325000000000000, 0.1300000000000000, 0.1275000000000000, 0.1250000000000000, 0.1225000000000000, 0.1200000000000000, 0.1175000000000000, 0.1150000000000000, 0.1125000000000000, 0.1100000000000000, 0.1075000000000000, 0.1050000000000000, 0.1025000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.0975000000000000, 0.0950000000000000, 0.0925000000000000, 0.0900000000000000, 0.0875000000000000, 0.0850000000000000, 0.0825000000000000, 0.0800000000000000, 0.0775000000000000, 0.0750000000000000, 0.0725000000000000, 0.0700000000000000, 0.0674999999999999, 0.0649999999999999, 0.0624999999999999, 0.0599999999999999, 0.0574999999999999, 0.0549999999999999, 0.0524999999999999, 0.0499999999999999 ; ... % u2
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1050000000000000, 0.1100000000000000, 0.1150000000000000, 0.1200000000000000, 0.1250000000000000, 0.1300000000000000, 0.1350000000000000, 0.1400000000000000, 0.1450000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2525000000000001, 0.2550000000000001, 0.2575000000000001, 0.2600000000000001, 0.2625000000000001, 0.2650000000000001, 0.2675000000000001, 0.2700000000000001, 0.2725000000000001, 0.2750000000000001, 0.2775000000000001, 0.2800000000000001, 0.2825000000000001, 0.2850000000000001, 0.2875000000000001, 0.2900000000000001, 0.2925000000000001, 0.2950000000000002, 0.2975000000000002, 0.3000000000000002, 0.3025000000000002, 0.3050000000000002, 0.3075000000000002, 0.3100000000000002, 0.3125000000000002, 0.3150000000000002, 0.3175000000000002, 0.3200000000000002, 0.3225000000000002, 0.3250000000000002, 0.3275000000000002, 0.3300000000000002, 0.3325000000000002, 0.3350000000000002, 0.3375000000000002, 0.3400000000000002, 0.3425000000000002, 0.3450000000000002, 0.3475000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3475000000000002, 0.3450000000000002, 0.3425000000000002, 0.3400000000000002, 0.3375000000000002, 0.3350000000000002, 0.3325000000000002, 0.3300000000000002, 0.3275000000000002, 0.3250000000000002, 0.3225000000000002, 0.3200000000000002, 0.3175000000000002, 0.3150000000000002, 0.3125000000000002, 0.3100000000000002, 0.3075000000000002, 0.3050000000000002, 0.3025000000000002, 0.3000000000000002, 0.2975000000000002, 0.2950000000000002, 0.2925000000000001, 0.2900000000000001, 0.2875000000000001, 0.2850000000000001, 0.2825000000000001, 0.2800000000000001, 0.2775000000000001, 0.2750000000000001, 0.2725000000000001, 0.2700000000000001, 0.2675000000000001, 0.2650000000000001, 0.2625000000000001, 0.2600000000000001, 0.2575000000000001, 0.2550000000000001, 0.2525000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001 ; ... % u3
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2050000000000001, 0.2100000000000001, 0.2150000000000001, 0.2200000000000001, 0.2250000000000001, 0.2300000000000001, 0.2350000000000001, 0.2400000000000001, 0.2450000000000001, 0.2500000000000001, 0.2575000000000001, 0.2650000000000001, 0.2725000000000001, 0.2800000000000001, 0.2875000000000001, 0.2950000000000002, 0.3025000000000002, 0.3100000000000002, 0.3175000000000002, 0.3250000000000002, 0.3325000000000002, 0.3400000000000002, 0.3475000000000002, 0.3550000000000002, 0.3625000000000002, 0.3700000000000002, 0.3775000000000002, 0.3850000000000002, 0.3925000000000002, 0.4000000000000002, 0.4050000000000002, 0.4100000000000003, 0.4150000000000003, 0.4200000000000003, 0.4250000000000003, 0.4300000000000003, 0.4350000000000003, 0.4400000000000003, 0.4450000000000003, 0.4500000000000003, 0.4550000000000003, 0.4600000000000003, 0.4650000000000003, 0.4700000000000003, 0.4750000000000003, 0.4800000000000003, 0.4850000000000003, 0.4900000000000003, 0.4950000000000003, 0.5000000000000003, 0.5025000000000003, 0.5050000000000002, 0.5075000000000002, 0.5100000000000001, 0.5125000000000001, 0.5150000000000000, 0.5175000000000000, 0.5199999999999999, 0.5224999999999999, 0.5249999999999998, 0.5274999999999997, 0.5299999999999997, 0.5324999999999996, 0.5349999999999996, 0.5374999999999995, 0.5399999999999995, 0.5424999999999994, 0.5449999999999994, 0.5474999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5474999999999993, 0.5449999999999994, 0.5424999999999994, 0.5399999999999995, 0.5374999999999995, 0.5349999999999996, 0.5324999999999996, 0.5299999999999997, 0.5274999999999997, 0.5249999999999998, 0.5224999999999999, 0.5199999999999999, 0.5175000000000000, 0.5150000000000000, 0.5125000000000001, 0.5100000000000001, 0.5075000000000002, 0.5050000000000002, 0.5025000000000003, 0.5000000000000003, 0.4925000000000003, 0.4850000000000003, 0.4775000000000003, 0.4700000000000003, 0.4625000000000003, 0.4550000000000003, 0.4475000000000003, 0.4400000000000003, 0.4325000000000003, 0.4250000000000003, 0.4175000000000003, 0.4100000000000003, 0.4025000000000002, 0.3950000000000002, 0.3875000000000002, 0.3800000000000002, 0.3725000000000002, 0.3650000000000002, 0.3575000000000002, 0.3500000000000002, 0.3425000000000002, 0.3350000000000002, 0.3275000000000002, 0.3200000000000002, 0.3125000000000002, 0.3050000000000002, 0.2975000000000002, 0.2900000000000001, 0.2825000000000001, 0.2750000000000001, 0.2675000000000001, 0.2600000000000001, 0.2525000000000001, 0.2450000000000001, 0.2375000000000001, 0.2300000000000001, 0.2225000000000001, 0.2150000000000001, 0.2075000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000 ; ... % u4
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1525000000000001, 0.1550000000000001, 0.1575000000000001, 0.1600000000000001, 0.1625000000000001, 0.1650000000000001, 0.1675000000000001, 0.1700000000000001, 0.1725000000000001, 0.1750000000000001, 0.1775000000000001, 0.1800000000000001, 0.1825000000000001, 0.1850000000000001, 0.1875000000000001, 0.1900000000000001, 0.1925000000000001, 0.1950000000000001, 0.1975000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000, 0.1475000000000000, 0.1450000000000000, 0.1425000000000000, 0.1400000000000000, 0.1375000000000000, 0.1350000000000000, 0.1325000000000000, 0.1300000000000000, 0.1275000000000000, 0.1250000000000000, 0.1225000000000000, 0.1200000000000000, 0.1175000000000000, 0.1150000000000000, 0.1125000000000000, 0.1100000000000000, 0.1075000000000000, 0.1050000000000000, 0.1025000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.0975000000000000, 0.0950000000000000, 0.0925000000000000, 0.0900000000000000, 0.0875000000000000, 0.0850000000000000, 0.0825000000000000, 0.0800000000000000, 0.0775000000000000, 0.0750000000000000, 0.0725000000000000, 0.0700000000000000, 0.0674999999999999, 0.0649999999999999, 0.0624999999999999, 0.0599999999999999, 0.0574999999999999, 0.0549999999999999, 0.0524999999999999, 0.0499999999999999 ; ... % u5
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1050000000000000, 0.1100000000000000, 0.1150000000000000, 0.1200000000000000, 0.1250000000000000, 0.1300000000000000, 0.1350000000000000, 0.1400000000000000, 0.1450000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2525000000000001, 0.2550000000000001, 0.2575000000000001, 0.2600000000000001, 0.2625000000000001, 0.2650000000000001, 0.2675000000000001, 0.2700000000000001, 0.2725000000000001, 0.2750000000000001, 0.2775000000000001, 0.2800000000000001, 0.2825000000000001, 0.2850000000000001, 0.2875000000000001, 0.2900000000000001, 0.2925000000000001, 0.2950000000000002, 0.2975000000000002, 0.3000000000000002, 0.3025000000000002, 0.3050000000000002, 0.3075000000000002, 0.3100000000000002, 0.3125000000000002, 0.3150000000000002, 0.3175000000000002, 0.3200000000000002, 0.3225000000000002, 0.3250000000000002, 0.3275000000000002, 0.3300000000000002, 0.3325000000000002, 0.3350000000000002, 0.3375000000000002, 0.3400000000000002, 0.3425000000000002, 0.3450000000000002, 0.3475000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3475000000000002, 0.3450000000000002, 0.3425000000000002, 0.3400000000000002, 0.3375000000000002, 0.3350000000000002, 0.3325000000000002, 0.3300000000000002, 0.3275000000000002, 0.3250000000000002, 0.3225000000000002, 0.3200000000000002, 0.3175000000000002, 0.3150000000000002, 0.3125000000000002, 0.3100000000000002, 0.3075000000000002, 0.3050000000000002, 0.3025000000000002, 0.3000000000000002, 0.2975000000000002, 0.2950000000000002, 0.2925000000000001, 0.2900000000000001, 0.2875000000000001, 0.2850000000000001, 0.2825000000000001, 0.2800000000000001, 0.2775000000000001, 0.2750000000000001, 0.2725000000000001, 0.2700000000000001, 0.2675000000000001, 0.2650000000000001, 0.2625000000000001, 0.2600000000000001, 0.2575000000000001, 0.2550000000000001, 0.2525000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001 ; ... % u6
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2050000000000001, 0.2100000000000001, 0.2150000000000001, 0.2200000000000001, 0.2250000000000001, 0.2300000000000001, 0.2350000000000001, 0.2400000000000001, 0.2450000000000001, 0.2500000000000001, 0.2575000000000001, 0.2650000000000001, 0.2725000000000001, 0.2800000000000001, 0.2875000000000001, 0.2950000000000002, 0.3025000000000002, 0.3100000000000002, 0.3175000000000002, 0.3250000000000002, 0.3325000000000002, 0.3400000000000002, 0.3475000000000002, 0.3550000000000002, 0.3625000000000002, 0.3700000000000002, 0.3775000000000002, 0.3850000000000002, 0.3925000000000002, 0.4000000000000002, 0.4050000000000002, 0.4100000000000003, 0.4150000000000003, 0.4200000000000003, 0.4250000000000003, 0.4300000000000003, 0.4350000000000003, 0.4400000000000003, 0.4450000000000003, 0.4500000000000003, 0.4550000000000003, 0.4600000000000003, 0.4650000000000003, 0.4700000000000003, 0.4750000000000003, 0.4800000000000003, 0.4850000000000003, 0.4900000000000003, 0.4950000000000003, 0.5000000000000003, 0.5025000000000003, 0.5050000000000002, 0.5075000000000002, 0.5100000000000001, 0.5125000000000001, 0.5150000000000000, 0.5175000000000000, 0.5199999999999999, 0.5224999999999999, 0.5249999999999998, 0.5274999999999997, 0.5299999999999997, 0.5324999999999996, 0.5349999999999996, 0.5374999999999995, 0.5399999999999995, 0.5424999999999994, 0.5449999999999994, 0.5474999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5474999999999993, 0.5449999999999994, 0.5424999999999994, 0.5399999999999995, 0.5374999999999995, 0.5349999999999996, 0.5324999999999996, 0.5299999999999997, 0.5274999999999997, 0.5249999999999998, 0.5224999999999999, 0.5199999999999999, 0.5175000000000000, 0.5150000000000000, 0.5125000000000001, 0.5100000000000001, 0.5075000000000002, 0.5050000000000002, 0.5025000000000003, 0.5000000000000003, 0.4925000000000003, 0.4850000000000003, 0.4775000000000003, 0.4700000000000003, 0.4625000000000003, 0.4550000000000003, 0.4475000000000003, 0.4400000000000003, 0.4325000000000003, 0.4250000000000003, 0.4175000000000003, 0.4100000000000003, 0.4025000000000002, 0.3950000000000002, 0.3875000000000002, 0.3800000000000002, 0.3725000000000002, 0.3650000000000002, 0.3575000000000002, 0.3500000000000002, 0.3425000000000002, 0.3350000000000002, 0.3275000000000002, 0.3200000000000002, 0.3125000000000002, 0.3050000000000002, 0.2975000000000002, 0.2900000000000001, 0.2825000000000001, 0.2750000000000001, 0.2675000000000001, 0.2600000000000001, 0.2525000000000001, 0.2450000000000001, 0.2375000000000001, 0.2300000000000001, 0.2225000000000001, 0.2150000000000001, 0.2075000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000 ; ... % u7
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1525000000000001, 0.1550000000000001, 0.1575000000000001, 0.1600000000000001, 0.1625000000000001, 0.1650000000000001, 0.1675000000000001, 0.1700000000000001, 0.1725000000000001, 0.1750000000000001, 0.1775000000000001, 0.1800000000000001, 0.1825000000000001, 0.1850000000000001, 0.1875000000000001, 0.1900000000000001, 0.1925000000000001, 0.1950000000000001, 0.1975000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000, 0.1475000000000000, 0.1450000000000000, 0.1425000000000000, 0.1400000000000000, 0.1375000000000000, 0.1350000000000000, 0.1325000000000000, 0.1300000000000000, 0.1275000000000000, 0.1250000000000000, 0.1225000000000000, 0.1200000000000000, 0.1175000000000000, 0.1150000000000000, 0.1125000000000000, 0.1100000000000000, 0.1075000000000000, 0.1050000000000000, 0.1025000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.0975000000000000, 0.0950000000000000, 0.0925000000000000, 0.0900000000000000, 0.0875000000000000, 0.0850000000000000, 0.0825000000000000, 0.0800000000000000, 0.0775000000000000, 0.0750000000000000, 0.0725000000000000, 0.0700000000000000, 0.0674999999999999, 0.0649999999999999, 0.0624999999999999, 0.0599999999999999, 0.0574999999999999, 0.0549999999999999, 0.0524999999999999, 0.0499999999999999 ; ... % u8
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1050000000000000, 0.1100000000000000, 0.1150000000000000, 0.1200000000000000, 0.1250000000000000, 0.1300000000000000, 0.1350000000000000, 0.1400000000000000, 0.1450000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2525000000000001, 0.2550000000000001, 0.2575000000000001, 0.2600000000000001, 0.2625000000000001, 0.2650000000000001, 0.2675000000000001, 0.2700000000000001, 0.2725000000000001, 0.2750000000000001, 0.2775000000000001, 0.2800000000000001, 0.2825000000000001, 0.2850000000000001, 0.2875000000000001, 0.2900000000000001, 0.2925000000000001, 0.2950000000000002, 0.2975000000000002, 0.3000000000000002, 0.3025000000000002, 0.3050000000000002, 0.3075000000000002, 0.3100000000000002, 0.3125000000000002, 0.3150000000000002, 0.3175000000000002, 0.3200000000000002, 0.3225000000000002, 0.3250000000000002, 0.3275000000000002, 0.3300000000000002, 0.3325000000000002, 0.3350000000000002, 0.3375000000000002, 0.3400000000000002, 0.3425000000000002, 0.3450000000000002, 0.3475000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3475000000000002, 0.3450000000000002, 0.3425000000000002, 0.3400000000000002, 0.3375000000000002, 0.3350000000000002, 0.3325000000000002, 0.3300000000000002, 0.3275000000000002, 0.3250000000000002, 0.3225000000000002, 0.3200000000000002, 0.3175000000000002, 0.3150000000000002, 0.3125000000000002, 0.3100000000000002, 0.3075000000000002, 0.3050000000000002, 0.3025000000000002, 0.3000000000000002, 0.2975000000000002, 0.2950000000000002, 0.2925000000000001, 0.2900000000000001, 0.2875000000000001, 0.2850000000000001, 0.2825000000000001, 0.2800000000000001, 0.2775000000000001, 0.2750000000000001, 0.2725000000000001, 0.2700000000000001, 0.2675000000000001, 0.2650000000000001, 0.2625000000000001, 0.2600000000000001, 0.2575000000000001, 0.2550000000000001, 0.2525000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001 ; ... % u9
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2050000000000001, 0.2100000000000001, 0.2150000000000001, 0.2200000000000001, 0.2250000000000001, 0.2300000000000001, 0.2350000000000001, 0.2400000000000001, 0.2450000000000001, 0.2500000000000001, 0.2575000000000001, 0.2650000000000001, 0.2725000000000001, 0.2800000000000001, 0.2875000000000001, 0.2950000000000002, 0.3025000000000002, 0.3100000000000002, 0.3175000000000002, 0.3250000000000002, 0.3325000000000002, 0.3400000000000002, 0.3475000000000002, 0.3550000000000002, 0.3625000000000002, 0.3700000000000002, 0.3775000000000002, 0.3850000000000002, 0.3925000000000002, 0.4000000000000002, 0.4050000000000002, 0.4100000000000003, 0.4150000000000003, 0.4200000000000003, 0.4250000000000003, 0.4300000000000003, 0.4350000000000003, 0.4400000000000003, 0.4450000000000003, 0.4500000000000003, 0.4550000000000003, 0.4600000000000003, 0.4650000000000003, 0.4700000000000003, 0.4750000000000003, 0.4800000000000003, 0.4850000000000003, 0.4900000000000003, 0.4950000000000003, 0.5000000000000003, 0.5025000000000003, 0.5050000000000002, 0.5075000000000002, 0.5100000000000001, 0.5125000000000001, 0.5150000000000000, 0.5175000000000000, 0.5199999999999999, 0.5224999999999999, 0.5249999999999998, 0.5274999999999997, 0.5299999999999997, 0.5324999999999996, 0.5349999999999996, 0.5374999999999995, 0.5399999999999995, 0.5424999999999994, 0.5449999999999994, 0.5474999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5474999999999993, 0.5449999999999994, 0.5424999999999994, 0.5399999999999995, 0.5374999999999995, 0.5349999999999996, 0.5324999999999996, 0.5299999999999997, 0.5274999999999997, 0.5249999999999998, 0.5224999999999999, 0.5199999999999999, 0.5175000000000000, 0.5150000000000000, 0.5125000000000001, 0.5100000000000001, 0.5075000000000002, 0.5050000000000002, 0.5025000000000003, 0.5000000000000003, 0.4925000000000003, 0.4850000000000003, 0.4775000000000003, 0.4700000000000003, 0.4625000000000003, 0.4550000000000003, 0.4475000000000003, 0.4400000000000003, 0.4325000000000003, 0.4250000000000003, 0.4175000000000003, 0.4100000000000003, 0.4025000000000002, 0.3950000000000002, 0.3875000000000002, 0.3800000000000002, 0.3725000000000002, 0.3650000000000002, 0.3575000000000002, 0.3500000000000002, 0.3425000000000002, 0.3350000000000002, 0.3275000000000002, 0.3200000000000002, 0.3125000000000002, 0.3050000000000002, 0.2975000000000002, 0.2900000000000001, 0.2825000000000001, 0.2750000000000001, 0.2675000000000001, 0.2600000000000001, 0.2525000000000001, 0.2450000000000001, 0.2375000000000001, 0.2300000000000001, 0.2225000000000001, 0.2150000000000001, 0.2075000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000 ; ... % u10
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1525000000000001, 0.1550000000000001, 0.1575000000000001, 0.1600000000000001, 0.1625000000000001, 0.1650000000000001, 0.1675000000000001, 0.1700000000000001, 0.1725000000000001, 0.1750000000000001, 0.1775000000000001, 0.1800000000000001, 0.1825000000000001, 0.1850000000000001, 0.1875000000000001, 0.1900000000000001, 0.1925000000000001, 0.1950000000000001, 0.1975000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000, 0.1475000000000000, 0.1450000000000000, 0.1425000000000000, 0.1400000000000000, 0.1375000000000000, 0.1350000000000000, 0.1325000000000000, 0.1300000000000000, 0.1275000000000000, 0.1250000000000000, 0.1225000000000000, 0.1200000000000000, 0.1175000000000000, 0.1150000000000000, 0.1125000000000000, 0.1100000000000000, 0.1075000000000000, 0.1050000000000000, 0.1025000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.0975000000000000, 0.0950000000000000, 0.0925000000000000, 0.0900000000000000, 0.0875000000000000, 0.0850000000000000, 0.0825000000000000, 0.0800000000000000, 0.0775000000000000, 0.0750000000000000, 0.0725000000000000, 0.0700000000000000, 0.0674999999999999, 0.0649999999999999, 0.0624999999999999, 0.0599999999999999, 0.0574999999999999, 0.0549999999999999, 0.0524999999999999, 0.0499999999999999 ; ... % u11
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1050000000000000, 0.1100000000000000, 0.1150000000000000, 0.1200000000000000, 0.1250000000000000, 0.1300000000000000, 0.1350000000000000, 0.1400000000000000, 0.1450000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2525000000000001, 0.2550000000000001, 0.2575000000000001, 0.2600000000000001, 0.2625000000000001, 0.2650000000000001, 0.2675000000000001, 0.2700000000000001, 0.2725000000000001, 0.2750000000000001, 0.2775000000000001, 0.2800000000000001, 0.2825000000000001, 0.2850000000000001, 0.2875000000000001, 0.2900000000000001, 0.2925000000000001, 0.2950000000000002, 0.2975000000000002, 0.3000000000000002, 0.3025000000000002, 0.3050000000000002, 0.3075000000000002, 0.3100000000000002, 0.3125000000000002, 0.3150000000000002, 0.3175000000000002, 0.3200000000000002, 0.3225000000000002, 0.3250000000000002, 0.3275000000000002, 0.3300000000000002, 0.3325000000000002, 0.3350000000000002, 0.3375000000000002, 0.3400000000000002, 0.3425000000000002, 0.3450000000000002, 0.3475000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3475000000000002, 0.3450000000000002, 0.3425000000000002, 0.3400000000000002, 0.3375000000000002, 0.3350000000000002, 0.3325000000000002, 0.3300000000000002, 0.3275000000000002, 0.3250000000000002, 0.3225000000000002, 0.3200000000000002, 0.3175000000000002, 0.3150000000000002, 0.3125000000000002, 0.3100000000000002, 0.3075000000000002, 0.3050000000000002, 0.3025000000000002, 0.3000000000000002, 0.2975000000000002, 0.2950000000000002, 0.2925000000000001, 0.2900000000000001, 0.2875000000000001, 0.2850000000000001, 0.2825000000000001, 0.2800000000000001, 0.2775000000000001, 0.2750000000000001, 0.2725000000000001, 0.2700000000000001, 0.2675000000000001, 0.2650000000000001, 0.2625000000000001, 0.2600000000000001, 0.2575000000000001, 0.2550000000000001, 0.2525000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001 ; ... % u12
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2050000000000001, 0.2100000000000001, 0.2150000000000001, 0.2200000000000001, 0.2250000000000001, 0.2300000000000001, 0.2350000000000001, 0.2400000000000001, 0.2450000000000001, 0.2500000000000001, 0.2575000000000001, 0.2650000000000001, 0.2725000000000001, 0.2800000000000001, 0.2875000000000001, 0.2950000000000002, 0.3025000000000002, 0.3100000000000002, 0.3175000000000002, 0.3250000000000002, 0.3325000000000002, 0.3400000000000002, 0.3475000000000002, 0.3550000000000002, 0.3625000000000002, 0.3700000000000002, 0.3775000000000002, 0.3850000000000002, 0.3925000000000002, 0.4000000000000002, 0.4050000000000002, 0.4100000000000003, 0.4150000000000003, 0.4200000000000003, 0.4250000000000003, 0.4300000000000003, 0.4350000000000003, 0.4400000000000003, 0.4450000000000003, 0.4500000000000003, 0.4550000000000003, 0.4600000000000003, 0.4650000000000003, 0.4700000000000003, 0.4750000000000003, 0.4800000000000003, 0.4850000000000003, 0.4900000000000003, 0.4950000000000003, 0.5000000000000003, 0.5025000000000003, 0.5050000000000002, 0.5075000000000002, 0.5100000000000001, 0.5125000000000001, 0.5150000000000000, 0.5175000000000000, 0.5199999999999999, 0.5224999999999999, 0.5249999999999998, 0.5274999999999997, 0.5299999999999997, 0.5324999999999996, 0.5349999999999996, 0.5374999999999995, 0.5399999999999995, 0.5424999999999994, 0.5449999999999994, 0.5474999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5499999999999993, 0.5474999999999993, 0.5449999999999994, 0.5424999999999994, 0.5399999999999995, 0.5374999999999995, 0.5349999999999996, 0.5324999999999996, 0.5299999999999997, 0.5274999999999997, 0.5249999999999998, 0.5224999999999999, 0.5199999999999999, 0.5175000000000000, 0.5150000000000000, 0.5125000000000001, 0.5100000000000001, 0.5075000000000002, 0.5050000000000002, 0.5025000000000003, 0.5000000000000003, 0.4925000000000003, 0.4850000000000003, 0.4775000000000003, 0.4700000000000003, 0.4625000000000003, 0.4550000000000003, 0.4475000000000003, 0.4400000000000003, 0.4325000000000003, 0.4250000000000003, 0.4175000000000003, 0.4100000000000003, 0.4025000000000002, 0.3950000000000002, 0.3875000000000002, 0.3800000000000002, 0.3725000000000002, 0.3650000000000002, 0.3575000000000002, 0.3500000000000002, 0.3425000000000002, 0.3350000000000002, 0.3275000000000002, 0.3200000000000002, 0.3125000000000002, 0.3050000000000002, 0.2975000000000002, 0.2900000000000001, 0.2825000000000001, 0.2750000000000001, 0.2675000000000001, 0.2600000000000001, 0.2525000000000001, 0.2450000000000001, 0.2375000000000001, 0.2300000000000001, 0.2225000000000001, 0.2150000000000001, 0.2075000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000 ; ... % u13
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1025000000000000, 0.1050000000000000, 0.1075000000000000, 0.1100000000000000, 0.1125000000000000, 0.1150000000000000, 0.1175000000000000, 0.1200000000000000, 0.1225000000000000, 0.1250000000000000, 0.1275000000000000, 0.1300000000000000, 0.1325000000000000, 0.1350000000000000, 0.1375000000000000, 0.1400000000000000, 0.1425000000000000, 0.1450000000000000, 0.1475000000000000, 0.1500000000000000, 0.1525000000000001, 0.1550000000000001, 0.1575000000000001, 0.1600000000000001, 0.1625000000000001, 0.1650000000000001, 0.1675000000000001, 0.1700000000000001, 0.1725000000000001, 0.1750000000000001, 0.1775000000000001, 0.1800000000000001, 0.1825000000000001, 0.1850000000000001, 0.1875000000000001, 0.1900000000000001, 0.1925000000000001, 0.1950000000000001, 0.1975000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.1975000000000001, 0.1950000000000001, 0.1925000000000001, 0.1900000000000001, 0.1875000000000001, 0.1850000000000001, 0.1825000000000001, 0.1800000000000000, 0.1775000000000000, 0.1750000000000000, 0.1725000000000000, 0.1700000000000000, 0.1675000000000000, 0.1650000000000000, 0.1625000000000000, 0.1600000000000000, 0.1575000000000000, 0.1550000000000000, 0.1525000000000000, 0.1500000000000000, 0.1475000000000000, 0.1450000000000000, 0.1425000000000000, 0.1400000000000000, 0.1375000000000000, 0.1350000000000000, 0.1325000000000000, 0.1300000000000000, 0.1275000000000000, 0.1250000000000000, 0.1225000000000000, 0.1200000000000000, 0.1175000000000000, 0.1150000000000000, 0.1125000000000000, 0.1100000000000000, 0.1075000000000000, 0.1050000000000000, 0.1025000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.0975000000000000, 0.0950000000000000, 0.0925000000000000, 0.0900000000000000, 0.0875000000000000, 0.0850000000000000, 0.0825000000000000, 0.0800000000000000, 0.0775000000000000, 0.0750000000000000, 0.0725000000000000, 0.0700000000000000, 0.0674999999999999, 0.0649999999999999, 0.0624999999999999, 0.0599999999999999, 0.0574999999999999, 0.0549999999999999, 0.0524999999999999, 0.0499999999999999 ; ... % u14
 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1000000000000000, 0.1050000000000000, 0.1100000000000000, 0.1150000000000000, 0.1200000000000000, 0.1250000000000000, 0.1300000000000000, 0.1350000000000000, 0.1400000000000000, 0.1450000000000000, 0.1500000000000000, 0.1550000000000001, 0.1600000000000001, 0.1650000000000001, 0.1700000000000001, 0.1750000000000001, 0.1800000000000001, 0.1850000000000001, 0.1900000000000001, 0.1950000000000001, 0.2000000000000001, 0.2025000000000001, 0.2050000000000001, 0.2075000000000001, 0.2100000000000001, 0.2125000000000001, 0.2150000000000001, 0.2175000000000001, 0.2200000000000001, 0.2225000000000001, 0.2250000000000001, 0.2275000000000001, 0.2300000000000001, 0.2325000000000001, 0.2350000000000001, 0.2375000000000001, 0.2400000000000001, 0.2425000000000001, 0.2450000000000001, 0.2475000000000001, 0.2500000000000001, 0.2525000000000001, 0.2550000000000001, 0.2575000000000001, 0.2600000000000001, 0.2625000000000001, 0.2650000000000001, 0.2675000000000001, 0.2700000000000001, 0.2725000000000001, 0.2750000000000001, 0.2775000000000001, 0.2800000000000001, 0.2825000000000001, 0.2850000000000001, 0.2875000000000001, 0.2900000000000001, 0.2925000000000001, 0.2950000000000002, 0.2975000000000002, 0.3000000000000002, 0.3025000000000002, 0.3050000000000002, 0.3075000000000002, 0.3100000000000002, 0.3125000000000002, 0.3150000000000002, 0.3175000000000002, 0.3200000000000002, 0.3225000000000002, 0.3250000000000002, 0.3275000000000002, 0.3300000000000002, 0.3325000000000002, 0.3350000000000002, 0.3375000000000002, 0.3400000000000002, 0.3425000000000002, 0.3450000000000002, 0.3475000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3500000000000002, 0.3475000000000002, 0.3450000000000002, 0.3425000000000002, 0.3400000000000002, 0.3375000000000002, 0.3350000000000002, 0.3325000000000002, 0.3300000000000002, 0.3275000000000002, 0.3250000000000002, 0.3225000000000002, 0.3200000000000002, 0.3175000000000002, 0.3150000000000002, 0.3125000000000002, 0.3100000000000002, 0.3075000000000002, 0.3050000000000002, 0.3025000000000002, 0.3000000000000002, 0.2975000000000002, 0.2950000000000002, 0.2925000000000001, 0.2900000000000001, 0.2875000000000001, 0.2850000000000001, 0.2825000000000001, 0.2800000000000001, 0.2775000000000001, 0.2750000000000001, 0.2725000000000001, 0.2700000000000001, 0.2675000000000001, 0.2650000000000001, 0.2625000000000001, 0.2600000000000001, 0.2575000000000001, 0.2550000000000001, 0.2525000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2500000000000001, 0.2475000000000001, 0.2450000000000001, 0.2425000000000001, 0.2400000000000001, 0.2375000000000001, 0.2350000000000001, 0.2325000000000001, 0.2300000000000001, 0.2275000000000001, 0.2250000000000001, 0.2225000000000001, 0.2200000000000001, 0.2175000000000001, 0.2150000000000001, 0.2125000000000001, 0.2100000000000001, 0.2075000000000001, 0.2050000000000001, 0.2025000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001, 0.2000000000000001 ; ... % u15
 ], ...
    'y', [ ... % y
 0.4085787281703583, 0.5039625480736031, 0.2814143413228615, 0.2659770180617845, 0.4976753631270400, 0.2917602064142896, 0.5566246653496624, 0.5345357601820048, 0.5123776149047942, 0.5583754663191974, 0.6771402376375031, 0.6738278197657581, 0.5728877751927837, 0.6328888817743918, 0.6543259476490106, 1.0016607115435565, 0.8323946260838831, 0.9488725485321212, 1.1727981444913655, 1.2520839457178319, 1.1159244992021335, 1.2719612868126577, 1.2485864065184058, 1.1554532521875285, 1.3193777817652397, 1.3418991262233770, 1.4090316370614289, 1.4554313794632168, 1.5030666572861779, 1.7050668024902578, 1.4723314022839236, 1.6762617512450479, 1.9244538218467200, 1.9162088169067699, 1.7432856875199680, 2.0549424411254460, 1.9858272757220208, 2.1599348748398368, 2.2393411203922815, 2.3744544294995920, 2.3393810921205787, 2.5207785035646753, 2.3380137111178958, 2.4679317650212780, 2.5972866190265251, 2.5601072372106612, 2.6528078290286885, 2.9070891979827511, 2.8616495961005346, 3.0110041328120065, 3.2607944377398699, 3.2648987052962393, 3.2991988883097143, 3.4111211418326741, 3.4425193484450709, 3.7900445013111823, 3.9059473274328731, 4.0340354030139407, 4.1230530363719717, 4.0418762801171777, 4.0805252692314316, 4.4564503804305264, 4.4004218073661248, 4.7791367997202219, 4.7404062972393115, 4.8135831750700220, 5.1348991777839066, 5.2527080016616043, 5.4383650855966472, 5.5929426010514005, 5.5914132005808401, 5.5895524830605074, 5.8732672150164662, 6.0028304139852882, 6.2595452132235954, 6.2830873981279005, 6.5109948134637126, 6.8459135969262528, 7.0564458737543978, 7.1412610648623742, 7.3771674210699434, 7.5768267868394004, 7.6832513148814652, 7.8073888013863790, 8.1388099893364885, 8.3336313617388686, 8.4749207770641117, 8.6534174946333700, 8.8292310607731075, 8.9586238102994109, 9.1661838033787291, 9.5275374202268601, 9.5707186441004932, 9.9976727605558597, 9.8549643670985230, 10.2684061516379099, 10.3046441760216823, 10.6173179913734295, 10.7663069121856072, 11.0869296871121303, 11.4814760524803354, 11.5765717369476491, 11.7943817007716074, 11.9102264904374699, 12.2011678592482600, 12.3812251860063309, 12.5283954735514822, 12.9719059598474651, 13.1586434345050929, 13.4265419449772825, 13.4260983177955051, 13.6868986151467631, 13.9098911560137051, 14.2311901144975312, 14.4156186581085102, 14.5150472014882741, 14.8490602438478216, 15.1875905649050953, 15.5063957089904019, 15.4781798317236348, 15.6388201136395431, 16.0708510499864587, 16.1966349053217868, 16.4009522893186492, 16.7129600930692312, 16.9865001874766257, 17.1368180471722731, 17.1378559898032918, 17.6680078733937442, 17.6632253449290459, 18.0125390689818836, 18.0650041312426062, 18.5156609442014179, 18.7919248890037522, 18.7590602101202180, 18.8986513793196522, 19.1431168424635949, 19.6294199427341098, 19.8237290779950222, 20.0209813148716265, 19.9036972461297950, 20.3236809158515150, 20.6376516677402400, 20.7220391336289964, 21.0488711377625144, 21.0564760721629973, 21.2232027304603079, 21.3342416853007180, 21.7127571405126538, 21.8046246746990455, 22.0287182167556281, 22.2654964764362617, 22.4801694946521309, 22.5466712106494178, 22.8266923245420799, 23.1069307827103607, 22.9350336590189130, 23.2834910948331846, 23.6070426755661948, 23.5113268448473889, 23.7910692765739320, 23.9146119844417591, 24.0658362351270476, 24.4384600264858420, 24.3384089330583855, 24.6989407873075137, 24.6506985600633044, 24.7813056344833420, 24.8457042068928153, 25.2067816458180758, 25.1890777297513928, 25.3324042468931907, 25.1992305210959202, 25.4257997400035229, 25.7765039031157954, 25.6877516027240276, 25.6894331110448348, 25.9283469574222245, 26.0245876656054627, 26.0823327084199512, 26.1541589071564147, 26.2506926441445749, 26.1697018193750814, 26.2852552937349344, 26.4521965465409394, 26.4344417146865212, 26.3240010885371447, 26.3943937552499861, 26.6616924932671111, 26.6100950519379680, 26.5744688387979480, 26.8522432410025402, 26.5942977989763421, 26.7590931295117009, 26.8657822876699335, 26.6017439477026194, 26.8159877881067779, 26.6681221352276552, 26.6165072518132035, 26.7338028665566938, 26.7351435157909982, 26.6594327368560720, 26.8771169267855967, 26.7675402373011586, 26.8338294398251413, 26.7516264953217835, 26.8314231537376280, 26.6700560239753379, 26.8035178888632899, 26.8384560747459773, 26.7123701672215859, 26.6506357525442859, 26.8199001562023085, 26.8135451860973149, 26.7712862234019937, 26.8554395873411806, 26.8173048946094923, 26.8545168792979041, 26.9043680564112755, 26.6728346883101324, 26.7743920424707440, 26.9351790064675178, 26.7401731276340939, 26.6228166871940104, 26.7953094638657312, 26.6594320788742856, 26.6013074488201511, 26.6842425189985768, 26.6319835610815474, 26.5806810844487273, 26.7783158510415227, 26.6594839279336782, 26.6981238108544403, 26.4949924580754796, 26.4989908734220627 ; ... % y1
 2.0013561668612407, 2.1384434556525247, 2.2304794268604202, 2.0821395111231689, 2.0506614797640559, 2.0937491385777536, 2.1095516453687049, 2.0066366250419199, 2.0537260164575590, 2.1837024119468125, 2.0174735162192485, 2.3139624822288565, 2.2621499105653928, 2.0830186254720151, 2.0579494120724742, 2.0807729938453656, 2.1815327284037647, 2.2650896720502489, 2.0443001263877401, 2.2098021143331650, 2.1588052866055367, 2.0712584658341942, 2.1607316976494393, 2.1104479097109143, 2.1445685393534824, 2.1186872236472323, 2.2387925989556590, 2.2495037366771613, 2.2772612892619088, 2.1052480156910685, 2.2818072165426977, 2.2719458319193921, 2.1693487058529399, 2.1044234600171920, 2.2080347982026498, 2.2012556894144466, 2.1774570645700297, 2.1372681890797565, 2.2083652351687388, 2.2782850664286594, 2.0836770296887703, 2.0602286536304657, 2.2315157262454393, 2.1074412781050476, 2.3096870293369296, 2.1530998346721626, 2.4212840281553110, 2.3713821190506055, 2.3912221585698337, 2.3695744220731831, 2.2254896656527734, 2.4390110727713892, 2.2265014654938931, 2.1283314659440009, 2.3529207225510982, 2.3707172963271321, 2.2352508608214583, 2.3816066498426154, 2.4981920482171955, 2.3287439045725957, 2.2960994471847860, 2.1609977173424570, 2.4717071879053125, 2.3060834695468779, 2.2747246066384563, 2.3735177694442386, 2.2704180307299135, 2.4439862787537550, 2.4339922224108061, 2.5049645748169893, 2.4838720422460367, 2.4106033906979953, 2.4440949199721649, 2.4951450519781733, 2.4250892724501361, 2.6151486895929010, 2.3805175130725496, 2.3482074100101866, 2.3499306736806336, 2.3030763717095031, 2.5294558565590308, 2.5711220136536328, 2.4314175126777422, 2.4888649863791379, 2.6845075756058159, 2.5223423165281842, 2.4550479642872864, 2.4145090451022533, 2.6700515736091837, 2.3382881593334255, 2.4391735256510900, 2.4226645646788132, 2.5450895789831018, 2.3732806693153896, 2.4650328459277588, 2.4187787954002520, 2.4659887711494379, 2.4855893452952471, 2.6572603566558284, 2.7124542721739018, 2.6329000964856952, 2.7077606294385976, 2.5870060284386152, 2.5475817312712570, 2.6966516796603694, 2.7755502962672955, 2.6721259089220144, 2.7913945767988841, 2.7502321766022400, 2.7441414930938084, 2.6653685678248471, 2.8448464647401011, 2.7870913616032906, 2.6868299781212333, 2.7123114773226118, 2.6995198478577387, 2.7879936500550428, 2.8439066256818823, 2.8272089849280202, 2.6800648695154137, 2.8807237878685434, 2.6628156683824891, 2.8705634460824268, 2.9299741158104347, 2.8391651688774999, 2.7267958517478097, 2.9380826404790925, 2.8767471670512048, 2.8909926880832630, 3.0593339119967085, 3.1026801579691128, 2.8936239065614382, 3.1435898741165045, 3.0711803546539009, 3.0164322974177367, 2.8674634675158486, 2.9797939141371148, 2.9784708893049396, 3.0032242136696965, 2.9978083446971571, 3.1415416285565585, 3.0443397524344453, 3.0265672683601683, 3.2289950327071795, 3.0982196728746532, 3.3407157258234421, 3.1655735290881521, 3.3464628862227093, 3.2098829384300700, 3.1038615265985552, 3.1389418696015716, 3.2977600501557665, 3.3966672366193600, 3.3324467188467701, 3.4457175378859448, 3.3482937006885130, 3.2692954712812776, 3.3155423305830345, 3.2398425125205925, 3.4752803711581155, 3.4027852382233439, 3.2657604606774870, 3.4564570956863885, 3.4282247815507381, 3.6438143749740224, 3.5244945107175125, 3.6113726775069428, 3.3410184922179260, 3.4963687897441948, 3.5459798179737967, 3.6573596456634809, 3.5892795175957977, 3.5854160241197093, 3.5364952211509797, 3.6764554378728485, 3.6937203670829466, 3.6476728667813645, 3.5676661188178147, 3.7853330398484841, 3.7324807058497904, 3.7150352752968070, 3.7228535749278517, 3.8700137644895634, 3.8592632018580280, 3.9449421715459234, 3.8435143471158479, 3.9186813078419340, 3.9960724560830183, 3.8254138933470645, 3.9519389391909470, 4.0050309689171462, 4.0319292113806648, 4.0374162965142286, 4.0509648777167806, 3.8711107066391728, 4.1122653152772033, 4.2579542044352880, 3.9385408721015098, 4.2379513116170644, 4.1149425577491101, 4.2533350839359256, 4.1830811518040347, 4.0383600689744430, 4.2333433540123737, 4.1092767382733841, 4.2569452055323156, 4.1975318645477051, 4.2669353650521966, 4.4730502982128586, 4.3844880985942885, 4.4952014023803653, 4.4337772671870361, 4.4281951653995817, 4.3009827902306279, 4.6545447150438273, 4.6929395538700458, 4.7447549245335381, 4.7441131152705633, 4.5772351248840364, 4.5458914425766936, 4.8177900978751209, 4.7392867841439061, 4.7997085822497603, 4.7440535865614750, 4.6889182308152728, 4.6522532976452080, 4.9253533021281326, 4.8587281714201813, 4.8075817785319668, 4.9223307551747588, 4.9294465177853590, 4.8155568512704852, 5.0164083912661157, 4.9774389574209339, 5.0479811017334297 ; ... % y2
 -3.8835735401195821, -3.7600405630732294, -3.8176631916609876, -3.8659617706333695, -3.8072326252279738, -3.8705451287859991, -3.8086679013407134, -3.8077545954366592, -3.5203982468933774, -3.6630777092084323, -3.5813779861920683, -3.5901666931047034, -3.5148197368102090, -3.4702654943913203, -3.7054034875577750, -3.5540079001355513, -3.5735073011634668, -3.2619119772185954, -3.4471566881212414, -3.3697613089231728, -3.2886810191706122, -3.2326323196512412, -3.4762463252697016, -3.3503482508527922, -3.2181410042082392, -3.3290099055772413, -3.2427548962114114, -3.3444786051794457, -3.0886563557890025, -3.2559750214492502, -3.2786718613695989, -3.0300545060245869, -3.2278020793941691, -3.2300446476155096, -2.9166260946234899, -2.9948322156584886, -2.9129996562824529, -2.9092863789135235, -2.8929563231098272, -2.9601687619000683, -2.9454374132431762, -2.7227401893302074, -2.9488300945410502, -2.7473576970704650, -2.9637470196232170, -2.8639345492243264, -2.8213429454503012, -2.6251966783240364, -2.6195572052660285, -2.5378513190771987, -2.6623905310385103, -2.8138310167528617, -2.4979073376322458, -2.5265593202688592, -2.6583420757594243, -2.3521683229173331, -2.5629045196742468, -2.4557997913015113, -2.4679352299718182, -2.5095014486414962, -2.3467596009200813, -2.4515270579088644, -2.5314404504150678, -2.4131567319369700, -2.3518310570364545, -2.1750279951074858, -2.3081132450328630, -2.1756816153063867, -2.0956365125864678, -2.0676543712416686, -1.9821548805543368, -2.1261050200805540, -2.1596022716000385, -1.9998620930672202, -2.0969716970875778, -1.8441578207393721, -1.8239190383122232, -2.0001900670438801, -1.9375003158220305, -1.9162504838568812, -1.9104688664368108, -1.9499030270411213, -1.8656950162466288, -1.7467520309207423, -1.9913366982041043, -1.6809481007499818, -1.6109463736827150, -1.7004725448064049, -1.6341044173269970, -1.6328238609344612, -1.7294886776330127, -1.6369278092801607, -1.5757533320555810, -1.6180958902773799, -1.5210123059538478, -1.4792774776807440, -1.4935675236363155, -1.5267676476432670, -1.4440751188438194, -1.4879716269947934, -1.4861832390461709, -1.3625830567078863, -1.4711054235585497, -1.2369058675713605, -1.1337926079921117, -1.3102665555782953, -1.1028197696140001, -1.2838538770124319, -1.2997518076272967, -1.2000202328594749, -1.1588421557147226, -1.0787671096213991, -0.9234005711465468, -0.9544309146484180, -0.9072809893876936, -0.9033276381390840, -0.7999892912134042, -0.8981528852293031, -1.0459702874919037, -0.9552220786185198, -0.9330525327058837, -0.9478915052538041, -0.6695395296236384, -0.7863767070197243, -0.8118493249054389, -0.7295012864274164, -0.7974620318100009, -0.5910861193102537, -0.7101202777784171, -0.7400735886764314, -0.5638756907345152, -0.4976325035058136, -0.5993867507518413, -0.3875155856460540, -0.5836673460585005, -0.3984643076925845, -0.5584449898518528, -0.3977601055182119, -0.3864158494294663, -0.4609173253619842, -0.2305722498517482, -0.4532540359958301, -0.4291625356445279, -0.1445148952882070, -0.3071952606643110, -0.4564554675242730, -0.0615280416139151, -0.0630755018534117, -0.3813977357772627, -0.0914881163675468, -0.1994702257807797, -0.2486693125472400, -0.1388348359043188, -0.1543235654236040, -0.0847733943807469, -0.0082053170640159, -0.0612483625526764, 0.1945173173346961, -0.0350755879181718, -0.0705035375866605, 0.1382338377797712, 0.0757566432656372, 0.1504315633545787, 0.1446594790062952, 0.2014113395374538, 0.1292473441437128, 0.2723308124023238, 0.1099201860730332, 0.2916794267979498, 0.3432520437247789, 0.2813212866920043, 0.3089451009267153, 0.3055454794483542, 0.3962831247032737, 0.4615640066272828, 0.2657560585092154, 0.4983269264316758, 0.4573979128746031, 0.3957566173154773, 0.5534299282884734, 0.4508565156650386, 0.4808871300901716, 0.5208542182356332, 0.5520518911199971, 0.4140354552569148, 0.6733401471242401, 0.6959799610021369, 0.8393156782070326, 0.6760321759776816, 0.6596944875592354, 0.6117088864675133, 0.6578899717045801, 0.7497073138448296, 0.6441299087597384, 0.8828133092095921, 0.8771493973945234, 0.9378015035602479, 0.8934544149727157, 0.8455527254066506, 0.7673104835770641, 1.0366680856075121, 1.0716326721517879, 1.0089935386250508, 1.0218415057706014, 0.8505719351114364, 0.9120317769552971, 1.1934417386084895, 1.0193812434709548, 1.0602564872900995, 1.0791853630635411, 1.0993839456854575, 1.1483826358630465, 1.1925328882445143, 1.3634976984292229, 1.1696407845239993, 1.2125427416110843, 1.1719033900997851, 1.2686852230302568, 1.1175022871305027, 1.3602697641921049, 1.4792443419207448, 1.3232965190237598, 1.5088180588328299, 1.4427202216352779, 1.4653836485083089, 1.5105761980217034, 1.3645406677375891, 1.6119514005378908, 1.4763566920262303, 1.4214050063990871, 1.3529128166881876, 1.4191145549429807, 1.6801785315663196, 1.5381888954750398, 1.6863503923399459 ; ... % y3
 1.8212101742264972, 2.1816165840677288, 2.8323814462840442, 2.9158128761110254, 3.3861920652307820, 3.5973307158828116, 3.5399295803471129, 3.7333084751127950, 3.9034005418161226, 3.9276639541213307, 3.8706610761779654, 3.7691499792671115, 3.7101179426345534, 3.8450705229654187, 3.8539210857654380, 3.8014702089042176, 3.8797674686594790, 3.9181184630595234, 3.9939491799431965, 3.7988621024728539, 3.7605381765681827, 3.6971561205145811, 3.8825255590075525, 3.6904075518499990, 3.6679826078919451, 3.5919488615979067, 3.8299745064946769, 3.6666189705756804, 3.7604748498738862, 3.5364912023525839, 3.5771728761099908, 3.6279521202672629, 3.6484103307771463, 3.6209650417864809, 3.6398015647665933, 3.5125539286993810, 3.6268146541078750, 3.6023165750648953, 3.4623420912185754, 3.7309525255098315, 3.6405892301334704, 3.6411847797483929, 3.6403114985206551, 3.5543159696016047, 3.6672291756353887, 3.6013908934162484, 3.6884685136787629, 3.7341544040130747, 3.6647472598751452, 3.5429147507776140, 3.6652450048106258, 3.5414974487923292, 3.6124079077635045, 3.5032426449060243, 3.6100135161714162, 3.7462387818872149, 3.6901238352821859, 3.5252685763938207, 3.6893707872560628, 3.7189338348295022, 3.5035467792643242, 3.5728824116545250, 3.4849262835366859, 3.5476972102181445, 3.7349289280393885, 3.6749824900230856, 3.8184106452102329, 3.7520932757726926, 3.6712795188764398, 3.9503711414177838, 3.9113399510378475, 3.9477611984310150, 3.9349760379797720, 3.8477856287401035, 3.9747848511823980, 3.8072776649386757, 3.7904351902979858, 3.9904097061262109, 3.9672999543688663, 4.0559285201054625, 3.8420133113645543, 3.7633488015295540, 4.0279478819599612, 3.8959606623567895, 3.7425199471763677, 3.7998272642328987, 3.9948693745521231, 4.0510088845133216, 4.0610308603802707, 3.8642711476659710, 4.0492934350500915, 4.1028611887642379, 4.0599918586026318, 3.9512714582996868, 3.9476025790640135, 4.0982784297490307, 4.0279736760082461, 3.9692494551080459, 4.0703461194684607, 4.0406935492741312, 4.1949373257515479, 4.1089556363034401, 3.8471486146684861, 4.1528885334364221, 4.0251516971271002, 4.1688788375521266, 4.1265025354929099, 3.9488842535061313, 3.9820155914176345, 3.8350073083147866, 3.8316076022595520, 4.0796076594981221, 3.9867576853748430, 4.2189935790763302, 4.2235533993076446, 4.1897346889902529, 3.9824069197860759, 4.1788810746690936, 4.0479516047065687, 3.9937656559803081, 3.8253344918874173, 3.9038087394532570, 4.0254230334381456, 3.9661841736981196, 3.8795290410156356, 3.9089727213305179, 4.0103085918594417, 4.0990078698606087, 4.0878618872770014, 4.0394122217829631, 4.0040619026187478, 3.9125147342640125, 4.0688754474994901, 3.8375914529110524, 3.8782285547392492, 3.7800687688769061, 3.7381039015021611, 4.0314355136662989, 3.6747249974833287, 3.9001614672857259, 3.8126472614319460, 3.7133973153556976, 3.8638303858192549, 3.7139192355841084, 3.6345831905991650, 3.6787967149036884, 3.6194307414867266, 3.7991769768823374, 3.7714213257768581, 3.6180540461487736, 3.6782804424844771, 3.4698807917718262, 3.5567305255248542, 3.5200142258836142, 3.7276772950954600, 3.6171967902774873, 3.6969448038323538, 3.5921532626664261, 3.4945263484909650, 3.6024851640056070, 3.5954437064304057, 3.3641130089743281, 3.4339447414851532, 3.4584937477297117, 3.2608279307807697, 3.4163954144255491, 3.2997174833470631, 3.0902511823268295, 3.1250092114106311, 3.1639975019218860, 3.1227289945587060, 3.0625193218250777, 2.9459320845947223, 2.7979324938774806, 2.9105730479420964, 3.0150030706736768, 2.7775132842525503, 2.9803336788914199, 2.6373548642669906, 2.7585849798166517, 2.8930886844281329, 2.5471487911749811, 2.6553747320344550, 2.5641607197181462, 2.4880784331900720, 2.5200626178373295, 2.4426371187430869, 2.2710259167544247, 2.4276074535050411, 2.4450000109155159, 2.4786825041951843, 2.3408688897903560, 2.3610700934347344, 2.2063272887042165, 2.1672857533963499, 2.3174232869682307, 2.0145791471736656, 2.1959524395563581, 2.2326188501833708, 2.1613866580913892, 2.0631482048002159, 2.2458760486933746, 2.2398929403222452, 2.2415564246888446, 1.9602002133791221, 1.9722760110733051, 2.0648647171039314, 2.0957157539886744, 2.1237635736628100, 2.0495658647182888, 2.0455073934745762, 2.0948035461745285, 2.1129865770426730, 2.1031293755942291, 1.8876000284602532, 1.9514630179468855, 2.0735105108353542, 2.1693370903473319, 2.2083126144048890, 1.8903341453017544, 2.0356366338749226, 2.0153676605743929, 1.8859049595762349, 2.1418949007139769, 1.9602338255949610, 1.9658390239183063, 1.9138856509458604, 1.7763009744541312, 1.9168050037422408, 1.8590146116470272, 1.8372330497006357, 1.9814810890643164, 2.0803727899424480, 1.9359726336049536, 1.9037969067133076 ; ... % y4
 -2.6530353310768220, -2.8112968336846911, -2.6653271707047081, -2.5494248947143627, -2.6519392125746815, -2.4233496970089790, -2.6656193651215823, -2.5419139729396889, -2.5667948568312040, -2.4447048418462920, -2.3519747592385509, -2.5412656810311343, -2.4290383796661632, -2.4215316060945735, -2.2310286401554422, -2.3243333288035188, -2.4668023255887217, -2.1723827004287597, -2.1805916346972380, -2.1659313080171314, -2.3757876634249344, -2.2728271689729791, -2.2870195624623286, -2.1533274810014618, -2.0692623358178572, -2.1906273231605700, -2.0396248966326773, -2.1519917702786708, -1.9282781560917062, -2.0251130253014429, -2.1365268014053562, -2.0182056443637810, -2.0024890893334848, -1.9723310458567369, -1.8124542165121940, -1.7048745815497313, -1.9526825356619948, -1.7203199291963696, -1.6906875025115278, -1.9154785530055081, -1.7352104943832254, -1.6242687415525041, -1.7257726983114272, -1.8076125025328116, -1.7163704242980677, -1.6082492702300830, -1.5064881028305805, -1.5053371356608456, -1.4739810991266926, -1.4858895352489012, -1.4153213779673273, -1.4845007529304923, -1.5050884077839066, -1.3532752766184823, -1.3126165907469838, -1.4766047851409634, -1.4811417605431090, -1.2303531680758975, -1.2992131761771786, -1.3876262698364397, -1.4570913177393221, -1.3664394620562152, -1.1030117602408807, -1.3454007677334121, -1.1962137534159771, -1.1953977753232303, -1.2448305518239302, -1.1750507320887860, -1.0877706318638505, -1.2849519874876958, -1.0111055414501846, -1.0891377685234285, -1.1109386364120271, -1.1054222786054451, -1.1875247381635223, -1.1895488297198114, -0.9319703140110026, -1.1848325679303486, -1.0030031940853756, -0.9194421471692009, -0.8521336833932722, -0.8919788883565249, -0.9001125628320327, -0.9575979900366682, -0.7471032918856717, -0.9296442208578616, -0.9080561819542435, -0.8080740048208407, -0.7095011758400124, -0.8910352206684371, -0.6773188400891599, -0.6568106132488599, -0.5288687208419951, -0.6293699969019728, -0.7488577342052020, -0.6955590279670973, -0.8387620844837484, -0.4422148021095877, -0.6351104697621737, -0.5321758119665229, -0.7307753624557628, -0.4402294481945663, -0.5158887564271374, -0.4855425920507510, -0.4842620460712291, -0.3381755824020122, -0.2983565864155557, -0.5007096064143353, -0.4723087981523102, -0.4147880244290658, -0.5490089436751363, -0.4692761968201523, -0.3507253597050893, -0.4577970659660650, -0.2972305175766310, -0.4670648900858472, -0.1019435866723484, -0.2535370708046529, -0.1365507066793041, -0.0381492597879493, -0.3808881036949567, -0.0659287686507285, 0.0002263744202254, -0.1078989336238554, 0.0397179402028838, -0.2524077652013954, 0.0267866312496098, -0.1513595993335195, -0.0161666793248980, -0.1400286703656456, 0.0035179342222574, -0.0484959764442060, -0.0358910675400453, 0.1304488014050122, -0.1489901708291679, -0.0172132002620123, -0.0606882332234996, -0.0860274915527915, -0.0905400864568598, -0.0774037281226471, 0.1431963396783841, -0.0543409851408664, -0.0225553181428309, 0.1023788644256218, 0.1447228645186038, 0.1538655390175537, 0.1322285650551725, 0.2241345405328252, 0.2313744337620786, 0.0558958376827313, 0.3914561429918829, 0.4104278260790929, 0.2664865785786507, 0.4630659484695168, 0.4063236952294266, 0.2180289478998788, 0.4617751319696754, 0.5008360996361043, 0.2390887004346202, 0.4558941411188073, 0.3345675883236626, 0.2348033276183398, 0.3166768993964434, 0.5121588672918608, 0.4012755185443843, 0.4637981119758445, 0.5405394681384741, 0.6409986766594469, 0.4768251977547038, 0.5372400151139775, 0.2983075331055025, 0.6176978713411224, 0.3824105272169036, 0.5844933978914861, 0.7038488072487536, 0.5908524118795251, 0.5062329049052273, 0.6839891736447572, 0.5993559292432391, 0.5677168761879101, 0.6059743041965329, 0.6829102563114035, 0.5590684857494895, 0.5668050189099907, 0.5913608144361558, 0.6208336298233700, 0.6576045936693344, 0.5022937456294468, 0.4914880675393755, 0.5910202199267638, 0.5152231738315345, 0.7598942794914002, 0.6975953887753514, 0.8009814758758516, 0.7482055702393323, 0.5911668924643160, 0.6874847113507174, 0.6801422745217329, 0.7862982380370209, 0.8657202276257246, 0.7516835035031415, 0.9176110074485905, 0.6269065923184879, 0.7950529564174483, 0.7997548680046698, 0.8354261280419761, 0.7645483761929238, 0.9148164999054026, 0.6996635467970760, 0.7749321650936439, 0.9025697407738558, 0.6881986266667273, 0.8573926357565198, 0.7691318303776866, 0.8804742355491576, 0.7445656422059833, 0.7744990029313032, 0.9814635073223429, 0.7990330749191680, 0.9514050193303465, 0.9171076226964467, 0.8494422106760765, 0.6921379768625144, 0.7468060621381942, 0.8493825226496654, 0.8349267751956158, 0.7721488979920763, 0.8610752636237068, 0.7322226557039726, 0.7201130834898506, 0.8820364899882489, 0.7012258882360705, 1.0493679375637113, 0.8233994588321165, 0.9874538327924804 ; ... % y5
 -0.9911910968656342, -1.2366703401088210, -1.1906781824050254, -1.0145683759744535, -1.1110336801342389, -1.1797631143812068, -1.1972859497364154, -1.2623250120438587, -1.2147891531326374, -1.1684024024305000, -1.0673572234381414, -1.1785539673009922, -1.1722823570280492, -1.1349760262064268, -1.2401766528146154, -1.0787891221761547, -1.0129618793735831, -1.1104790902818793, -1.2345609840421610, -1.3129219388977025, -1.4116345508624601, -1.1773689516627421, -1.1175498440601261, -1.2627804655875399, -1.2628280930611646, -1.3208925024331259, -1.2628455859912378, -1.4262726105859163, -1.2784886552297796, -1.3255180793847778, -1.2398840229768422, -1.3099126993156640, -1.2730759144612616, -1.2303127842403132, -1.1362348423161706, -1.3460603024930020, -1.1026491368283853, -1.3323702164197000, -1.2416466196115143, -1.1177481162049550, -1.0725151529389201, -1.3565225402044971, -1.2279998397828935, -1.0949089915969707, -1.0352227950957829, -1.3297651678027653, -1.0545685452089011, -1.1769800858445527, -1.1753075313526680, -1.1771813597065519, -1.2815646110415513, -1.2190980851153803, -1.0377178078476488, -0.9905375270202849, -1.0905001517057002, -1.1021837467874054, -1.0041201841128087, -1.2529444580055966, -1.1911581116671968, -1.2298522137299601, -1.1033008606133590, -1.2075984240218496, -1.3214010752766188, -1.0774516208261837, -1.0664288274882716, -1.2389902134924433, -1.0746835078321249, -1.1569033777589979, -1.1397384603186884, -1.1981711309167051, -1.2299665094934249, -1.2043599775679887, -0.9685012335098975, -1.2506438976673235, -1.1338493986253588, -1.1784563643097650, -0.9394808162210019, -1.0958637679853638, -0.9218628179855496, -1.0855832635374119, -1.0767593145185581, -1.2169186804192640, -0.9524029644870451, -0.8973952993153265, -1.1755201541620321, -0.9201548853190088, -0.9904164518910805, -0.9545937206990103, -1.0464334916829157, -0.8971393753168184, -0.9500795998204011, -1.1107852747445783, -1.0745225833374861, -0.9554209677684428, -0.8190399868160019, -1.1364840069995674, -0.9602119048759915, -0.7553573530052522, -1.1123736234003878, -1.0493304806962838, -1.0948401542526742, -1.0011856320351022, -0.8159020739307240, -0.8296658760788761, -1.0485920804184714, -0.9565969387984902, -0.7767443177842220, -0.9176357274983264, -0.9377356933077546, -0.7895351555122171, -0.7335585811165164, -0.8249020413590481, -0.7669689789759656, -0.7581972576946839, -0.7632581024924661, -0.7976488819587618, -0.7053012623067122, -0.9097320764603981, -0.8311637004575724, -0.8486409386596643, -0.6958108668000705, -0.6278701091592624, -0.8170153630791962, -0.7056738891843726, -0.8067939291259972, -0.5919413981182269, -0.6818399014582400, -0.8150233189850943, -0.7847800901274707, -0.6898875244677057, -0.7669845557066409, -0.6311714414163885, -0.5890066546557009, -0.7077417894352979, -0.7451471291891745, -0.6560399330119039, -0.5469811551814545, -0.4995231748537057, -0.7575598444064719, -0.5792987655758335, -0.5468283334826820, -0.7345082907487758, -0.7343057694416721, -0.5789432184791254, -0.5162858749446566, -0.6532347090857394, -0.5114185543199981, -0.7284697773278459, -0.4432366891422047, -0.6092647130295552, -0.6329709367844212, -0.4973144661372632, -0.4988994577731136, -0.3845497608679879, -0.3833720816612904, -0.6061636481349083, -0.4633633875922815, -0.4874850439720315, -0.5714051997736130, -0.5353802270567078, -0.5169529426687882, -0.5950363557554658, -0.4239941602849133, -0.3449281769106208, -0.6474049717825701, -0.4078662444303106, -0.6234949395746230, -0.4875853526894980, -0.3584098224747279, -0.5500888920776311, -0.3316395936084785, -0.3826950197144068, -0.4909162540893704, -0.4466985662224806, -0.4159712598118570, -0.4423250501933715, -0.3368340581526138, -0.4198653199348668, -0.2757988895225528, -0.4489187473322833, -0.2472729802302953, -0.2950531521745038, -0.2113922757640886, -0.3117138239781926, -0.3260893877559921, -0.3172305373160129, -0.3941003385842106, -0.4671793871273194, -0.4137865318152477, -0.2092352386980822, -0.1185910787640596, -0.2559546288098369, -0.4236798713258930, -0.1983743464375983, -0.2953233375288444, -0.1733699327136129, -0.3824582381937393, -0.2182090245512304, -0.2574630215901058, -0.3175575057284488, -0.2901967153753099, -0.4458384437004009, -0.2207415504369031, -0.1900933851212280, -0.3369447654713241, -0.1855164436152214, -0.3428151962731881, -0.2513969119290177, -0.0442089717691863, -0.1077048710173453, -0.3742541954550678, -0.1645794329660168, -0.3847827286152090, -0.1950165066152712, -0.0691841785849555, -0.0849422114990384, -0.0271530733527970, -0.2063517471030084, 0.0153551654682099, -0.2029305702971302, -0.1007098015157963, -0.1485591067788556, -0.1414815046630383, -0.2775547738363449, -0.0821460981046024, -0.1722752099433885, -0.0989862659590291, -0.2026531039885809, -0.2440206560556307, -0.2988580396513487, -0.1275337221514556, 0.0075742272145900, -0.0114994007980362, -0.0958101749349203, 0.0224899983793726 ; ... % y6
 -1.6874611622232993, -1.5779449983724929, -1.4621455104049101, -1.6134447919577779, -1.4440490106373409, -1.4727234662746711, -1.7083616653260987, -1.3647223018234895, -1.5656777450609827, -1.5402501101215091, -1.5184323429007569, -1.3139209082246810, -1.4022826284692433, -1.3175637436315923, -1.5361032859658863, -1.5374558453742335, -1.5727334823624806, -1.5570731029956548, -1.5962596277703942, -1.4178565317594611, -1.5092709227885066, -1.6775967778037535, -1.3948873520411007, -1.5684578665307907, -1.6085111731958694, -1.5173056689556623, -1.5261467411699026, -1.3404443130088877, -1.2960387085862086, -1.3676211604906379, -1.6350720198703796, -1.6083755271260489, -1.4940407388349262, -1.3986612571876822, -1.5635994274844660, -1.5158889152918240, -1.2867218807658671, -1.6623424138531955, -1.3115188548268337, -1.4851121305614359, -1.6102055916697318, -1.4691128828980113, -1.5750616445628489, -1.3539312173507108, -1.3110457588213422, -1.3171785681319117, -1.6335083940964183, -1.4055604905001098, -1.3145727614670246, -1.4183336124891599, -1.2684347128866897, -1.3497008961402825, -1.4321045931680314, -1.3079479871676536, -1.5014736746160078, -1.4364126468613343, -1.5260954065402315, -1.4575514637166553, -1.4883637508127907, -1.5302233893518937, -1.5719867479748091, -1.4194283059069346, -1.5045673392475691, -1.3852879121186514, -1.4109903063425044, -1.4077491407386424, -1.6213402773244454, -1.4014573107846264, -1.4915375422848656, -1.5052899108611060, -1.3937226548598531, -1.4917666251954986, -1.2738204826149087, -1.5124140619545394, -1.4174494269746196, -1.5508122538519948, -1.3785990504161740, -1.5747847616986297, -1.2764196818516704, -1.5795426723508297, -1.3069880652117620, -1.5324296785118821, -1.5655000402602088, -1.4254211029483939, -1.4664493444722273, -1.4830918874801498, -1.5251341775316893, -1.4344156937762917, -1.2399793436730535, -1.5892124026129886, -1.4091409817303553, -1.4988256656556498, -1.2278233955797688, -1.4190116379607050, -1.3766988217286726, -1.2947921986928725, -1.4930225643823107, -1.3225851915069049, -1.4413836159016984, -1.3917372287759839, -1.2649335753157649, -1.5111994512297582, -1.4056979171820470, -1.4249509904713316, -1.2839166188519360, -1.3350823628213730, -1.4222723522925433, -1.2717152913914098, -1.2123211403515877, -1.2999464456496879, -1.2171744348061972, -1.3697188765574879, -1.3170407183833839, -1.4705634475685723, -1.3314143156778249, -1.4151577853856458, -1.2658798808313170, -1.3989292177582713, -1.3405393225510760, -1.3743977881446066, -1.4448992897251665, -1.3435243262268113, -1.2039052656760381, -1.1518790768669822, -1.2877332840432318, -1.4066072692642335, -1.4384075375754997, -1.4602986330468077, -1.3015088865625948, -1.1365585577847801, -1.1987906178607119, -1.4313199754983377, -1.3653670802829312, -1.4959288799104862, -1.4531089127685797, -1.3639158015333122, -1.4009823816008644, -1.4302271525814834, -1.4967520702789141, -1.2543201077129618, -1.4673548170426709, -1.4080701565666212, -1.1985312343146346, -1.4034697425785907, -1.4463950805336112, -1.3348840648713007, -1.3899840662211378, -1.4397624683995927, -1.2918036651746827, -1.3834217258871797, -1.1796265815670848, -1.2863770297212043, -1.0986083205309340, -1.2273852964981169, -1.4145377764532230, -1.2970033784064889, -1.2755315756833481, -1.3219690973405249, -1.4374921729279202, -1.2176210832220380, -1.2926404687976070, -1.2793814535996686, -1.3698470927803923, -1.1705084793949532, -1.2812071383290256, -1.1240415928898204, -1.1758654678796081, -1.2616278101343319, -1.2542993012602657, -1.1431436101476691, -1.2354889042049482, -1.0866710361168186, -1.2366073006421494, -1.0407478247632409, -1.0696616706948312, -1.1493870863696163, -1.1221228757340613, -1.0545806362138705, -1.1412677447450128, -1.1765787767043911, -1.1308163328860887, -1.2218121574239666, -1.1778199831457759, -1.1480166279670225, -1.1701392424881383, -1.0384902342115001, -1.2280196977831950, -1.1033771591863712, -1.1566008179348246, -1.2877580640559856, -1.1373036638604073, -1.1191371871858551, -1.1590850697917858, -1.2542132877924361, -1.2285176670648159, -1.0482749617301577, -1.2451288493004045, -0.9531432690593502, -1.0372639956371823, -1.0451645488682653, -1.1557874945209250, -1.2469881823178512, -1.1291477353107218, -0.9852155145228574, -1.0554571010646030, -1.0844250513346105, -0.9314297097889349, -1.0572637530827362, -0.9697826402527263, -1.1060769434587439, -1.1356082423429503, -0.9532529987809051, -1.0595563340310499, -0.9675518657648252, -1.1260206363331735, -0.9148023723418859, -1.2174358508622538, -1.0763506826258302, -1.0901784891378627, -0.9313444646051787, -1.1189641906275478, -0.8914111088616092, -1.1922892094301596, -1.1580584418363533, -1.1266228295367040, -1.1799274579525167, -1.1391989497760839, -0.9987451463625536, -1.0816392380983499, -1.0845305708488970, -0.9019547108551280, -1.1836923735953948, -1.0412720810224310, -0.8149793739392863, -1.1497395113880895 ; ... % y7
 2.9183843897122035, 2.9536324008410824, 2.6841218636805548, 2.9741594609756699, 2.9269782717323887, 2.7427303442528728, 2.9006171492710591, 2.8332633895809565, 2.8205434993745504, 2.9207183991327477, 2.7522824806445882, 2.8078943144374588, 2.6207367366897931, 2.7663718997665248, 2.5899401631611449, 2.7736310620641733, 2.7424390734635065, 2.7965107462748775, 2.7344995222283455, 2.5043277896885918, 2.7499707854758499, 2.8296789548499159, 2.7355068433596168, 2.4942525516405540, 2.6259853370134967, 2.5330532540187050, 2.5366965796891754, 2.6182427125443173, 2.6004882231348825, 2.6056730213173434, 2.5328704612875352, 2.5449067722250294, 2.6615266995329678, 2.5376947492489617, 2.5572803675899718, 2.6038628958096157, 2.4543627658436864, 2.6104862622508564, 2.7081438209687687, 2.5967291919538167, 2.7421965825528605, 2.4556015226319352, 2.5390103457476796, 2.7471486583418656, 2.5566391237656925, 2.7762217727149694, 2.7348303016597733, 2.6144594916465080, 2.5173990311640968, 2.7391694016432209, 2.5995042810570705, 2.6832592586254380, 2.8135459178312576, 2.6534761396952744, 2.8422857840690803, 2.8109045417451783, 2.4951870226587616, 2.6136226509714233, 2.6206682394533001, 2.5379086834266840, 2.7932720741270334, 2.5645331766508077, 2.9267201185685625, 2.7517672022565294, 2.9531308729601577, 2.7373139127303130, 2.9071546019885233, 2.6858415593059171, 2.8146665259223504, 2.8327813180791717, 2.8601235441874731, 2.8194241460149088, 2.7176406439878105, 3.0637477442224350, 3.1245626854613109, 2.8166446826724632, 2.9767166177866922, 3.0169145274316280, 2.9593938765791976, 2.9709012428921047, 2.8580553487320164, 2.8480685214034520, 3.1966583611146664, 3.0694862047071769, 3.1778761841773711, 3.1298974552015388, 3.2137415566515819, 2.9515630848276939, 3.1111637328622082, 2.9936250081435309, 3.1308637298540281, 2.9740599580079721, 2.9995866232007997, 3.1116508223700516, 3.1017966804291439, 3.2001960876638962, 3.2217530412126720, 3.2639568617781860, 3.2927226855011225, 3.1581944039618661, 3.3229705034544001, 3.1717632509993066, 3.0385067096567346, 3.2987954437567262, 2.9700167324175188, 3.2255503834545265, 3.1066493973362856, 3.1336479535585977, 3.3191156219583071, 3.1630337044970296, 3.2017724196925919, 3.1721754190421581, 3.3319494327867902, 3.3003478020830816, 2.9911649148419714, 3.1263295205112218, 3.2087082424043092, 3.0132294501493435, 3.1977105979359113, 3.0502537252573969, 3.1495563372762096, 3.2720525564295428, 3.1097249093321668, 3.0531610717289848, 3.0225905432037594, 3.2303919423195593, 3.2532859734517245, 2.8916981177568655, 3.0490607870279876, 2.9871910548747906, 2.9709002050145377, 3.0130531335565900, 2.9658653634351682, 2.9746401607641983, 3.0838311227472586, 3.0381096542986690, 2.8825729240651006, 2.9729384019098761, 2.8928178537215961, 2.9388356005189324, 3.0599043402678014, 2.8930071931553449, 2.9755437190268230, 3.0001616151081425, 2.7528551166780346, 2.7409604846777982, 2.9173217206378546, 2.7516076668866893, 2.6871541907939713, 2.6388715848340434, 2.9261944153106927, 2.6733407558781344, 2.7645107989806794, 2.7024345576218516, 2.7087422866107027, 2.6607190243601559, 2.5846069684714865, 2.6111215465653839, 2.7155557304326661, 2.7006558590095802, 2.3602601724806291, 2.3796735280320243, 2.3299608472363955, 2.4111736077575396, 2.3189662640809643, 2.4037892767325397, 2.2342518685879602, 2.3530211034070270, 2.1058686351271039, 2.2212719258529354, 2.1857991524805600, 2.1422382229430470, 2.0634541193251903, 2.1204382628582974, 1.9768549388761247, 1.9617753547814814, 1.9102720853428294, 2.0448678889032621, 1.8178406926917963, 1.8666685415803042, 1.9487008220264705, 1.8175180847129602, 1.8595169506536220, 1.8216393610198924, 1.7846050724883797, 1.7821775761315199, 1.5837463587248333, 1.6743516938442145, 1.6790624488587029, 1.3578588047252669, 1.4747139688473847, 1.2978630592910680, 1.5562841405271404, 1.2726276430366534, 1.3789788132733523, 1.2220828181258625, 1.4649051277566312, 1.1994173346283494, 1.1213097469770583, 1.3361223812966674, 1.2397028669193944, 1.3413666957546340, 1.2389971751257225, 1.0023829693580022, 1.2597242628364527, 1.2057569245415705, 0.9918117824077654, 1.1615804015032645, 1.1281421804354035, 1.2477506181142766, 1.3264573324342219, 1.0524662455219989, 1.2816398263920727, 1.2618167233004731, 1.0434976385375845, 1.1030681283970216, 1.0632229272736538, 1.2532762974352971, 1.1272790294329458, 0.9880878875183761, 1.0453307798903371, 1.0896998448436894, 1.1204769872806686, 1.1103098627788135, 0.9851323788271287, 0.9133980908516340, 1.0616800731315525, 0.7853018797863641, 1.0730842894482946, 1.0872264731391983, 0.8934742424875662, 0.7533198932429216, 0.7074327778793956, 0.7835339684221394, 1.0114813025459057 ; ... % y8
 0.7192415668603375, 0.7752234735970804, 0.6189295747275582, 0.5283614779482559, 0.4798424062654374, 0.5815704445916894, 0.6555519877844637, 0.6963249688031430, 0.7239051738775449, 0.7594436716629419, 0.7223766679312030, 0.7767586163374183, 0.6796006947458033, 0.7237665011167450, 0.8108556139704495, 0.7735132774908835, 0.8818710929276796, 0.6751346846375103, 0.5863606460654975, 0.7805035991175405, 0.7518522183527315, 0.9206685507033847, 0.8919222221452875, 0.8226958700462147, 0.9583598132919635, 0.8303942549604238, 0.8090900772075793, 0.7162837283781845, 0.6757430353608709, 0.7366570599250168, 0.9289334608816122, 0.7189619819320966, 0.7958886039641601, 0.8957591576750451, 0.8817575993986589, 0.9248210190520798, 0.8335504722375916, 1.0503020530752620, 1.0702806941141827, 0.7357441670461985, 0.9665395627041017, 0.9863034031429564, 1.0798872804306634, 0.8201896278392306, 0.9924605311830983, 0.9421032106828922, 1.0593059793420099, 0.9484031652733765, 1.1657411985925901, 0.9776412221319218, 1.0249960249993411, 1.1057381159499946, 1.1356199397000908, 0.8309507982420996, 1.0765488791176046, 1.1144675939688633, 0.9037757140541323, 1.1717804231302928, 1.0631317788218633, 1.0397577518677035, 1.1799553240365810, 0.8844313035187714, 1.0036008617898147, 1.0604951687554036, 0.9125626778715829, 1.0726807443476341, 1.1511786422494694, 0.9294651149009409, 1.0167616511006692, 1.2612488209350574, 1.0276935985777702, 1.1989318499999175, 1.1183105408269227, 1.1913474460658018, 1.1211261081871002, 1.2993229767527075, 1.1723752849505760, 1.0063548971003231, 1.0727160654995225, 1.0080371838020561, 1.2684612856877491, 1.0838669554159941, 1.1131833385819194, 1.0721485880759911, 1.0292328527591186, 1.3186666767306907, 1.2663556659845707, 1.1914766208774283, 1.1079761835291664, 1.2859969156162399, 1.2260084291840647, 1.4340386534633676, 1.2391086122575599, 1.4484720629223737, 1.2069735030113602, 1.1346795375932901, 1.3652924212588720, 1.2661456998285681, 1.3671006676142712, 1.2076996218519147, 1.2343559384853944, 1.4426059322762270, 1.4890485102671760, 1.3498314351106480, 1.2751153356601492, 1.4376539953362604, 1.2233505102780968, 1.4737771961729549, 1.2852670577881089, 1.5087277212958756, 1.2482618830660619, 1.2674283633164536, 1.2903606183571268, 1.4822950842718252, 1.3249909487842939, 1.3209015674212441, 1.3024005509387433, 1.4822411461736638, 1.4904086407208292, 1.5249481858338074, 1.3248168010145573, 1.4997486866206595, 1.6236352986754368, 1.5591490752975230, 1.4232341184491268, 1.6124325983388961, 1.3238686527522685, 1.5224191050292062, 1.3469477285964488, 1.6865217083734072, 1.6694865041200884, 1.5853812832193730, 1.6372916274541827, 1.6127205660565571, 1.5968598281580888, 1.5706605896580570, 1.6512195752960412, 1.6242438756113655, 1.4621438114403900, 1.5460582677788024, 1.7827053816747196, 1.6443056337860087, 1.5004701505375444, 1.5607014729923117, 1.4450683867516967, 1.7379358381943357, 1.7505855489060034, 1.6190395415928946, 1.7164618023564000, 1.6529005168765141, 1.5828715129815576, 1.4868972919549766, 1.5954510178671739, 1.5422471954705994, 1.8376992913180095, 1.7647043628770107, 1.4892422583180296, 1.8218476975428666, 1.6835465444241693, 1.7192373324275632, 1.5825228896018748, 1.5757865263296309, 1.6398988803950845, 1.6515897355712461, 1.8386812972008750, 1.6687448209112170, 1.8168084896978320, 1.7496075750683830, 1.6430527054658708, 1.7105886004899049, 1.5322105032110935, 1.5289274517462512, 1.7468072827285730, 1.6322646447046383, 1.5760937475695660, 1.5950664966684969, 1.7885516685481004, 1.7853438272926891, 1.7540448344451480, 1.5488158116854336, 1.6927203219373499, 1.7724443174960918, 1.6942019654355374, 1.8205312406543963, 1.6925274745458176, 1.7132856031722992, 1.5531833724274358, 1.6922731015573440, 1.7932325402786518, 1.5742454461816582, 1.6201067218902565, 1.5353480610560279, 1.6976887834616079, 1.6949728779557591, 1.6986752170353461, 1.8254524434315544, 1.5757015198715072, 1.8688958097399166, 1.6467650345262721, 1.6329295847947030, 1.7753819498398198, 1.7329767658891155, 1.8149004814505778, 1.7548814289353907, 1.7549704193944904, 1.7812604050718586, 1.5409946567882820, 1.7095628374044300, 1.6266468056007242, 1.7266251527277303, 1.6313244689017572, 1.7652940408067959, 1.7054236314187310, 1.6959833458543254, 1.6112200782765285, 1.6112218413034747, 1.5471894512601621, 1.7758473457208723, 1.5990743373051515, 1.6695850115389836, 1.4848684607128233, 1.8282607937174520, 1.6628536215441112, 1.5376719734750934, 1.7848747524281925, 1.4812293632255453, 1.6124580977077438, 1.7550787152672991, 1.5714087234772545, 1.5304056989292485, 1.6860085350615164, 1.8016967437654734, 1.7075186188711557, 1.6078722102380916, 1.6296279458264247 ; ... % y9
 0.2843586819046863, 0.2059836535665552, 0.4088885890005917, 0.2508200289350315, 0.4090859036683426, 0.4706409820418421, 0.3852736420116041, 0.3991455558829563, 0.5929154133078820, 0.5299353984625788, 0.4212723815538833, 0.4977108627012080, 0.5684717045779242, 0.4881251405501029, 0.5731555641490585, 0.5297270115307913, 0.6296851479463960, 0.6758087670784911, 0.7099755058954085, 0.4670937535496122, 0.7583868167622458, 0.4203069998868005, 0.7880353943779941, 0.6692311315266662, 0.7376712393816907, 0.4931665179481076, 0.7971362794041436, 0.6372741109862360, 0.6999735010538698, 0.8248948295824224, 0.7086695295652131, 0.7895307825875122, 0.7890395277752170, 0.6217480419673930, 0.8916706130650089, 0.7798328314449628, 0.9194656724490679, 0.6812107886269281, 0.9975972891509265, 0.9623113339924635, 0.7012447410105755, 0.8485267813471372, 0.9232139914787401, 0.7753851227158648, 0.8734994892020034, 0.8209063082428467, 0.8278560774824533, 0.8929864853955716, 0.8357546448885894, 1.0753802884414043, 1.0457006437870462, 0.9968956720471368, 0.8662414457355563, 1.0081969338046042, 1.1146477115325788, 1.1232964007532358, 0.9723047183106045, 1.0353452463360588, 1.0420728240638422, 1.1379314615430129, 1.2779624315244360, 1.1063273449942723, 1.0011379773181079, 1.1594854678295994, 1.1124530180831369, 1.0796253239169300, 1.3459952464115250, 1.2818950792803283, 1.3831176478113578, 1.2498242258827588, 1.4579695589553217, 1.3841952197572829, 1.1556380832063020, 1.2717129987496045, 1.1974266402533282, 1.4080935525891680, 1.5403306033207718, 1.3980682508034457, 1.4206211640402095, 1.4619337450239758, 1.4563316230760575, 1.3325472860457648, 1.6453242358179714, 1.3618133553885667, 1.5898307948764330, 1.6149355426761096, 1.5392253865958541, 1.5304410775105644, 1.6603696051650818, 1.4691389786580398, 1.5238942319327455, 1.6850962205265840, 1.8086607400247521, 1.7385569345698175, 1.6618006850781584, 1.7049923306736261, 1.7114741432384999, 1.5863611061391962, 1.7003334795493308, 1.7491231729897672, 1.8534144877074228, 1.9392298789332019, 1.8680811792289553, 1.8518832865785013, 1.8848078969621695, 1.7515693257290192, 1.8780440623594572, 1.8514588987337715, 1.8778265590029204, 1.8855112394202111, 1.8071234749698182, 1.9289845174531528, 1.9831583507259929, 1.9770923041389916, 1.9110450505550864, 2.1976820626273086, 1.9666346724394239, 1.9878287881098937, 2.0975744176979121, 1.9458952382410404, 2.0882702339636938, 2.0723181483460205, 2.1471814446633855, 2.0852978302039631, 2.2139007242863582, 2.0549569668910537, 2.3045014006155484, 2.2420026159866007, 2.2225147653046027, 2.0532183433413582, 2.3527519262653280, 2.2287618101222844, 2.1395454852166620, 2.1498529628550358, 2.1432248847749213, 2.2536248188600858, 2.3311913273875682, 2.1855987882048389, 2.5086547733467652, 2.3414615341737304, 2.5320893090095096, 2.5392596980525814, 2.4303223141278276, 2.3299725089514753, 2.2089160333823830, 2.3929984178572234, 2.5763201807303315, 2.5616835778798146, 2.5311564413019907, 2.5653821741904035, 2.4624363101082865, 2.5133857910959563, 2.3998826867676613, 2.5237404097498910, 2.5588875342635187, 2.4437916732647054, 2.4288944433152317, 2.5722962779584164, 2.5051216599450998, 2.5546025958521059, 2.6034977916360620, 2.5508222562949023, 2.4483594260398531, 2.6378146143435646, 2.5975560925364722, 2.5608385630527519, 2.6607738001958166, 2.5315576734524168, 2.8127088063926462, 2.7068243117602266, 2.6251610695315284, 2.4807944595254248, 2.5611973437945657, 2.5617030404198031, 2.6517298931524005, 2.8202961136142255, 2.6463719713501477, 2.7314679077430348, 2.8424242106641180, 2.7720802748602131, 2.5991670644618576, 2.9270243962122575, 2.6596757891806004, 2.6979967898625934, 2.7798095217500736, 2.7948870304066062, 2.8107265428219295, 2.8834465005896290, 2.6200492867785212, 2.8282206568457031, 2.8009392059728278, 2.8690088870027566, 2.9805688208211487, 2.7976132537051717, 2.7250553254258443, 2.7061124882751231, 2.9202575827030208, 2.7160331713028389, 2.9832841318971850, 2.7820343438741482, 2.9391336671219692, 3.0277127453488335, 2.8212876521096728, 2.9352008930175235, 3.0087685620554945, 2.9811290643758332, 2.8417587240662763, 3.0372308024163193, 2.7603058477070501, 2.9307751809831752, 2.8890939438426972, 2.8337919286091662, 2.8586804941920829, 3.1097390953043629, 3.1105521826030400, 2.8952569757967472, 3.0397963981517324, 3.0345492744791720, 2.8573205012196015, 3.0664056471292449, 2.9626616330825697, 2.9629296377714063, 2.9636205525112893, 3.1632591240852967, 2.9325629435458556, 2.9282500372915026, 3.0498741560495297, 2.9502022730776223, 3.1007273455845104, 3.2273742390486282, 3.0626290653009502, 2.9177848337664400, 3.1703074499653505, 3.0027218041547794, 3.1097629151950619 ; ... % y10
 3.8657672939606664, 3.7043944186050997, 3.8694932968018421, 3.6428391372269071, 3.5647111896956205, 3.6669919284473957, 3.6189269307650562, 3.7569242958423579, 3.4947309399638735, 3.7824454313572371, 3.5226654625926068, 3.5143554355927153, 3.6967933135009106, 3.5836516624849781, 3.5216251030339047, 3.5480607429878095, 3.6822495172133127, 3.4569736146135250, 3.5747067308477694, 3.5906139063821478, 3.5761847217754155, 3.5304249890151200, 3.7180295666803791, 3.4400174151339451, 3.6562411306014604, 3.4137087913730522, 3.5737434359830997, 3.4568525792834657, 3.5707016849658100, 3.6103552989817294, 3.4453036637629739, 3.4942400052108926, 3.3367690217216128, 3.4340058847811754, 3.5444399650572982, 3.4029561811824238, 3.5171557358993524, 3.3388382790027675, 3.5405936888064300, 3.5034124499895625, 3.5346968994489862, 3.5675065899439975, 3.3626653990477062, 3.3700311815376778, 3.3379540568785702, 3.4395452445014607, 3.3595972856737428, 3.5369075391183764, 3.5634432407700563, 3.3506186421027588, 3.4315852269773495, 3.4190603134909994, 3.2071636795887821, 3.3773286252518990, 3.2653678608833818, 3.3670458182134104, 3.2523746374417586, 3.1769858421696249, 3.1709685821062195, 3.4110447848397349, 3.4111439331878697, 3.1290967997831358, 3.2166360770991398, 3.3322250291734390, 3.1960056727250699, 3.1996415493382147, 3.1770276947486566, 3.0691481946092427, 3.3782422570916939, 3.3364954289061934, 3.3118881162441260, 3.2282159767699805, 3.2230643670792576, 3.2702292482476678, 3.1530118962842910, 3.0973844615862576, 3.1004349432671208, 3.3113700103630479, 3.2159525765376462, 3.2145533306974867, 3.2991080403254323, 3.1207040501112138, 3.2742851782975535, 2.9946284214664916, 3.0790498751661137, 3.1593656342372500, 3.3040692089048416, 3.0928245180143410, 3.2254631789229902, 3.3091872547529650, 3.0877786796637809, 3.1368551114320136, 3.1700017011221053, 3.2113151604740446, 3.2801745457294120, 3.0918614404632918, 3.2073824541290450, 3.1348336309230449, 3.2980931541055769, 3.0680978218617589, 2.9573957799993900, 3.0491927735341973, 3.1547907193369769, 3.1626453065423541, 3.1150268150405220, 3.0869706698851815, 3.0145987963537997, 3.0603699885694291, 3.2582125447299468, 3.0745573858786139, 2.9960728706395852, 3.2132205654062571, 3.1875165269161019, 3.2456624880767047, 2.9888350707088343, 3.0743306018925818, 3.2832584031722210, 3.0424174543132816, 3.1105835810404323, 3.0280181080244359, 2.9509128059030538, 3.2370212529669509, 2.9943376240058215, 3.2900694399531809, 3.2760453813315769, 3.0165201997157673, 3.1163608791555402, 3.0094812479047603, 3.0036660578806051, 2.9553128151051493, 3.1768492799503343, 3.1589082303941853, 3.0324811830121847, 2.9297571998787166, 3.1023327962587404, 3.0533287604911403, 3.0185873987765821, 3.1294195929824649, 2.9097611476693541, 3.2549785292756943, 2.9886436011795912, 3.0976553031159511, 3.1102685145428830, 3.0702770359848111, 3.1040902701600230, 2.9336062593269556, 3.0295703404401695, 3.0424959143725920, 3.0204870824635117, 3.1502877816091281, 2.9858944318231053, 3.0881174291824118, 3.2197681238065052, 3.2488595717137017, 2.9191974144262507, 3.2749957750626888, 2.9578334712070848, 3.0963871714631375, 3.1498809778342127, 3.1001020581403722, 3.0675048260615343, 3.2379357615236284, 3.0129755585547660, 3.1918220329523699, 3.1421387573920159, 3.1300979840613588, 3.0197491817162221, 3.0568666511186926, 3.1316296772826120, 2.9678952252604516, 3.2295219978032277, 3.1625854306989218, 3.2605199481287630, 3.1100107660797645, 3.3010250663801979, 3.1878761021559323, 3.2001751141974637, 3.2172904861254485, 3.3156729000053771, 3.1529613425049550, 3.2638952100959964, 3.1191581525123349, 2.9710034477966616, 3.0938380020900946, 3.2995039003685074, 3.0508305942790477, 3.1597219869970807, 3.1013468369150323, 3.2284960343006519, 3.1392673218013307, 3.2087458426645781, 3.2204368310962068, 3.1292492976436321, 3.1682736722905984, 2.9653190233424964, 3.1570206924158657, 3.1176134207898221, 3.2128024253758625, 3.0998708228461536, 3.1546425561186786, 3.0307215632012587, 3.1665380477372365, 3.1947131180092008, 3.2466100374561431, 2.9909800049889661, 3.0234745606385753, 2.9851473453273742, 3.3303100002620809, 3.2385283299188026, 3.2662772701372065, 3.1808666096995397, 3.3588214903501350, 3.2441582554870858, 3.1221463532837257, 3.0474815381957168, 3.0637107118484286, 3.2359348725945232, 3.2885309033414094, 3.4028019047060161, 3.1148000555964304, 3.2582154883583736, 3.3837986605505930, 3.2286458279600128, 3.3949890384108303, 3.2509741108388792, 3.2024831894711663, 3.1491924119439552, 3.3284051909157690, 3.2752176412577980, 3.2733145511083968, 3.2788268538443401, 3.1592258198343650, 3.2676556868029638, 3.4100187500063330, 3.3562117978724548 ; ... % y11
 -3.5973534894314989, -1.8107702832700461, -0.4713619411770356, 0.6612741514155140, 1.5451665034617403, 1.9367207505116824, 2.3704325327825493, 2.8341498857208429, 3.0100167904515347, 3.0487738723381872, 3.2460366901450168, 3.3910820761162830, 3.5876443525696771, 3.5561617809933508, 3.7413245466277329, 3.6207029098967296, 3.7296381812631139, 3.7663219783297239, 3.8027314624763005, 3.6235693361563199, 3.5586420849320044, 3.6697495599337815, 3.8104892696330244, 3.6972674016282041, 3.7172916361121313, 3.7353417311620651, 3.7592903392725154, 3.6853857843349758, 3.5515111928398690, 3.6465442280598461, 3.6465906496686480, 3.6649151314681960, 3.6645688474212705, 3.9066268599721710, 3.6721898858461235, 3.8171421034723689, 3.6929876125942256, 3.9303834072243871, 3.9946377740091212, 3.8388517570828924, 3.8306908168699803, 3.8713649770701006, 3.8470609133601155, 4.0872021562463541, 3.8226561246326050, 4.0117620902985518, 4.1394751065460493, 4.0600555228039727, 4.0251951378314450, 3.9620513055554087, 3.9391049001301366, 4.0958803579056697, 4.0086775136743116, 4.1858504410659396, 4.0418884336494862, 3.9799377429690845, 4.2696314937575313, 4.0970333111443109, 4.0955953285071995, 4.3399098651530217, 4.1353041405596462, 4.1360367136062450, 4.1242141651020514, 4.2305384630573286, 4.2480405753728441, 4.2544751046951452, 4.2540164423610216, 4.3035182697010281, 4.4626343260228927, 4.5108435858294671, 4.6201711930194440, 4.3312938274684107, 4.6284838133815676, 4.6481337923979824, 4.6943424834530036, 4.7392858056655829, 4.7039722427258575, 4.6739096708223178, 4.6594693021913551, 4.6722335807547921, 4.5954766748307625, 4.6098171120696403, 4.7977962022273077, 4.5974412863230487, 4.6913612606913864, 4.6442780440201705, 4.6252736868901163, 4.9948999720345206, 4.8416395289552616, 4.9945434626476368, 4.7718925619740196, 5.0310921688851913, 4.8537687511864274, 4.8246377679567667, 4.8869737407573348, 4.8010387978488467, 5.0768939726886062, 4.9480447323645782, 4.9638866313614276, 4.9968320570403053, 4.9280109130332681, 5.0901798733269485, 4.8551038177126289, 5.0930547458733963, 5.2133792871972320, 4.9156377850839785, 5.1794113403274409, 5.0392565943512340, 4.9328624777947798, 5.0856677368048819, 5.2339401055652894, 5.0432279440711465, 5.2500374599209136, 5.1319145411285412, 5.2217085410179349, 5.0929334379919009, 5.0977719224987545, 5.0074599835589622, 5.2506276689830376, 4.9473482253815471, 5.0051653238178284, 5.1946375380470817, 4.9785935385119577, 5.1863818208345291, 5.2036662873055270, 5.1381597183530738, 5.1994413524384857, 5.1321276765435568, 5.0912269362604281, 4.9523701886356868, 4.9810550770282633, 5.1203456035485289, 5.0104142305288226, 5.0543226837617192, 5.0164348483452317, 5.0265181714578038, 5.0680711914477161, 5.2360017457169832, 5.0250577097928870, 5.0503154094121143, 4.8638627641265701, 5.1039246574176032, 4.9364224279258044, 5.1252418402125297, 5.0668927404173107, 4.9383967594565137, 5.0628293604689079, 5.0859138657966918, 4.8555362727987932, 4.7821362019514195, 5.0785790347974036, 4.9221824685278408, 4.7770186257843283, 4.7845031148991115, 4.9074154888434744, 4.7627567372448407, 4.9316301808401999, 4.7955192912780111, 4.9609479251367867, 4.7040207500327140, 4.8225736633743672, 4.6327675951166691, 4.7912371494291470, 4.6366711927256654, 4.7122892277688520, 4.6524355557242520, 4.5349077162066314, 4.6374865878377136, 4.5704782438194389, 4.4495817530410324, 4.3539443830352962, 4.3358575934875976, 4.2916765829163399, 4.5199105191824636, 4.3954246863278632, 4.3539504532352487, 4.2056131759919202, 4.3398772676579158, 4.0907089379717219, 3.9796984896613257, 4.0461231910696940, 4.1251156793005874, 4.0469784332340577, 3.8383728658544869, 3.9497335982479735, 3.7875846986472990, 4.0359577725721705, 3.7561012919856149, 3.8677245468154893, 3.7438941541796638, 3.7900829173996518, 3.8129464138155043, 3.8304278391360542, 3.8154021292810922, 3.4882853959863831, 3.4606305367815109, 3.7482200184320664, 3.6479359439342707, 3.5921713626761766, 3.7776982424183312, 3.6419307681610524, 3.4728197568941090, 3.6386454171019169, 3.6585093116846767, 3.4581901167037921, 3.6074502694299451, 3.3660116531120634, 3.3790028352933810, 3.4328896495565404, 3.5397898544158011, 3.5559956858719235, 3.4201609491093667, 3.5153324615705639, 3.6415129403070399, 3.7007909963121137, 3.4581078407869419, 3.6007361115431560, 3.4574848322963279, 3.4429359540908595, 3.5909129274226954, 3.4686358884404700, 3.3532809791234182, 3.6477123730551293, 3.3863737580172097, 3.5273905900475406, 3.4609958870764888, 3.5336887740190361, 3.5492255874135963, 3.4835848679101749, 3.4203982812399825, 3.3921767812122283, 3.3092170015229514, 3.4106996022201197, 3.4470194532981795, 3.2414199581760355 ; ... % y12
 2.4204065891858417, 2.2972275972988125, 2.2299868997271401, 2.1366836442252097, 2.4778263841426162, 2.1410654898021444, 2.3431777954724131, 2.2416922204783329, 2.2544320129180648, 2.3818353663604137, 2.2237154115515216, 2.3200644219863444, 2.2700390169344629, 2.3501885973107957, 2.2353817220172281, 2.2853669093051270, 2.2168554563904825, 2.3263556764890003, 2.4399284191784663, 2.4867374945494034, 2.2926214507678115, 2.2922115682372963, 2.4926473066861163, 2.4448354368307750, 2.3671695980822745, 2.5828435579186495, 2.4203271892744236, 2.4850642726496170, 2.6274392731748022, 2.4524509748389041, 2.5564024282099025, 2.6453943435890581, 2.5553625588093785, 2.3213259869778562, 2.4797407359554295, 2.3807467139826537, 2.6583751823605426, 2.4285622563448857, 2.5116018042912356, 2.5474980159023870, 2.7307245365271005, 2.6206047698785997, 2.6357272036714057, 2.6625998725063673, 2.6862172600940695, 2.6387801626363343, 2.7103646276169608, 2.5053685448308367, 2.5217724760530009, 2.7607131679386221, 2.7348581856935574, 2.7774252016411660, 2.7688308610849042, 2.6011304705903258, 2.5051729560276637, 2.5965346260679816, 2.6254748461047361, 2.6924377939667981, 2.7346575977286465, 2.8410053717563248, 2.6891490439155783, 2.7654698055912146, 2.8520566639076379, 2.7542377740525343, 2.9221049805009298, 2.8798157497868151, 2.7446972554182731, 2.8902287856444824, 2.8678246631357487, 2.7122918660413506, 2.8770579474350719, 2.8340968911953861, 2.7074058316701075, 2.9569607317531146, 2.9419052574132452, 2.8859180030395022, 2.9539924700300602, 2.8459729771631963, 2.8740860186468167, 2.7805772574337380, 2.8614570702462192, 2.9936943030289727, 2.9951132889364644, 2.7742210306171895, 2.8222629761174454, 2.8222731104493182, 2.9935649778168982, 3.0103474467401812, 3.0893131972631047, 3.0554372025615386, 2.9982318455654200, 3.1245138706551270, 3.1713215328584683, 3.0274744620733487, 3.0461961586861226, 3.0820545517199389, 3.2492642734611272, 3.1927879971243245, 3.2496606656448215, 2.9899283871465263, 3.1402502688983049, 3.3268735073153746, 3.1747755870615979, 3.1256150384104542, 3.1759749100679793, 3.1667702496403654, 3.2700213236843902, 3.1276369403850901, 3.2378969478970663, 3.1791016892556994, 3.1586752442877279, 3.3565368709869468, 3.3221357818158510, 3.1586121844078594, 3.3275521120371967, 3.2558870407216460, 3.2458898461111012, 3.2398909011583412, 3.2902444293061839, 3.1699391015926026, 3.5055118076087934, 3.4952936309824159, 3.3012418736155955, 3.3923861401772100, 3.4537709364619471, 3.3139968221293601, 3.4417527482437857, 3.4528408942942415, 3.4906885551854514, 3.4293789547903200, 3.4030528411658714, 3.3150651658589934, 3.4405048987366103, 3.6385128588774167, 3.4287837913784771, 3.6305636232258798, 3.5388830459867355, 3.3773993354631484, 3.5883190508357394, 3.3869539384012954, 3.6879184527947371, 3.3551709116831776, 3.5068959455145241, 3.4698218874041240, 3.6331652115030550, 3.6097636867210636, 3.6095054219552285, 3.5262295339839898, 3.5239594392910991, 3.6943901027307038, 3.6104519496344136, 3.6750761405453836, 3.7065124356396431, 3.7022435258203243, 3.5369804247506780, 3.7391021130855266, 3.6323507562201116, 3.7519088767834834, 3.8327912497819243, 3.6239567307218414, 3.6966948939120536, 3.5747823538931995, 3.6386925989744925, 3.7383853959636855, 3.7644840884584450, 3.7021264905576530, 3.6842051031299410, 3.8300368280234260, 3.7777579835693538, 3.7240457844099435, 3.6830040437504477, 3.6690584241398514, 3.7329221877268046, 3.9735667477044396, 3.6505462708039893, 3.9337170136602628, 3.7897624182589671, 3.9618189638537369, 3.9346083563585084, 3.8521515763178118, 3.7575415724275336, 3.8949063179249581, 3.9561185745927405, 3.8259723544993292, 3.8102395164461598, 3.8306067565348121, 4.0590290010456682, 3.9486035320514947, 3.9861798480291495, 3.7492826800953361, 3.7341218187337080, 3.8331247064119318, 3.8982750325723745, 3.9484077289939838, 3.8550962411597225, 3.9143534309925609, 3.8497936770659349, 3.7773381748946355, 3.7711657523980016, 4.0312470822229010, 3.8780924403532389, 3.7776089455990984, 4.0365619221086515, 3.8617362427799318, 3.9518225414160471, 4.0549592281076796, 3.8472003451022405, 3.9827030609640626, 3.8017376752836194, 4.0148707451085528, 3.9867227751770815, 3.8121000660431159, 3.9392005363574372, 4.0475933031652129, 3.8152548264943364, 4.0190274058781403, 3.8036012729822928, 3.8803810163402117, 3.7568023141623099, 3.8354825001283119, 3.9940201608727279, 3.8239375063724830, 3.8445984463642171, 4.0615626548640460, 4.0354070057168503, 3.9981426718997728, 4.0154591825287040, 4.0405427152764943, 3.9951054310438243, 4.0916186172595506, 3.8703372030042957, 3.9227266419858622, 4.0297125995397103, 3.8958760997380577, 4.1137058418559240 ; ... % y13
 0.9446790786471049, 1.0313083120187789, 0.9243075422700469, 1.0310146899068307, 0.9735750618249510, 0.9650710305477612, 1.1911702629816774, 0.9845975150368013, 1.0516716950875307, 1.1342243080777710, 1.1585735705476568, 1.1365697850020204, 1.0617561862549869, 1.0708056413200764, 1.2245629913741145, 1.2842619731622409, 1.1560260735164267, 1.1223922856291308, 1.0817892879592479, 0.9838828554631003, 1.1471679796906682, 1.0227071242812658, 1.1760689232053469, 1.1256761907694983, 1.0777378739534429, 1.3096908635640774, 1.0899798267033842, 1.2317642422504886, 1.2618081276192055, 1.1811534190634203, 1.3288615893909408, 1.0720061578845732, 1.2280057218996574, 1.2464125620354876, 1.4028720391562461, 1.2218438381036765, 1.2536007798032218, 1.2231462705764669, 1.4061513339918241, 1.1489915537687720, 1.1660504358115027, 1.3031642930536549, 1.2780464501808897, 1.4890059514248537, 1.5090560555315238, 1.2856787870102160, 1.2306115695333626, 1.5068835515131562, 1.4744716212948694, 1.2312344659994239, 1.4070644579044949, 1.4453735599232957, 1.5023323974535514, 1.3008664838515569, 1.3113050213515300, 1.4187310261873105, 1.4878849211268386, 1.3435060821325759, 1.3872750573445936, 1.4583061392415559, 1.4767620132397035, 1.5239019237964431, 1.4032648250512527, 1.3923509304556649, 1.4359669891795155, 1.5876641131747038, 1.7318864254935642, 1.5935407195460134, 1.5738956443149126, 1.5635164494944882, 1.7539897256804180, 1.7095345280728089, 1.7944354187698710, 1.5398058511620327, 1.5846309334373174, 1.5396948285836127, 1.6169411918101333, 1.5754341666403500, 1.7559112121985259, 1.7407145178543333, 1.4927838793733443, 1.6496099491343816, 1.5973097642241125, 1.8297542955149071, 1.7914758341349051, 1.8907383806814422, 1.8085743143117621, 1.6367326543283600, 1.6378995106612257, 1.7929963416535544, 1.6556745462598239, 1.9440099676217868, 1.6245793206435246, 1.9456226259371578, 1.7767586157946840, 1.9063364185429170, 1.8109349223579083, 1.7169817757836705, 1.7705401993600010, 1.7628766599113017, 1.7901063356357734, 1.8558125607572631, 2.0102036762360118, 2.0899571332821680, 1.9806504427532630, 1.9132151725428712, 1.7645341463795361, 1.9275898681272374, 1.9145559797484979, 1.9316909296877438, 1.9345283892432596, 2.0758618018174406, 2.1617045944428224, 1.9513415476218143, 2.1386223276500504, 2.0436821050771878, 2.1462614127111261, 2.1581439919698235, 2.0913623592240977, 2.0601948573220303, 2.1500018549404363, 1.9842684936440695, 1.9899577609902301, 2.0307695015421205, 2.3146999948690277, 2.2089365969131753, 2.1678036031903658, 2.1979552855915161, 2.0145851450954195, 2.0689198935611990, 2.2243951585527704, 2.2072389690827579, 2.1355702406330908, 2.0780441656904776, 2.2296973263762219, 2.1861174371231877, 2.0852878307778844, 2.2997459431108167, 2.1660403207861139, 2.3971352155987273, 2.4203529878721941, 2.2122415530536914, 2.2838948144117208, 2.1053297917230269, 2.4717851295784667, 2.3694847239944066, 2.2502383687824135, 2.2519992092275158, 2.3062231396966184, 2.3416775386285895, 2.3489326576235041, 2.5591139269707290, 2.3229168270003897, 2.4547013992449562, 2.5665634457634816, 2.3779811463651637, 2.3535416671848735, 2.2277098475329202, 2.6196984544614965, 2.5176889046967679, 2.3749795878211435, 2.3652206767132387, 2.4515415091943837, 2.4606074845245436, 2.3315874303944595, 2.4556559070418329, 2.6371645072132961, 2.5408583467684274, 2.3728616878230371, 2.4521570914696977, 2.5666841788929129, 2.5867454612762497, 2.4272325723211212, 2.6208689180313520, 2.4849198714910448, 2.3974443433164065, 2.6344163098491662, 2.5650610705333636, 2.5202255206424455, 2.6770694416136731, 2.5685919811705129, 2.5713943076517660, 2.6618467195694211, 2.6210152725350739, 2.5261612510749822, 2.5747295934045260, 2.6848806283180022, 2.5845740732669378, 2.4471104387865936, 2.4614931860153142, 2.5777411275564481, 2.6103863560448981, 2.4849053503692007, 2.5366127129709608, 2.6299900696637586, 2.4735938484218578, 2.7359175817343337, 2.7062232122222563, 2.5481085364098464, 2.6214579617715743, 2.6509141393481639, 2.6293899842205213, 2.7089082268850326, 2.5396808512418421, 2.5656007149036686, 2.6785643025737880, 2.5699653406038454, 2.7715828655785026, 2.7672303848799631, 2.6151872250213297, 2.7573025868563503, 2.6170779928816970, 2.7579529283207624, 2.8495941052606275, 2.7520838500718203, 2.6645705574909107, 2.8526335439963622, 2.5813406439536406, 2.8262517808439025, 2.7392650828964982, 2.8618626880500639, 2.7146985177726908, 2.7549886071308265, 2.8349868542108307, 2.6561044022056035, 2.7009941399377020, 2.8241703504797622, 2.6176936754455031, 2.9073359588771805, 2.7101940173866157, 2.9690564228551852, 2.8305093224825453, 2.6754351823761118, 2.6291848964925162, 2.6794006304225828 ; ... % y14
 -0.6268518972568782, -0.4169142533166457, -0.6741913666617330, -0.7815848635760274, -0.4157072777530814, -0.7600579444967874, -0.6227232990963036, -0.3604303444779356, -0.6651881602634258, -0.6351446856358202, -0.5791252454151651, -0.3938253369171775, -0.3843342462523052, -0.4604976692540403, -0.5376067414753365, -0.4897164150829958, -0.5457666794338587, -0.5539015602196514, -0.2992332112168179, -0.4942390444724251, -0.4799628842189576, -0.4253256250262391, -0.5758332078089108, -0.3322979373017979, -0.3458800732780108, -0.1773119424400388, -0.3525802282649834, -0.1977039492599503, -0.2307387959812033, -0.3499423061077844, -0.1576091422925223, -0.1903946579880682, -0.2990043114333524, -0.3299123283633998, -0.1230104842147016, -0.2780690590963405, -0.1860226851877800, -0.4075179358269435, -0.2431293308262426, -0.3597046156794177, -0.2838369860814121, -0.0387363982810467, -0.1647443889768543, 0.0278144951446838, -0.1613319922070922, -0.0890136529691559, -0.1569078543623117, -0.1601152304804956, -0.1155533813030805, 0.0590989729866108, -0.0111677002818368, 0.0395834424232062, -0.2246453445996477, -0.0460353976330098, 0.1316054126184346, 0.0865756587034868, 0.0800531801486314, -0.0091774356026246, 0.0266798551354661, 0.1868709008331370, -0.0125111318357724, -0.0910953238823735, 0.2554975250173752, -0.0302611085031785, 0.1574016916507276, 0.3472542526595375, 0.1837808624739447, 0.2603549800022657, 0.3540409895181565, 0.2940405230728930, 0.3722363094469802, 0.2791008373491828, 0.1191868120704063, 0.3703153679989236, 0.2120586890109548, 0.3056630457247443, 0.3368557483821136, 0.2172650936503871, 0.3615222569173946, 0.3969788669171828, 0.3412678498731397, 0.2102431569998917, 0.4305732551497838, 0.3544182907916263, 0.5439169631036594, 0.5856667759660135, 0.6297622828510776, 0.5639121611545780, 0.5955874491446236, 0.6857771106303122, 0.5785448697713614, 0.7208274739379682, 0.7213507891455744, 0.6975951336375887, 0.5492250407069884, 0.5587737986845872, 0.6807739656702326, 0.6161987937609124, 0.8164061272314538, 0.6199309070706542, 0.6785722699630510, 0.7024755528321949, 0.8031292591942636, 0.8334143776739602, 0.8626142707117503, 0.6130442669122298, 0.9177966871645517, 0.8004679315455020, 0.7596755689907677, 0.8460252447516010, 0.7599291497913104, 0.8925940292758903, 0.9369516625776623, 0.9232343875452114, 0.7521684798972521, 1.1225730615018823, 0.8510144337352928, 0.9796171326979204, 1.0442799230617079, 0.9754836844434981, 1.0757771702946590, 1.2132764824355078, 1.0547077737025774, 1.2032319221686105, 1.0818227811840022, 1.0813818467590341, 1.2363663151468154, 1.2064605452863888, 1.1521922710755310, 1.1216290854451478, 1.3045919447933845, 1.0806644501670755, 1.2780667356063831, 1.2982845648430312, 1.1080961119305666, 1.0437741560734848, 1.2979113020393864, 1.2732527649009322, 1.4484779550566560, 1.4263263512122288, 1.4637140436269260, 1.2200656153585425, 1.5146014420385736, 1.3810380331120340, 1.4548982779461028, 1.3360358019805805, 1.3986678066394800, 1.4332301789193658, 1.5666270912433553, 1.4269365710672137, 1.3011995988867466, 1.3649904553158325, 1.5248342728718074, 1.5590001145472296, 1.4647165843223788, 1.3628628137485528, 1.5956093860680376, 1.5855783825678833, 1.6905030471532616, 1.5283268074996887, 1.6815605857073175, 1.6754723712745649, 1.6628146602569500, 1.5637287182644288, 1.7001400488157030, 1.7293181445285382, 1.5580821470850048, 1.6631550930285444, 1.5592491547968339, 1.6979165144512198, 1.6103628441048055, 1.6330479399186058, 1.7234993678656190, 1.5740590843904116, 1.8805835850206087, 1.5336106174318613, 1.8646845080948666, 1.6779476264289730, 1.6024166325739215, 1.8877305084118405, 1.6432766975928514, 1.6508110087929209, 1.6604842862739637, 1.8992448911835780, 1.7753350887037045, 1.8528684089732372, 1.8268481083860255, 1.9393627698309519, 1.7616635440729169, 1.8212810543524633, 1.8975797702459920, 1.8175592312381781, 1.9337297315854893, 1.8740627843525459, 2.0832173231895723, 1.8225098719926005, 1.9662752300714335, 1.9050467569113796, 1.9769534804513753, 1.9040440386424231, 1.8490741711545595, 2.0609243937155641, 2.1900401778301988, 1.9325284008380399, 1.8969705226715641, 1.9685303068620426, 2.0975847766314923, 2.1432114304494472, 2.1883944548437300, 2.0311187749559476, 2.2009260301408498, 1.9787639625529470, 2.1676869555860083, 2.2192303272228422, 2.1580403665289953, 2.1793442820989237, 2.1929211568236044, 2.1287987925166725, 2.1730273251451839, 2.2747500137387262, 2.0190919078593255, 2.3450381514059346, 1.9995725517283818, 2.1298130407202818, 2.1292713522713012, 2.0721773484482573, 2.0732454216381329, 2.3458460430909569, 2.2265932962704924, 2.0931510370242430, 2.2269223407110763, 2.3124712456976559, 2.3821077637320869, 2.3074134711288896, 2.3939883841204259 ; ... % y15
 2.4937918421998657, 2.4959144067064538, 2.4661573115670135, 2.4115771040737579, 2.4631541696782389, 2.3171320398652560, 2.2061531080522645, 2.3547620552842030, 2.4225212750412268, 2.1734031702721870, 2.3619121631645879, 2.1929866169122230, 2.2023541225254886, 2.2019819602412181, 2.2372400712303415, 2.2516311065247283, 2.3186948024491327, 2.1562504529646995, 2.1201600939673049, 1.9842573917767574, 2.1826934244290195, 2.1933317885106196, 2.2588368863765802, 1.9879666211321017, 2.1267369478173186, 2.0976045793848299, 2.0069121919372450, 2.1107237088223378, 2.2528566471647533, 2.0690290748719598, 2.1060622460262151, 2.2247621283721912, 1.9442201088436646, 1.9779679288765304, 1.8227585465039726, 1.9682648743282376, 1.8875648876981075, 1.8590756872751977, 1.9183094119284818, 2.1543066644535349, 1.9732145524704992, 1.9513812891369928, 1.8668425445025056, 2.0729285270293794, 1.8286253067870406, 2.0131951641922710, 1.9164998099527837, 1.9010829774533824, 2.0885730925860204, 1.7847105381985224, 1.9186595330545440, 1.8801477384059844, 1.9564266511160426, 1.9842436749568066, 1.7045180128078443, 1.9283191989284683, 1.8117655792219591, 1.8570138240300891, 1.7491019257260549, 1.8859936470124699, 1.7025492598596266, 1.8697005542983192, 1.8059913814320114, 1.8231438186474114, 1.7290716901178722, 1.8479278740072218, 1.8325875671982941, 1.7717826557433898, 1.6054843756548813, 1.8675041882253087, 1.7859135713329397, 1.8055128624377657, 1.7293845141864757, 1.6918791699107574, 1.5467801673259898, 1.7936374562045547, 1.7165179511533626, 1.5200491230764370, 1.7207436434742962, 1.7506783361411626, 1.6087199287627878, 1.5172212393631788, 1.5597431764309324, 1.8226954879018231, 1.7386787374140413, 1.6628577288405741, 1.7912769195017553, 1.5906892446855732, 1.6868046866015802, 1.6367912094026309, 1.5805387635278096, 1.6079755080901905, 1.6372929065380333, 1.6094187453077320, 1.6202165570736884, 1.4824864395665263, 1.6393802683350331, 1.6572632556334987, 1.5875748208842189, 1.5334134078321258, 1.5932131653349062, 1.5227546845271709, 1.6204271866574340, 1.7016903633379867, 1.5376849966257784, 1.5800677358536330, 1.5142145547809505, 1.6009251089180758, 1.4977531533058324, 1.5275060739321444, 1.6283480070266894, 1.3777422607317802, 1.5554328055961824, 1.5496985433190871, 1.6120555340599623, 1.7132447007496228, 1.6548928996080867, 1.3851063236527701, 1.7512133797730010, 1.5405375542253485, 1.6106162883006672, 1.6061779778443863, 1.4672198280329611, 1.6776146798539602, 1.6429105677816878, 1.5592870083930352, 1.5919163291748772, 1.4304042644994022, 1.5767592201005460, 1.5120742750857339, 1.5164408419275648, 1.4749711349022698, 1.6817362917877805, 1.5616852849912091, 1.5751240483160889, 1.6210469241272125, 1.5622512778403994, 1.5909861734719120, 1.5224938325510280, 1.5091010460561871, 1.4662342891804676, 1.5281155843914112, 1.5597775217044541, 1.4191082976169096, 1.4585310999432930, 1.7155032742995007, 1.4594746208545866, 1.5954653659560536, 1.5085929379200593, 1.4476360469273433, 1.5771605038116234, 1.4996533135618679, 1.3978357778178676, 1.3861422827837346, 1.4759211385313979, 1.5340071651306195, 1.6035731366623600, 1.5940100457634521, 1.5814850066179611, 1.3805738504337668, 1.4987617404949878, 1.5631039043683839, 1.5325871903745840, 1.4797747008901414, 1.5951682128190763, 1.5193525117993192, 1.5132149375649961, 1.5022760868487197, 1.6025109596567142, 1.5521060772720434, 1.4834595185913728, 1.5455055720072404, 1.5621955413734034, 1.6326570901597448, 1.3475471202938698, 1.5016595143909097, 1.6113756995642878, 1.5095693983742893, 1.5190157549889642, 1.5547923148089917, 1.5898313221920368, 1.5857408165592370, 1.6256924311938021, 1.3326115567915988, 1.4712343471849476, 1.4672883152002250, 1.5768691905839054, 1.4529386697184210, 1.6344065799776781, 1.3828449685196744, 1.7156729115418030, 1.4599876889721637, 1.7224700965912625, 1.4200225847526755, 1.5373810983125638, 1.4028535088340772, 1.4856944908066654, 1.7150348742668144, 1.6777796947273349, 1.4549318743661381, 1.4798660514595561, 1.6969529600768118, 1.5440095012094175, 1.7387736516769039, 1.6258653465262618, 1.5993675969220320, 1.5119755024560342, 1.5162001927771207, 1.6993214265551497, 1.4881173397658900, 1.6843646268106631, 1.4286601159964907, 1.5008492075716129, 1.4812399084846122, 1.5751428876581564, 1.5299533921403694, 1.5477600592809964, 1.7434177181126378, 1.4985878587468362, 1.7362233458345226, 1.4259330215581987, 1.6677505290031851, 1.6259582556451198, 1.5304192725218988, 1.5891630588901922, 1.5506710147893865, 1.7476047114978928, 1.6608037131755760, 1.4960231249124001, 1.4277520201914093, 1.7963588410736986, 1.8114547921084228, 1.6441580614343576, 1.7819630057731803, 1.4916349561960205 ; ... % y16
 -1.5223727405297049, -1.5709766219953454, -1.2498669523586239, -1.0403638137480491, -0.8724311775965247, -0.9192680257238314, -0.8382429224291172, -0.8247456241645110, -1.0229185699011982, -0.8620445797905928, -0.7705969164400889, -0.9413381070607300, -0.9445969453422933, -0.5981789991122934, -0.6805742892440779, -0.5903329077406831, -0.6924998440249976, -0.6266217943876070, -0.6100943082068001, -0.6203032382436904, -0.4979451934808825, -0.5559395180875486, -0.5965982918901446, -0.6631119276236501, -0.6367946067763528, -0.6671905041024723, -0.3529541677003143, -0.3974327324735694, -0.4680021356859420, -0.3325641978448487, -0.4603614016550331, -0.4049979026121409, -0.4752994404578508, -0.3152585500966696, -0.3604389553285692, -0.2622152252356150, -0.2600203808741843, -0.2249338850406335, -0.1899762671110003, -0.2140603519740932, -0.0407935144127020, 0.0074180514106976, -0.1073398212359569, 0.0190174650844708, -0.1046012209738485, 0.0002395723866920, 0.0584578191466504, 0.2156739386591083, 0.2793321951095756, 0.0129707366058489, 0.0365076426010755, 0.1800260733879389, 0.2694915086853919, 0.2195707007915981, 0.2793873905865320, 0.1299848639069268, 0.3757952459482584, 0.2677803992105720, 0.4676322274013273, 0.3199263228491191, 0.4714736804985936, 0.4891780797739342, 0.5628286885433650, 0.6059918169107106, 0.6332089421352138, 0.6164468832686204, 0.7638043533540436, 0.6594585262529195, 0.6615019087986764, 0.9173481341051868, 0.6818148757067468, 1.0176100332513787, 0.7632347887664930, 0.8864998231973872, 1.0229619857456078, 1.1504873234256427, 1.0462730507075020, 1.1580238781486629, 1.0331190070853695, 1.2132172168310540, 1.3554037279094211, 1.2653745578204745, 1.3130726461719373, 1.1174768894639318, 1.4717913087804164, 1.2357398710283654, 1.4654943137195298, 1.3136604016824156, 1.2736624484459615, 1.4681686624537154, 1.4219482258626108, 1.4121348178830244, 1.5738316387110001, 1.7159856949497954, 1.4300654481450801, 1.6429752507457045, 1.5754549530851116, 1.4977980897106833, 1.7428287654675412, 1.5227397984482101, 1.6814245398984282, 1.6628941793033560, 1.8673551107780115, 1.7604466600973501, 1.8394468898232339, 1.8966651405319128, 1.8696382555817235, 1.7682715836176537, 1.9378790146988965, 1.8590755525127867, 1.7680985702152732, 1.9605123597574203, 1.9421117029113770, 2.0153034270374786, 1.8774986194141952, 1.9455880097556939, 2.0669444590467525, 1.8261955228392910, 1.8668957671477588, 1.9093458162929047, 2.0412644056422251, 1.8494675682715997, 1.9323527745380749, 1.8469347991854665, 2.1158585126101186, 2.1440971544116207, 2.1635884665640157, 1.9339767514548305, 2.0717841682433282, 2.0664458745935375, 2.1036315592425354, 2.1776691219350486, 1.9098932262769674, 2.2644203976074664, 2.0233028262297297, 2.1998783700193809, 2.0273856821160585, 2.0751994911160780, 2.0900998081582713, 1.9967684691281113, 1.9802529026286582, 2.1583880955180765, 2.1679823936341802, 2.2308759282334174, 1.9862921145414802, 1.9550343003512434, 2.0776876161269437, 2.1658751985919311, 1.9793449043837759, 2.1913916716009894, 2.1446694838237175, 2.0127846796416309, 2.0441675525460599, 2.2404768639440507, 2.1402955125331951, 1.9301833277721894, 2.0183207202484614, 2.0969619246473976, 2.0317575201688811, 2.0825038704867942, 2.0911521897508241, 2.1046938325422997, 1.9388180515322921, 1.7853246385721144, 2.0816904188310104, 1.8396759237689231, 2.0135922361310428, 1.7952435576820900, 1.7553541591403496, 1.7901301081342753, 1.6674284754879607, 1.6697464871678234, 1.7906703216140907, 1.7427615452993552, 1.5701884488912565, 1.5970171971016862, 1.7104818774757278, 1.4118118544962364, 1.4163603709200419, 1.5655331806588855, 1.6650543196289422, 1.4993124391352071, 1.4191272202975060, 1.5838853879928292, 1.4738358733664303, 1.4913456968690657, 1.3471320652286354, 1.4068509339236828, 1.2138369287832931, 1.3592533368411379, 1.4019305468549437, 1.3297433466077271, 1.3628554097663330, 1.2910500992333327, 1.2912271336275762, 1.0605689921192991, 1.1764858852865232, 1.3068330216558284, 1.0486478043873764, 1.0896665562470291, 0.9728945560313242, 1.1449050227475208, 0.9291184327448953, 1.2747459684866780, 1.0837363515880933, 1.0480884263680990, 1.0053587552338938, 1.0926335227322954, 1.1957068963115678, 1.0657219364481652, 1.3004218812439683, 1.3302314879392805, 1.1381318019618736, 1.1834796761281448, 1.0719092232698846, 0.9822624081943234, 1.0865910532275942, 1.1790630813986289, 1.1391019682912455, 1.3147199010305382, 1.0963665021200781, 1.2429554925702437, 1.1662481858979561, 1.0668993485526992, 1.2636090988486453, 1.1788902317766388, 1.1341720592827229, 0.9874063592577466, 1.1892036058242337, 1.0884494848059716, 1.1778426717382207, 0.9722936985866784, 1.0833071561682315, 1.0377728836243905, 0.9857232000593064 ; ... % y17
 1.6935927707762168, 1.7192914103314869, 1.5771082646636287, 1.7529198620693360, 1.5675144385148054, 1.6670947127919076, 1.5706911782055868, 1.4747703470131819, 1.3294595311671535, 1.4882149412705719, 1.6184279992975787, 1.3155664860733338, 1.5187717705365973, 1.4559425495017533, 1.4968259654742586, 1.5289753337650946, 1.4430145519287645, 1.4134970748863915, 1.2981180512727766, 1.4256851199188512, 1.3994350510415676, 1.3967315962717672, 1.4572411381030568, 1.4187820554098640, 1.3598347829132966, 1.1899723134230031, 1.4875936363354678, 1.1810050346756180, 1.3000678920495408, 1.2894250316457296, 1.3913566749278958, 1.1537049347778090, 1.3486809107899425, 1.3100722347574294, 1.1427200761680560, 1.3029485621173749, 1.2965207960762637, 1.1368124225613305, 1.1409011353105603, 1.3985782832099281, 1.3587975638398004, 1.3387058437222616, 1.2830864925633265, 1.0996958436062905, 1.3941641367146167, 1.3192843676147583, 1.3006222783266042, 1.3321530368994969, 1.2330977586559526, 1.2033965544880418, 1.3174321275817207, 1.2320931962840971, 1.3890890244990390, 1.2275192927637382, 1.1712658197183778, 1.1532072844043237, 1.2367816758210350, 1.1357196396761529, 1.2449005327044713, 1.1155769831402556, 1.0434193436435748, 1.1112622420206979, 1.3775956104561129, 1.2217467551050005, 1.1997582052193605, 1.0340154541946021, 1.2133525917022217, 1.1286467096889461, 1.1727033935284263, 1.2709843034375889, 1.1965973712440587, 1.2589410618788937, 1.2776487087813142, 1.0597613139769952, 1.0047903799608648, 1.3545582401787246, 1.0824903501801246, 1.2703616944327332, 1.2371135236205357, 1.2574126629241276, 1.0182606473116815, 1.2625123023998801, 1.3022854917471438, 1.2716269062421008, 1.2565233858967066, 1.0300050877538776, 1.0526279605477711, 1.2074845569470354, 1.2484577195380069, 1.1963192025454883, 1.2446522436861174, 1.1559936478357049, 1.0899431545399276, 1.1810707265442464, 1.3424536365846593, 1.1256620076578896, 1.2663167836523883, 1.2513496470657257, 1.2838993501198166, 1.3171011406701987, 1.0166926443659023, 1.2497857312987932, 1.1500268973470846, 1.2003795792490153, 1.1091496444982101, 1.1986986748849047, 1.2003200983701183, 1.2518822091515385, 1.0780516900477555, 1.3787419897008901, 1.1505175770208707, 1.2058836117725928, 1.3351823244169940, 1.2491087936701086, 1.3565079404195710, 1.1381321711589703, 1.2065486965564740, 1.3758667599033931, 1.2363911071112015, 1.3155481812451146, 1.0499705805208230, 1.3708448243249292, 1.1516125253217191, 1.2891784444770478, 1.2899763717755894, 1.2892006709510861, 1.1424915540493061, 1.1956963527363795, 1.2118538883103003, 1.3770358794703721, 1.3026602977530786, 1.2636083943419820, 1.3092759503950615, 1.2456873517418139, 1.2594487481866161, 1.1980105996234791, 1.2039131248024177, 1.2964912267937496, 1.2882042439678361, 1.4365312874695793, 1.4105074581100534, 1.4587631540579837, 1.3673602855664699, 1.1865653873817910, 1.1879238746816791, 1.5127235969458277, 1.5062852070556714, 1.2247991342138147, 1.2096770952194200, 1.2247468281140559, 1.2946801308123754, 1.1937934152569494, 1.3357164112294753, 1.3502635554329723, 1.4008327323100891, 1.3093229493217018, 1.2669995470612871, 1.4429488011283196, 1.2413109395081190, 1.3677397479262758, 1.4107745952333222, 1.3127060218700659, 1.2077143428147523, 1.3175478615800695, 1.3233243949372147, 1.2958261976484071, 1.4703572533269786, 1.3552780164084917, 1.2575670026567065, 1.3902771858337022, 1.3790800697981465, 1.4381660957914992, 1.3595826762977199, 1.3637198442628387, 1.3124076279832988, 1.5316464719416976, 1.3535843255290452, 1.4555291609005687, 1.3607956829387871, 1.4499880890074510, 1.3931452539167828, 1.4370184826199435, 1.2362328923927126, 1.3993172377379626, 1.5290199809559784, 1.3740030073810805, 1.5298833204710511, 1.4227112462324616, 1.5306988677717874, 1.2680634870582275, 1.5247765563046309, 1.3021598607575893, 1.3657729843811808, 1.3115383920532573, 1.4765966054245334, 1.3838102727966481, 1.3913017657958928, 1.2720190668681628, 1.4138369591826847, 1.2992901391391216, 1.3855996996961375, 1.3224473587204506, 1.3160936910201655, 1.2157754317990124, 1.4233492147743145, 1.4500990263492437, 1.4423696403355100, 1.3268650718572781, 1.4440395762993909, 1.3251222689052788, 1.4801493233626650, 1.5542560651643753, 1.4341355514455079, 1.4242344664253836, 1.4576346773625635, 1.4574633292227310, 1.4955546681810021, 1.2818660222336753, 1.4622580405467085, 1.3125002126816194, 1.1993006303740992, 1.3541752312689399, 1.3231720346327460, 1.2504506237594863, 1.4050552635372660, 1.5624653749395354, 1.4748126451193442, 1.2069922558735189, 1.2893828802298277, 1.3581663369196906, 1.4820526638411098, 1.2000169472342344, 1.5034568714097480, 1.3638179580613137, 1.3229645420792393 ; ... % y18
 -0.4314161911133563, -0.1002252729767399, -0.2810352875931602, -0.3501151529897847, -0.1471205152532015, -0.3955871710051996, -0.1116173232814393, -0.1743178314609572, -0.0496211069001410, -0.0864713038299750, -0.2105720808672314, -0.2156921233227818, -0.3691061958267047, -0.2657537503881603, -0.0667403626161885, -0.0887283060223129, 0.0004490809635641, -0.0066330415465532, -0.0982236283654860, -0.2050967023563045, -0.1072752650811641, -0.0804349086742500, 0.0064684430723458, -0.0800705489181433, -0.1788433374525427, 0.0398311268686227, 0.0276546869031750, 0.0536654245767170, -0.0400237308040164, 0.0069828990527242, -0.1024827957613145, -0.0135272358814205, -0.1752777865569121, 0.1372976517545901, -0.0784261655315134, 0.1993855848013727, 0.1724634349166127, -0.1224398571874037, 0.0259939864344542, -0.0383917470358685, -0.0952316797344168, 0.1465318707338742, 0.0600411673530690, 0.2955979687203075, 0.1630157310324352, 0.3081583264334533, 0.2252785670652846, 0.2260368780931822, 0.0269113573010501, 0.2016378625787588, 0.1566649047105166, 0.1668943313301616, 0.0712139438966947, 0.1997815964285267, 0.2890707617024463, 0.3069731959679183, 0.1735324580877401, 0.1965705695560117, 0.1107423003961280, 0.2732293968578366, 0.1269491830813990, 0.2165168252770444, 0.3193054257351712, 0.3642896204571995, 0.2891430212385814, 0.2287230846404275, 0.3595198977393541, 0.3871905964507196, 0.5302013326155299, 0.5183440082944822, 0.2408142898557981, 0.5535463440645294, 0.4760919280923770, 0.4518571511933696, 0.3745115589427683, 0.4421698652072594, 0.5665384374859154, 0.5972846091674235, 0.5303249031192468, 0.6823852908016584, 0.5650516867807297, 0.5276827117061009, 0.4069626454208805, 0.6873760347776710, 0.5093678035926453, 0.4326916091092550, 0.6416331549272172, 0.5551725756905561, 0.7747647687435149, 0.6553427825839520, 0.4463501697501959, 0.7631010251943964, 0.5678568801266364, 0.6053794016788832, 0.7327048737954047, 0.6823125883770339, 0.7324117331507929, 0.8329110263587424, 0.7959763243702618, 0.5703611547660610, 0.8142435228623270, 0.7338572062745522, 0.6434391003541444, 0.7127540967896941, 0.8209222209570605, 0.8143321405862711, 0.7692968575387462, 0.9111910980023850, 0.9043270525203480, 0.7436350576246447, 0.8037280520302998, 0.8036583316595097, 0.9132909836352334, 0.7024999353079494, 1.0675727289190633, 0.9598894972005211, 0.7607752007825473, 0.9579139460812709, 0.9760960244658669, 0.9637379035507342, 1.0700562221783827, 0.9096739962160645, 1.1177800683450347, 0.9433648022236948, 0.7967554425275982, 0.8734935890398351, 0.8532965633602353, 0.8169008307712591, 0.8645627340974842, 0.8548537723435327, 1.0963994413289377, 0.9313821737317710, 1.0131010931575695, 1.0380258973282681, 1.0895865775028624, 1.2717778723980944, 1.1989464599117370, 1.0954962579786722, 1.2058959502572215, 1.2427719445990666, 1.1683275146855086, 0.9967378002343311, 1.1570254862613107, 1.2908827627589710, 1.0290242888144829, 1.1471364741021617, 1.1052664091679421, 1.2507543534179035, 1.0933912072499610, 1.0979643812587778, 1.0124048910960048, 1.1868183701537709, 1.3053475819407985, 1.0885844100287903, 1.2142513225222726, 1.1727294752260109, 1.1047008900963156, 1.0922601962641394, 1.2106999401184928, 1.3050180945766523, 1.2959727717472158, 1.2744134963511606, 1.2746667493899611, 1.4651716422507184, 1.3254984422350864, 1.4789395355652279, 1.3892153837893466, 1.2149972055585632, 1.3238315022544844, 1.1715645932824510, 1.3994354910377482, 1.4644447826609497, 1.3869511073117207, 1.2398301794749069, 1.3708573625802707, 1.4577204926548053, 1.2222629508222718, 1.3704124943822302, 1.3505770302744204, 1.4119840011770777, 1.2815901871497299, 1.3827685105864129, 1.2894698501080195, 1.3025220318207662, 1.4704585672556505, 1.2544788611197120, 1.2855159590573799, 1.4824528606051404, 1.4062083319945795, 1.2659420172344542, 1.4505700733247557, 1.4343862834050469, 1.2325014283611417, 1.3455019904259022, 1.4341136155830418, 1.6009189925059855, 1.5259226440909304, 1.4699160358328602, 1.4340979622933827, 1.4324736267004010, 1.3185018657034466, 1.6195960663599454, 1.5449453869740164, 1.2848010210723531, 1.5529947204854246, 1.5708275528883706, 1.4311449380799908, 1.5759340592181910, 1.4070578627229855, 1.5022331398949103, 1.5267423178260651, 1.4621421053082251, 1.5520710687221442, 1.4528010493381069, 1.4668087906822718, 1.3480685198096780, 1.5843271278539302, 1.6569981607069313, 1.5488898101080169, 1.4196137318755433, 1.6447920990181917, 1.4978549420313674, 1.5058091289499635, 1.5137655548652873, 1.6040253174571184, 1.4960922279792319, 1.6540896049543985, 1.6598338411207785, 1.4079775045977849, 1.6974811359010995, 1.6545660776481947, 1.3775372863481010, 1.4687876233175188, 1.3797812011841193, 1.6036211937195142 ; ... % y19
 0.3046928045915770, 0.3738035911587605, 0.2545384703126209, 0.1641428398634845, 0.0856203403136026, 0.2189548030199960, 0.2012862565623973, 0.3886262628093743, 0.2942669227012242, 0.3228106663375963, 0.2517211318001084, 0.2675895327972865, 0.3528787107192085, 0.0916104725022848, 0.4722160696015196, 0.2018426737095240, 0.1721207200708586, 0.2279097289459853, 0.1476960674069731, 0.2027552450997903, 0.2832732610115683, 0.1773354269620517, 0.4179501091274000, 0.2182377473597452, 0.1692729571709823, 0.2605620520284432, 0.3235495488601872, 0.4550499492502413, 0.2340918982020639, 0.4348397624109283, 0.3775826862487565, 0.3402281496573139, 0.2585630597364869, 0.2725477556015807, 0.3012396245958069, 0.3143986475085553, 0.2707276878897024, 0.3363135238443763, 0.2611991461875564, 0.3550497791138860, 0.5227698798803042, 0.5466849693396708, 0.2060088283458034, 0.4146751513682314, 0.3089997496672914, 0.4972909714244936, 0.6046473250039384, 0.2424403429413567, 0.5234335915848747, 0.4652814384464855, 0.5495237868589934, 0.2850677685292402, 0.5835772296022713, 0.6404656038234109, 0.6323515692697412, 0.5492404604129614, 0.4705063077220656, 0.4327617585581625, 0.5653409589789204, 0.4218300670956547, 0.3677623835769061, 0.4764205414209373, 0.6268694833254174, 0.4070898629690824, 0.4778556761100484, 0.4050371101749098, 0.6323675304566804, 0.6233183387365755, 0.6451786035625976, 0.6504075176191843, 0.6062725775892637, 0.5642274615789794, 0.5621530449813917, 0.6223784161686121, 0.7301978276269365, 0.7312354483969431, 0.7163645528435757, 0.5272434149412977, 0.5651623089798856, 0.5744541290034179, 0.7561074192352355, 0.7961529479456431, 0.6489150088961088, 0.7423401590429208, 0.7696968662775026, 0.7267774420145142, 0.7875253997879637, 0.8696269164280540, 0.7262209648695873, 0.8402904868523171, 0.8997928391918175, 0.8078158903207490, 0.8495634449575128, 0.7236989622999371, 0.7899153332748309, 0.8136900129947290, 0.8700802224119906, 1.0398238911923265, 1.0314438212198067, 0.9165234060671198, 1.0385354382837473, 0.9023423083895080, 0.9739705477865470, 1.0351648505333975, 1.0247486146598255, 1.0900034584212897, 0.8318940490086320, 0.8768604212042517, 1.1220866123054838, 0.8771794024392419, 0.9956541905836969, 1.0028577149783644, 0.8515644402301257, 1.0366558453864601, 1.0429039063440042, 0.9020339963895029, 1.0317132645720155, 1.0760705242360467, 0.9797118742936893, 1.0954202311472747, 1.0637503489040052, 1.0843772096521991, 1.2027863052505874, 1.2083448356608535, 1.1003427491529651, 1.2981277638714344, 1.1489218620349928, 1.1734036691332941, 1.1845593759201181, 1.1572332819003956, 1.1559529027707371, 1.1775287772626188, 1.3161328354431998, 1.1519787339267422, 1.2377392133518417, 1.2704596815607434, 1.3513534390030371, 1.1088477925094236, 1.3305035478752067, 1.1675953639843171, 1.2918543469773480, 1.3904642058607717, 1.2570017712164483, 1.3081356728499802, 1.3716190799425223, 1.4790079676506991, 1.3667656636850807, 1.4403944964430919, 1.3896004442876861, 1.3141482538255624, 1.3652242997868191, 1.2562812499076246, 1.3049076826429380, 1.3612573303822870, 1.4637161774533773, 1.5663145619216243, 1.3581548860484758, 1.5561043592142085, 1.4585862007267758, 1.6495073722535136, 1.5789614929224804, 1.5857538476405109, 1.4327190670638561, 1.6141151191341276, 1.4999742616300134, 1.6597949752756980, 1.5847076385479661, 1.5863791792807720, 1.4065698401674414, 1.6896755298795816, 1.3767046835842456, 1.6073608166779618, 1.7233314205066288, 1.6575430719855964, 1.3916526039964103, 1.6742326673724373, 1.5958486244275238, 1.6808854622310194, 1.6448790948530374, 1.7116275574585209, 1.6474625225111044, 1.4531871991737930, 1.7368629700586080, 1.6190638437892988, 1.6092028838251391, 1.4695966406543524, 1.5912410893265501, 1.5877031597602338, 1.5754043116320462, 1.7505214837719703, 1.5865464523107922, 1.6723746617383526, 1.5630554929108706, 1.8572023650997396, 1.6821600498147729, 1.8612245208335083, 1.8228527149215414, 1.8466051014959812, 1.7646480435662655, 1.8632163443951710, 1.6713869204953276, 1.7619421888319842, 1.8067612602495247, 1.8984030370670886, 1.8021873513134292, 1.8480793364798729, 1.9315322761322178, 1.6005851595123732, 1.6781913218848137, 1.9128806864776868, 1.7382064256748089, 1.8250132283151712, 1.7939956863860145, 1.7707502934964805, 1.8297560740989718, 1.9137863677058067, 1.8846041512271559, 1.6575675367131386, 1.7059569316110978, 1.8202610189835049, 1.8659529911757895, 1.8232963734148746, 1.9950229335422667, 1.7917408753573900, 1.8947750938645982, 1.6960163221186091, 1.9133361532152340, 2.0756378770272779, 1.7149192858955988, 1.8302437574065773, 2.0636294239217738, 1.9393265077952322, 1.7937034955126681, 1.9820851179176955, 2.0368239028356192 ; ... % y20
 3.0914362571949674, 3.2155198078265488, 3.2381064908087578, 3.4187305659569969, 3.3080488326486104, 3.1470635139696110, 3.0449303320501508, 3.3376829736981204, 3.2922766984530036, 3.0956212428865921, 3.2086691656443098, 3.1427551867516001, 2.9836655182509468, 2.9627772971924760, 2.9853505814257830, 2.9156709639324530, 3.0309264288110631, 3.2159392652819232, 3.0987333421121366, 2.8458089710571732, 2.9653746706232407, 2.9532104814798013, 2.9566438710731493, 2.9568409455783993, 2.9342835452982188, 2.9653777713976663, 2.9319817415544240, 2.8006688200553085, 3.0066115170526890, 2.8460788620134059, 2.8425970079334268, 2.7241615900387770, 2.8912560431448977, 2.9960611017811778, 2.7401474109865056, 2.8261250078006936, 2.9482947224971263, 2.6860150048124867, 2.8956422688430710, 2.8453338181703178, 2.9002755961977780, 2.9293929013009610, 2.7791061343279648, 2.9187085173016678, 2.7147577364370288, 2.7969817628751041, 2.5940825785789468, 2.6775671034861022, 2.7304758397755902, 2.6546090084529372, 2.7770986642712847, 2.6688122310365938, 2.7012729484602893, 2.5073921944250395, 2.5396995513265428, 2.7580607030273430, 2.8104078381201294, 2.6634369222703653, 2.6904304359034867, 2.7719400405600756, 2.7539413513284781, 2.5106630144501794, 2.4827175854726082, 2.5453300367086822, 2.5490517682865530, 2.4137579308271397, 2.6738752019132042, 2.4287046632685407, 2.5270153393976962, 2.6687383344926126, 2.4284792390778347, 2.3791351183168454, 2.6907577163818908, 2.4659938392139646, 2.4666988959090936, 2.5859965881843991, 2.6356023274969926, 2.5182021260639105, 2.4184345824393909, 2.4354666228980015, 2.6295342383550357, 2.4162537466592995, 2.2628475972186357, 2.4976972533217920, 2.5110253959304596, 2.3552054475948188, 2.3803151215436511, 2.4738524636611769, 2.2998821684051380, 2.3899811384554930, 2.6062336311608987, 2.4233489976972620, 2.4005147540433422, 2.4531334584621938, 2.4137032559102263, 2.2869243775327512, 2.4606808157971125, 2.5142941189978223, 2.3621362747782264, 2.4637757524556632, 2.5119896995472009, 2.3827705815171409, 2.2442198037323053, 2.1428916330844898, 2.1349215110784283, 2.3273297146996317, 2.4126636822919774, 2.3968386747601853, 2.1904491036334330, 2.2907805681987918, 2.2291423548439724, 2.4880175490779446, 2.3581470949650174, 2.3541137579310210, 2.2231809547261694, 2.3313975738932196, 2.2650909166429800, 2.0938579871781298, 2.2693630425898110, 2.2593590028557902, 2.1941222836525505, 2.2998374195554563, 2.2721341330414822, 2.2470892622145664, 2.2323628883792876, 2.3517427951186680, 2.0807883070318152, 2.0668919175862661, 2.3185389195114636, 2.1562004892123037, 2.0391418125049636, 2.2812936570831406, 2.0106699170613198, 2.0658025213671456, 2.2831864276399374, 2.0969824915856501, 2.2784520367299930, 2.2003989934859280, 2.2402737461954105, 2.3264064313587749, 1.9793480151726039, 2.0146949068396571, 2.0775107135333339, 2.1787702469578751, 2.2861183733488497, 2.3172657066569764, 2.2236932799357101, 2.0928845649439474, 2.2616893876511197, 2.2656497697548645, 2.2000586198371899, 2.1044093521113107, 2.2576341734667529, 2.2216816712793239, 2.2160095755153044, 2.2036816337155649, 2.2584287673348564, 2.0145876953609938, 2.0956636878839063, 2.2664133090859773, 2.1186907102293828, 2.3020799247265789, 2.2125587200584720, 2.2727703912549209, 1.9854023506957554, 2.1870052346695696, 2.0941433801565714, 1.9196979987795959, 2.1596254686259484, 2.1313014065413962, 2.1542129451532839, 2.1143782831287448, 2.0749415275111298, 2.0134717552915173, 2.2120219984042699, 2.0859040803973459, 2.2333138983588103, 2.2449267743556796, 2.1070485252542785, 2.2700479019321054, 2.1362162869698160, 2.0486249629506665, 2.0764385977087190, 2.0721955487100363, 2.0184337147478630, 2.1200036328444556, 2.0762673105607972, 2.0262452157772288, 2.1543747280847887, 2.0288679239581966, 2.2058218561391043, 2.0649172383224679, 1.9720191893867547, 2.0810930716472216, 2.0860858381427372, 2.1444892208147999, 2.2158269984895029, 2.1906360817622459, 2.1116687807057448, 1.9378224075961916, 1.9436742744772459, 2.1801193107760155, 1.9922510609472421, 2.0185848100581336, 1.9537059988203103, 1.9723341239176364, 2.0415055701825007, 1.9396834253376301, 1.9028043278051439, 1.9399092297290543, 2.0583891166789940, 2.0343313269881618, 2.0874004409272677, 2.0863214782683315, 1.8882721100893221, 2.0826615573836422, 1.9253415083411731, 1.9703081446906507, 1.9383731202877041, 2.0059856649840424, 2.1162881177798627, 2.1209491979823660, 2.1260939202828397, 1.8677661688721885, 1.9332798432018257, 2.0496705843382879, 2.1840359305599275, 1.8383716568294421, 2.0338835349854887, 1.9687342412637978, 2.1615635069898378, 1.8887137627360704, 2.1390898130226095, 1.8953577578815461, 1.9350126570847015 ; ... % y21
 ] ...
);
% build options
options = struct( ...
    'timeStep', 0.5000000000000000, ...
    'zonotopeOrder', 100, ...
    'reductionTechnique', 'pca', ...
    'points', 1, ...
    'p_conf', 0.9990000000000000 ...
);
% build simResult
simRes = simResult( ...
{ [ 0.306 0.337 2.037 2.096 -3.843 3.659 1.626 -2.692 -2.806 -1.161 -1.519 2.738 2.888 0.599 2.910 0.311 3.762 3.455 -3.597 2.371 1.043 -0.623 2.384 -1.276 -1.604 1.606 -0.300 0.271 3.253 -1.405 ; 0.355 0.333 2.030 2.098 -3.821 3.633 2.244 -2.675 -2.803 -1.164 -1.519 2.721 2.887 0.608 2.903 0.324 3.751 3.454 -1.712 2.349 1.050 -0.613 2.373 -1.262 -1.407 1.592 -0.290 0.273 3.241 -1.386 ; 0.403 0.342 2.024 2.101 -3.797 3.606 2.708 -2.655 -2.800 -1.168 -1.517 2.704 2.882 0.617 2.898 0.339 3.742 3.451 -0.315 2.334 1.056 -0.602 2.362 -1.247 -1.257 1.581 -0.279 0.273 3.230 -1.368 ; 0.452 0.362 2.017 2.103 -3.773 3.581 3.055 -2.634 -2.796 -1.171 -1.516 2.687 2.874 0.625 2.893 0.353 3.731 3.449 0.723 2.326 1.063 -0.592 2.349 -1.232 -1.141 1.569 -0.269 0.275 3.219 -1.349 ; 0.500 0.388 2.010 2.107 -3.750 3.556 3.313 -2.612 -2.793 -1.175 -1.515 2.670 2.864 0.634 2.887 0.367 3.721 3.447 1.492 2.322 1.069 -0.583 2.337 -1.218 -1.052 1.559 -0.258 0.275 3.208 -1.331 ; 0.548 0.420 2.004 2.109 -3.727 3.530 3.503 -2.589 -2.789 -1.178 -1.514 2.654 2.853 0.643 2.882 0.380 3.711 3.445 2.062 2.321 1.076 -0.574 2.324 -1.204 -0.983 1.548 -0.247 0.276 3.197 -1.314 ; 0.596 0.456 1.997 2.112 -3.705 3.504 3.640 -2.565 -2.785 -1.180 -1.513 2.637 2.840 0.652 2.876 0.393 3.702 3.443 2.484 2.323 1.082 -0.564 2.313 -1.189 -0.928 1.536 -0.237 0.276 3.185 -1.295 ; 0.643 0.496 1.991 2.114 -3.682 3.480 3.739 -2.540 -2.781 -1.184 -1.511 2.620 2.826 0.660 2.871 0.406 3.693 3.440 2.797 2.326 1.088 -0.555 2.301 -1.175 -0.883 1.527 -0.226 0.277 3.173 -1.277 ; 0.691 0.537 1.986 2.117 -3.659 3.455 3.808 -2.515 -2.777 -1.188 -1.510 2.603 2.813 0.668 2.865 0.419 3.683 3.438 3.029 2.329 1.095 -0.546 2.289 -1.160 -0.846 1.516 -0.216 0.278 3.161 -1.259 ; 0.739 0.581 1.980 2.119 -3.637 3.430 3.856 -2.490 -2.773 -1.190 -1.509 2.587 2.799 0.677 2.860 0.432 3.675 3.435 3.200 2.336 1.102 -0.536 2.278 -1.146 -0.815 1.507 -0.205 0.280 3.149 -1.241 ; 0.786 0.627 1.974 2.122 -3.614 3.406 3.885 -2.465 -2.768 -1.193 -1.507 2.570 2.785 0.686 2.855 0.445 3.665 3.432 3.327 2.341 1.108 -0.526 2.266 -1.133 -0.788 1.498 -0.195 0.281 3.137 -1.224 ; 0.832 0.674 1.968 2.124 -3.592 3.382 3.901 -2.440 -2.764 -1.197 -1.507 2.554 2.770 0.694 2.850 0.457 3.656 3.429 3.419 2.348 1.114 -0.517 2.255 -1.120 -0.767 1.490 -0.184 0.282 3.125 -1.206 ; 0.878 0.720 1.963 2.127 -3.569 3.358 3.906 -2.414 -2.760 -1.199 -1.506 2.537 2.756 0.702 2.844 0.471 3.646 3.426 3.487 2.354 1.121 -0.507 2.243 -1.107 -0.746 1.481 -0.175 0.283 3.113 -1.189 ; 0.925 0.767 1.958 2.130 -3.547 3.334 3.906 -2.388 -2.755 -1.202 -1.505 2.521 2.741 0.711 2.838 0.484 3.637 3.424 3.537 2.360 1.127 -0.497 2.232 -1.093 -0.729 1.473 -0.165 0.284 3.102 -1.171 ; 0.970 0.815 1.953 2.132 -3.524 3.310 3.899 -2.362 -2.750 -1.204 -1.503 2.506 2.727 0.720 2.832 0.498 3.628 3.422 3.573 2.367 1.133 -0.487 2.221 -1.080 -0.712 1.464 -0.155 0.286 3.091 -1.154 ; 1.016 0.863 1.949 2.134 -3.501 3.286 3.888 -2.338 -2.745 -1.207 -1.501 2.489 2.712 0.728 2.826 0.510 3.619 3.419 3.600 2.373 1.139 -0.478 2.210 -1.066 -0.696 1.456 -0.145 0.288 3.079 -1.138 ; 1.063 0.910 1.944 2.137 -3.479 3.263 3.877 -2.312 -2.739 -1.210 -1.500 2.472 2.699 0.736 2.822 0.523 3.610 3.415 3.623 2.381 1.145 -0.467 2.200 -1.053 -0.679 1.447 -0.136 0.290 3.068 -1.121 ; 1.112 0.957 1.939 2.140 -3.456 3.238 3.864 -2.287 -2.735 -1.212 -1.498 2.457 2.689 0.745 2.817 0.536 3.601 3.412 3.640 2.388 1.152 -0.456 2.189 -1.040 -0.659 1.438 -0.127 0.291 3.058 -1.105 ; 1.162 1.005 1.935 2.143 -3.433 3.215 3.850 -2.263 -2.728 -1.215 -1.497 2.440 2.680 0.752 2.811 0.549 3.592 3.410 3.656 2.396 1.158 -0.446 2.178 -1.028 -0.640 1.430 -0.118 0.292 3.046 -1.088 ; 1.212 1.056 1.931 2.145 -3.409 3.192 3.837 -2.239 -2.722 -1.217 -1.496 2.424 2.672 0.761 2.806 0.563 3.584 3.407 3.667 2.403 1.165 -0.436 2.168 -1.015 -0.620 1.421 -0.107 0.295 3.035 -1.072 ; 1.263 1.106 1.928 2.148 -3.386 3.168 3.824 -2.214 -2.715 -1.218 -1.495 2.408 2.665 0.768 2.801 0.576 3.576 3.405 3.678 2.411 1.170 -0.426 2.158 -1.002 -0.599 1.414 -0.097 0.298 3.025 -1.054 ; 1.316 1.157 1.924 2.151 -3.362 3.146 3.812 -2.190 -2.710 -1.219 -1.493 2.392 2.657 0.775 2.797 0.589 3.568 3.402 3.689 2.418 1.177 -0.415 2.149 -0.989 -0.577 1.406 -0.087 0.301 3.013 -1.038 ; 1.370 1.210 1.921 2.154 -3.339 3.124 3.799 -2.166 -2.704 -1.221 -1.492 2.375 2.649 0.782 2.793 0.602 3.559 3.398 3.699 2.425 1.183 -0.405 2.138 -0.976 -0.556 1.399 -0.078 0.304 3.002 -1.022 ; 1.425 1.262 1.918 2.157 -3.316 3.101 3.785 -2.143 -2.697 -1.222 -1.490 2.360 2.642 0.789 2.789 0.615 3.550 3.396 3.708 2.433 1.190 -0.394 2.128 -0.963 -0.534 1.391 -0.068 0.306 2.991 -1.005 ; 1.481 1.316 1.916 2.159 -3.292 3.078 3.771 -2.119 -2.690 -1.222 -1.490 2.346 2.636 0.797 2.785 0.629 3.543 3.393 3.715 2.441 1.196 -0.383 2.117 -0.951 -0.513 1.383 -0.058 0.309 2.979 -0.989 ; 1.537 1.372 1.914 2.162 -3.269 3.056 3.759 -2.096 -2.684 -1.224 -1.488 2.330 2.631 0.805 2.780 0.641 3.535 3.390 3.723 2.449 1.203 -0.372 2.107 -0.938 -0.492 1.376 -0.049 0.312 2.969 -0.974 ; 1.595 1.428 1.912 2.166 -3.245 3.033 3.745 -2.072 -2.677 -1.226 -1.488 2.314 2.626 0.812 2.776 0.656 3.526 3.387 3.731 2.456 1.209 -0.361 2.097 -0.926 -0.470 1.369 -0.038 0.315 2.959 -0.959 ; 1.653 1.485 1.909 2.170 -3.221 3.010 3.732 -2.049 -2.670 -1.226 -1.486 2.299 2.621 0.820 2.772 0.669 3.519 3.385 3.738 2.463 1.216 -0.350 2.087 -0.914 -0.448 1.362 -0.028 0.319 2.949 -0.943 ; 1.712 1.543 1.908 2.172 -3.197 2.989 3.718 -2.026 -2.664 -1.226 -1.484 2.283 2.615 0.827 2.768 0.683 3.511 3.382 3.746 2.470 1.222 -0.338 2.078 -0.901 -0.427 1.355 -0.018 0.323 2.938 -0.926 ; 1.772 1.602 1.905 2.176 -3.172 2.968 3.706 -2.002 -2.658 -1.227 -1.482 2.267 2.610 0.834 2.764 0.697 3.504 3.379 3.753 2.477 1.230 -0.326 2.068 -0.888 -0.405 1.349 -0.009 0.329 2.927 -0.912 ; 1.834 1.661 1.903 2.179 -3.148 2.946 3.693 -1.979 -2.650 -1.226 -1.481 2.252 2.606 0.841 2.762 0.712 3.496 3.377 3.760 2.485 1.237 -0.314 2.058 -0.877 -0.384 1.342 0.002 0.334 2.916 -0.897 ; 1.896 1.722 1.903 2.182 -3.124 2.925 3.681 -1.956 -2.642 -1.226 -1.481 2.237 2.601 0.849 2.758 0.725 3.487 3.373 3.767 2.494 1.244 -0.301 2.049 -0.866 -0.362 1.336 0.012 0.338 2.905 -0.881 ; 1.961 1.785 1.903 2.186 -3.099 2.904 3.669 -1.934 -2.635 -1.226 -1.481 2.221 2.595 0.856 2.755 0.740 3.479 3.371 3.775 2.501 1.251 -0.289 2.039 -0.854 -0.340 1.329 0.022 0.344 2.895 -0.866 ; 2.026 1.847 1.901 2.190 -3.075 2.883 3.657 -1.912 -2.628 -1.225 -1.480 2.206 2.590 0.864 2.752 0.755 3.473 3.367 3.782 2.508 1.258 -0.277 2.030 -0.842 -0.319 1.322 0.032 0.349 2.884 -0.851 ; 2.091 1.913 1.901 2.194 -3.051 2.862 3.645 -1.890 -2.620 -1.225 -1.480 2.190 2.585 0.871 2.750 0.769 3.465 3.364 3.789 2.516 1.266 -0.264 2.021 -0.831 -0.298 1.316 0.041 0.354 2.873 -0.836 ; 2.158 1.979 1.901 2.198 -3.027 2.841 3.634 -1.867 -2.613 -1.224 -1.479 2.175 2.580 0.878 2.748 0.783 3.457 3.361 3.796 2.523 1.273 -0.251 2.012 -0.819 -0.277 1.309 0.051 0.359 2.864 -0.822 ; 2.228 2.046 1.902 2.201 -3.003 2.820 3.626 -1.845 -2.604 -1.223 -1.478 2.160 2.578 0.885 2.745 0.797 3.450 3.358 3.804 2.530 1.281 -0.240 2.002 -0.808 -0.253 1.303 0.061 0.364 2.854 -0.808 ; 2.299 2.114 1.902 2.205 -2.979 2.800 3.618 -1.823 -2.596 -1.221 -1.477 2.146 2.578 0.893 2.742 0.811 3.442 3.355 3.815 2.538 1.289 -0.227 1.992 -0.797 -0.228 1.298 0.071 0.369 2.843 -0.794 ; 2.372 2.183 1.902 2.209 -2.954 2.779 3.613 -1.802 -2.588 -1.220 -1.476 2.132 2.579 0.900 2.740 0.825 3.435 3.352 3.828 2.545 1.296 -0.214 1.984 -0.785 -0.203 1.291 0.082 0.374 2.834 -0.778 ; 2.446 2.254 1.904 2.213 -2.930 2.759 3.610 -1.780 -2.581 -1.219 -1.475 2.118 2.582 0.906 2.737 0.839 3.428 3.350 3.842 2.553 1.303 -0.201 1.974 -0.773 -0.176 1.286 0.091 0.380 2.824 -0.764 ; 2.524 2.326 1.907 2.216 -2.905 2.740 3.606 -1.757 -2.572 -1.218 -1.474 2.103 2.584 0.913 2.735 0.853 3.421 3.347 3.855 2.561 1.310 -0.189 1.965 -0.762 -0.146 1.280 0.102 0.387 2.814 -0.749 ; 2.604 2.401 1.909 2.220 -2.881 2.720 3.604 -1.735 -2.563 -1.216 -1.473 2.089 2.588 0.920 2.732 0.867 3.413 3.343 3.871 2.568 1.319 -0.176 1.958 -0.751 -0.117 1.274 0.112 0.393 2.804 -0.735 ; 2.686 2.477 1.911 2.224 -2.856 2.700 3.602 -1.713 -2.554 -1.213 -1.472 2.074 2.592 0.927 2.730 0.881 3.405 3.340 3.885 2.577 1.328 -0.163 1.950 -0.739 -0.087 1.269 0.122 0.399 2.794 -0.720 ; 2.770 2.556 1.914 2.228 -2.832 2.680 3.601 -1.692 -2.545 -1.211 -1.471 2.060 2.597 0.934 2.728 0.895 3.399 3.337 3.902 2.585 1.336 -0.150 1.941 -0.728 -0.058 1.263 0.131 0.406 2.785 -0.707 ; 2.856 2.637 1.916 2.232 -2.807 2.661 3.600 -1.671 -2.537 -1.209 -1.471 2.047 2.602 0.941 2.726 0.909 3.394 3.334 3.917 2.593 1.344 -0.136 1.932 -0.717 -0.029 1.258 0.141 0.412 2.775 -0.693 ; 2.944 2.720 1.919 2.237 -2.781 2.642 3.600 -1.650 -2.527 -1.208 -1.469 2.033 2.606 0.947 2.725 0.925 3.387 3.330 3.934 2.601 1.353 -0.123 1.924 -0.706 0.001 1.253 0.151 0.418 2.766 -0.680 ; 3.034 2.806 1.923 2.242 -2.757 2.623 3.600 -1.629 -2.518 -1.206 -1.468 2.018 2.611 0.955 2.723 0.939 3.381 3.326 3.950 2.608 1.362 -0.108 1.916 -0.695 0.030 1.247 0.162 0.424 2.757 -0.666 ; 3.127 2.893 1.927 2.247 -2.733 2.605 3.600 -1.607 -2.509 -1.204 -1.467 2.004 2.617 0.961 2.723 0.954 3.375 3.322 3.966 2.617 1.371 -0.095 1.907 -0.685 0.061 1.243 0.173 0.431 2.747 -0.652 ; 3.223 2.983 1.931 2.250 -2.708 2.586 3.601 -1.586 -2.500 -1.201 -1.466 1.989 2.622 0.968 2.721 0.969 3.368 3.319 3.982 2.625 1.379 -0.080 1.900 -0.673 0.091 1.238 0.184 0.439 2.737 -0.638 ; 3.319 3.075 1.935 2.256 -2.683 2.568 3.602 -1.564 -2.491 -1.199 -1.465 1.976 2.628 0.974 2.721 0.984 3.362 3.316 3.998 2.633 1.388 -0.067 1.892 -0.663 0.120 1.234 0.194 0.444 2.728 -0.625 ; 3.418 3.169 1.940 2.261 -2.658 2.550 3.602 -1.544 -2.481 -1.197 -1.464 1.963 2.634 0.980 2.720 0.998 3.356 3.313 4.014 2.641 1.396 -0.054 1.883 -0.653 0.150 1.230 0.205 0.452 2.719 -0.611 ; 3.518 3.265 1.944 2.267 -2.634 2.532 3.604 -1.524 -2.471 -1.194 -1.464 1.950 2.639 0.988 2.719 1.013 3.350 3.310 4.030 2.650 1.404 -0.040 1.875 -0.643 0.180 1.225 0.215 0.459 2.710 -0.597 ; 3.622 3.364 1.950 2.271 -2.608 2.514 3.606 -1.503 -2.461 -1.190 -1.462 1.936 2.645 0.994 2.718 1.028 3.345 3.307 4.046 2.658 1.412 -0.026 1.868 -0.632 0.209 1.221 0.226 0.467 2.702 -0.583 ; 3.728 3.466 1.955 2.276 -2.584 2.496 3.607 -1.483 -2.450 -1.187 -1.460 1.923 2.651 1.001 2.717 1.043 3.338 3.303 4.062 2.666 1.421 -0.013 1.860 -0.622 0.238 1.217 0.237 0.474 2.693 -0.571 ; 3.836 3.570 1.961 2.281 -2.558 2.479 3.608 -1.462 -2.440 -1.183 -1.459 1.908 2.658 1.008 2.718 1.058 3.332 3.301 4.078 2.674 1.430 0.001 1.853 -0.612 0.267 1.212 0.247 0.481 2.684 -0.558 ; 3.946 3.675 1.968 2.287 -2.533 2.461 3.611 -1.442 -2.429 -1.180 -1.458 1.895 2.663 1.015 2.717 1.074 3.327 3.297 4.094 2.681 1.439 0.016 1.846 -0.602 0.297 1.208 0.257 0.487 2.674 -0.546 ; 4.059 3.782 1.975 2.293 -2.508 2.444 3.616 -1.423 -2.417 -1.177 -1.456 1.882 2.671 1.020 2.718 1.089 3.320 3.294 4.113 2.689 1.448 0.030 1.839 -0.592 0.329 1.205 0.268 0.494 2.667 -0.533 ; 4.176 3.892 1.982 2.299 -2.483 2.427 3.624 -1.402 -2.406 -1.173 -1.455 1.868 2.681 1.028 2.718 1.103 3.315 3.290 4.133 2.698 1.457 0.045 1.833 -0.583 0.362 1.202 0.279 0.501 2.657 -0.520 ; 4.295 4.005 1.990 2.305 -2.458 2.411 3.632 -1.383 -2.395 -1.170 -1.454 1.855 2.693 1.035 2.718 1.117 3.308 3.287 4.156 2.707 1.467 0.059 1.826 -0.573 0.396 1.199 0.290 0.509 2.648 -0.508 ; 4.417 4.121 1.997 2.311 -2.433 2.393 3.643 -1.363 -2.383 -1.166 -1.453 1.841 2.705 1.042 2.718 1.133 3.303 3.285 4.179 2.716 1.476 0.072 1.818 -0.564 0.432 1.196 0.300 0.516 2.638 -0.496 ; 4.543 4.240 2.006 2.316 -2.408 2.376 3.653 -1.342 -2.373 -1.162 -1.452 1.828 2.719 1.048 2.719 1.149 3.297 3.281 4.203 2.724 1.484 0.086 1.811 -0.555 0.468 1.193 0.311 0.524 2.630 -0.483 ; 4.673 4.361 2.015 2.322 -2.383 2.359 3.664 -1.322 -2.362 -1.159 -1.450 1.815 2.733 1.054 2.718 1.163 3.291 3.278 4.227 2.732 1.493 0.101 1.804 -0.546 0.505 1.190 0.322 0.532 2.623 -0.470 ; 4.805 4.487 2.024 2.329 -2.357 2.342 3.676 -1.301 -2.351 -1.155 -1.448 1.802 2.747 1.060 2.718 1.178 3.287 3.274 4.252 2.742 1.502 0.116 1.797 -0.536 0.542 1.187 0.333 0.540 2.614 -0.458 ; 4.941 4.615 2.034 2.335 -2.332 2.324 3.688 -1.281 -2.340 -1.150 -1.447 1.789 2.761 1.068 2.718 1.193 3.282 3.272 4.277 2.752 1.511 0.130 1.790 -0.527 0.579 1.184 0.343 0.548 2.605 -0.446 ; 5.079 4.746 2.044 2.340 -2.307 2.308 3.701 -1.262 -2.328 -1.145 -1.446 1.776 2.777 1.074 2.718 1.209 3.277 3.269 4.303 2.761 1.521 0.144 1.784 -0.517 0.616 1.181 0.355 0.557 2.596 -0.433 ; 5.221 4.881 2.055 2.347 -2.281 2.292 3.714 -1.242 -2.315 -1.141 -1.445 1.763 2.793 1.080 2.718 1.224 3.272 3.266 4.329 2.770 1.531 0.160 1.778 -0.508 0.655 1.178 0.365 0.565 2.587 -0.422 ; 5.367 5.019 2.066 2.353 -2.256 2.276 3.727 -1.223 -2.304 -1.136 -1.443 1.751 2.809 1.087 2.719 1.238 3.266 3.263 4.355 2.780 1.542 0.174 1.771 -0.500 0.693 1.176 0.377 0.574 2.580 -0.409 ; 5.515 5.160 2.077 2.360 -2.231 2.260 3.742 -1.202 -2.293 -1.132 -1.442 1.738 2.825 1.094 2.720 1.254 3.261 3.260 4.381 2.789 1.552 0.189 1.765 -0.491 0.730 1.173 0.388 0.583 2.573 -0.397 ; 5.667 5.305 2.089 2.367 -2.205 2.244 3.755 -1.183 -2.280 -1.128 -1.441 1.726 2.841 1.102 2.721 1.269 3.256 3.257 4.407 2.798 1.562 0.203 1.759 -0.483 0.767 1.171 0.399 0.593 2.566 -0.385 ; 5.823 5.454 2.102 2.373 -2.180 2.228 3.770 -1.163 -2.266 -1.123 -1.439 1.713 2.858 1.109 2.722 1.283 3.251 3.253 4.433 2.808 1.571 0.218 1.753 -0.475 0.804 1.169 0.410 0.602 2.558 -0.374 ; 5.981 5.606 2.115 2.380 -2.154 2.212 3.784 -1.144 -2.254 -1.118 -1.438 1.701 2.873 1.116 2.723 1.299 3.246 3.250 4.459 2.818 1.582 0.233 1.747 -0.465 0.841 1.168 0.420 0.611 2.551 -0.362 ; 6.142 5.760 2.129 2.388 -2.128 2.197 3.798 -1.124 -2.241 -1.113 -1.437 1.688 2.889 1.123 2.725 1.316 3.242 3.247 4.485 2.827 1.592 0.249 1.742 -0.457 0.879 1.166 0.431 0.620 2.543 -0.351 ; 6.307 5.918 2.144 2.394 -2.103 2.182 3.812 -1.104 -2.228 -1.107 -1.437 1.676 2.905 1.130 2.727 1.331 3.237 3.244 4.511 2.835 1.603 0.264 1.735 -0.448 0.916 1.165 0.442 0.629 2.536 -0.341 ; 6.474 6.080 2.160 2.402 -2.077 2.167 3.826 -1.085 -2.215 -1.102 -1.435 1.663 2.920 1.137 2.728 1.346 3.233 3.242 4.537 2.844 1.612 0.278 1.729 -0.439 0.954 1.164 0.453 0.639 2.528 -0.329 ; 6.645 6.246 2.175 2.409 -2.052 2.152 3.841 -1.065 -2.202 -1.097 -1.434 1.651 2.937 1.144 2.730 1.362 3.229 3.238 4.563 2.854 1.623 0.293 1.724 -0.431 0.991 1.163 0.463 0.647 2.520 -0.317 ; 6.819 6.412 2.191 2.416 -2.026 2.137 3.857 -1.046 -2.190 -1.092 -1.433 1.638 2.954 1.152 2.732 1.377 3.225 3.235 4.589 2.865 1.633 0.309 1.718 -0.422 1.030 1.163 0.474 0.655 2.513 -0.305 ; 6.994 6.584 2.208 2.424 -2.001 2.122 3.871 -1.027 -2.176 -1.086 -1.431 1.626 2.967 1.159 2.734 1.393 3.220 3.231 4.611 2.875 1.643 0.325 1.712 -0.414 1.065 1.162 0.486 0.665 2.505 -0.293 ; 7.170 6.758 2.226 2.431 -1.976 2.108 3.882 -1.007 -2.163 -1.081 -1.430 1.613 2.979 1.166 2.735 1.409 3.216 3.228 4.632 2.885 1.654 0.340 1.707 -0.405 1.097 1.161 0.497 0.673 2.498 -0.283 ; 7.349 6.934 2.243 2.438 -1.950 2.092 3.892 -0.986 -2.150 -1.075 -1.429 1.601 2.990 1.172 2.738 1.423 3.212 3.224 4.653 2.894 1.663 0.355 1.702 -0.396 1.128 1.161 0.509 0.683 2.490 -0.271 ; 7.529 7.113 2.261 2.446 -1.925 2.078 3.901 -0.966 -2.137 -1.069 -1.428 1.588 2.999 1.179 2.740 1.438 3.207 3.220 4.672 2.905 1.673 0.370 1.697 -0.388 1.159 1.161 0.519 0.693 2.484 -0.261 ; 7.711 7.294 2.280 2.455 -1.899 2.064 3.909 -0.948 -2.124 -1.063 -1.427 1.577 3.009 1.187 2.742 1.454 3.204 3.216 4.689 2.914 1.683 0.385 1.691 -0.379 1.188 1.161 0.531 0.702 2.477 -0.250 ; 7.895 7.477 2.300 2.463 -1.872 2.051 3.916 -0.928 -2.111 -1.057 -1.425 1.565 3.018 1.194 2.744 1.470 3.200 3.213 4.706 2.925 1.693 0.400 1.687 -0.370 1.217 1.161 0.541 0.712 2.470 -0.240 ; 8.081 7.664 2.321 2.471 -1.845 2.036 3.923 -0.908 -2.098 -1.051 -1.424 1.552 3.026 1.202 2.746 1.486 3.196 3.210 4.724 2.935 1.703 0.416 1.682 -0.363 1.246 1.161 0.552 0.723 2.463 -0.230 ; 8.269 7.851 2.342 2.478 -1.819 2.023 3.931 -0.889 -2.085 -1.045 -1.422 1.540 3.034 1.209 2.747 1.502 3.192 3.207 4.742 2.946 1.713 0.432 1.677 -0.355 1.275 1.160 0.563 0.733 2.457 -0.219 ; 8.459 8.042 2.365 2.486 -1.793 2.010 3.938 -0.870 -2.072 -1.039 -1.421 1.529 3.041 1.216 2.749 1.518 3.189 3.203 4.759 2.955 1.723 0.448 1.672 -0.346 1.303 1.161 0.573 0.743 2.450 -0.208 ; 8.650 8.234 2.387 2.493 -1.767 1.997 3.945 -0.851 -2.059 -1.032 -1.420 1.516 3.049 1.222 2.751 1.533 3.186 3.200 4.776 2.966 1.734 0.463 1.667 -0.339 1.331 1.161 0.583 0.754 2.443 -0.198 ; 8.844 8.429 2.412 2.501 -1.741 1.984 3.952 -0.832 -2.045 -1.025 -1.417 1.504 3.057 1.230 2.754 1.549 3.183 3.197 4.792 2.975 1.745 0.479 1.663 -0.331 1.358 1.162 0.595 0.763 2.436 -0.188 ; 9.038 8.625 2.436 2.509 -1.715 1.970 3.960 -0.812 -2.032 -1.019 -1.415 1.492 3.065 1.238 2.756 1.565 3.179 3.193 4.809 2.985 1.755 0.495 1.658 -0.323 1.386 1.163 0.605 0.773 2.429 -0.177 ; 9.235 8.823 2.460 2.517 -1.688 1.956 3.967 -0.793 -2.018 -1.012 -1.413 1.481 3.073 1.245 2.758 1.580 3.176 3.189 4.825 2.995 1.766 0.511 1.654 -0.315 1.414 1.165 0.615 0.784 2.422 -0.167 ; 9.434 9.021 2.485 2.524 -1.662 1.944 3.973 -0.774 -2.006 -1.004 -1.411 1.470 3.081 1.253 2.761 1.596 3.173 3.185 4.841 3.005 1.776 0.527 1.649 -0.308 1.441 1.165 0.626 0.794 2.416 -0.157 ; 9.634 9.223 2.510 2.533 -1.635 1.930 3.981 -0.754 -1.993 -0.997 -1.409 1.458 3.088 1.260 2.763 1.611 3.170 3.182 4.856 3.015 1.786 0.543 1.645 -0.301 1.467 1.166 0.636 0.804 2.410 -0.147 ; 9.835 9.426 2.538 2.541 -1.609 1.917 3.988 -0.736 -1.980 -0.990 -1.408 1.447 3.096 1.267 2.765 1.628 3.166 3.179 4.873 3.026 1.796 0.560 1.641 -0.293 1.493 1.167 0.647 0.814 2.402 -0.137 ; 10.037 9.631 2.565 2.549 -1.583 1.905 3.994 -0.717 -1.966 -0.983 -1.405 1.436 3.103 1.275 2.767 1.644 3.163 3.175 4.888 3.037 1.805 0.576 1.637 -0.285 1.520 1.168 0.657 0.826 2.396 -0.126 ; 10.242 9.838 2.594 2.558 -1.557 1.892 4.003 -0.698 -1.953 -0.975 -1.403 1.424 3.112 1.282 2.769 1.659 3.160 3.172 4.904 3.048 1.814 0.592 1.634 -0.277 1.548 1.170 0.668 0.837 2.390 -0.116 ; 10.448 10.047 2.623 2.567 -1.530 1.879 4.010 -0.679 -1.940 -0.967 -1.401 1.413 3.120 1.288 2.771 1.676 3.157 3.168 4.920 3.059 1.825 0.608 1.629 -0.270 1.574 1.172 0.679 0.847 2.384 -0.106 ; 10.657 10.257 2.653 2.576 -1.503 1.867 4.018 -0.661 -1.927 -0.959 -1.399 1.400 3.128 1.295 2.773 1.692 3.155 3.164 4.936 3.069 1.835 0.625 1.626 -0.262 1.602 1.173 0.688 0.857 2.377 -0.095 ; 10.864 10.469 2.683 2.583 -1.478 1.854 4.023 -0.642 -1.914 -0.952 -1.397 1.389 3.133 1.302 2.776 1.707 3.152 3.162 4.949 3.080 1.845 0.641 1.622 -0.255 1.626 1.175 0.698 0.868 2.372 -0.086 ; 11.073 10.683 2.715 2.591 -1.452 1.842 4.026 -0.623 -1.901 -0.943 -1.395 1.379 3.136 1.310 2.779 1.724 3.148 3.160 4.962 3.090 1.855 0.657 1.618 -0.248 1.648 1.176 0.708 0.879 2.365 -0.076 ; 11.282 10.897 2.747 2.600 -1.427 1.831 4.028 -0.605 -1.888 -0.936 -1.393 1.368 3.140 1.318 2.782 1.741 3.147 3.157 4.973 3.102 1.866 0.673 1.614 -0.241 1.668 1.179 0.718 0.889 2.359 -0.066 ; 11.493 11.112 2.780 2.609 -1.400 1.819 4.029 -0.586 -1.874 -0.928 -1.392 1.357 3.141 1.326 2.785 1.757 3.144 3.153 4.982 3.113 1.876 0.690 1.610 -0.233 1.688 1.180 0.729 0.899 2.353 -0.057 ; 11.704 11.329 2.813 2.618 -1.374 1.809 4.030 -0.567 -1.862 -0.920 -1.390 1.346 3.141 1.333 2.787 1.773 3.142 3.150 4.991 3.123 1.887 0.706 1.606 -0.225 1.707 1.182 0.740 0.910 2.347 -0.049 ; 11.914 11.546 2.846 2.628 -1.348 1.797 4.030 -0.548 -1.849 -0.912 -1.389 1.335 3.141 1.340 2.789 1.788 3.140 3.148 4.999 3.135 1.897 0.722 1.602 -0.217 1.725 1.185 0.750 0.921 2.342 -0.039 ; 12.125 11.765 2.882 2.636 -1.322 1.787 4.030 -0.529 -1.835 -0.905 -1.387 1.325 3.141 1.348 2.792 1.804 3.138 3.145 5.006 3.145 1.907 0.739 1.599 -0.210 1.744 1.188 0.760 0.931 2.337 -0.030 ; 12.336 11.984 2.918 2.646 -1.297 1.776 4.030 -0.512 -1.821 -0.897 -1.385 1.314 3.142 1.355 2.795 1.820 3.136 3.142 5.014 3.156 1.918 0.756 1.595 -0.203 1.761 1.190 0.769 0.942 2.332 -0.020 ; 12.549 12.203 2.955 2.656 -1.271 1.766 4.029 -0.493 -1.808 -0.890 -1.383 1.302 3.142 1.363 2.796 1.836 3.135 3.138 5.022 3.166 1.928 0.772 1.592 -0.195 1.780 1.192 0.779 0.952 2.326 -0.011 ; 12.761 12.423 2.992 2.666 -1.245 1.755 4.029 -0.476 -1.794 -0.882 -1.381 1.292 3.142 1.370 2.799 1.852 3.133 3.135 5.030 3.178 1.937 0.787 1.589 -0.189 1.797 1.195 0.789 0.963 2.321 -0.001 ; 12.974 12.644 3.030 2.676 -1.219 1.745 4.028 -0.457 -1.781 -0.874 -1.380 1.282 3.141 1.377 2.801 1.868 3.131 3.132 5.037 3.188 1.946 0.802 1.585 -0.183 1.815 1.198 0.799 0.974 2.316 0.008 ; 13.188 12.864 3.068 2.686 -1.193 1.735 4.027 -0.440 -1.767 -0.866 -1.377 1.271 3.142 1.383 2.804 1.884 3.130 3.128 5.043 3.198 1.956 0.818 1.581 -0.175 1.832 1.201 0.809 0.985 2.310 0.018 ; 13.402 13.087 3.108 2.696 -1.167 1.724 4.028 -0.421 -1.753 -0.858 -1.376 1.261 3.142 1.390 2.807 1.898 3.127 3.125 5.050 3.209 1.965 0.834 1.579 -0.168 1.848 1.203 0.820 0.995 2.305 0.026 ; 13.616 13.309 3.148 2.706 -1.142 1.713 4.029 -0.405 -1.740 -0.850 -1.374 1.251 3.142 1.398 2.810 1.914 3.125 3.122 5.057 3.219 1.975 0.849 1.575 -0.161 1.865 1.206 0.829 1.006 2.299 0.035 ; 13.831 13.532 3.189 2.717 -1.116 1.704 4.029 -0.386 -1.726 -0.842 -1.372 1.240 3.141 1.405 2.813 1.930 3.124 3.119 5.065 3.230 1.985 0.865 1.572 -0.155 1.881 1.209 0.840 1.017 2.295 0.044 ; 14.046 13.755 3.229 2.727 -1.089 1.694 4.028 -0.368 -1.713 -0.834 -1.370 1.230 3.141 1.413 2.816 1.945 3.121 3.116 5.072 3.240 1.994 0.881 1.570 -0.147 1.897 1.213 0.849 1.028 2.290 0.053 ; 14.261 13.979 3.272 2.737 -1.063 1.685 4.028 -0.351 -1.700 -0.826 -1.368 1.219 3.141 1.420 2.817 1.959 3.119 3.113 5.079 3.250 2.004 0.897 1.568 -0.141 1.913 1.216 0.858 1.038 2.286 0.061 ; 14.475 14.202 3.314 2.746 -1.037 1.674 4.027 -0.333 -1.686 -0.818 -1.365 1.209 3.140 1.426 2.821 1.974 3.118 3.110 5.087 3.260 2.013 0.913 1.565 -0.135 1.930 1.218 0.868 1.050 2.282 0.071 ; 14.691 14.426 3.357 2.757 -1.012 1.664 4.028 -0.316 -1.672 -0.811 -1.364 1.199 3.139 1.432 2.823 1.990 3.116 3.106 5.094 3.270 2.024 0.929 1.562 -0.128 1.946 1.221 0.878 1.060 2.277 0.079 ; 14.907 14.651 3.402 2.767 -0.987 1.655 4.027 -0.299 -1.657 -0.803 -1.361 1.188 3.139 1.440 2.825 2.005 3.114 3.104 5.099 3.281 2.034 0.945 1.560 -0.121 1.962 1.224 0.887 1.071 2.272 0.088 ; 15.122 14.876 3.447 2.778 -0.962 1.645 4.025 -0.282 -1.645 -0.795 -1.359 1.178 3.136 1.446 2.827 2.019 3.113 3.100 5.103 3.292 2.044 0.960 1.558 -0.114 1.977 1.227 0.897 1.083 2.267 0.097 ; 15.336 15.101 3.492 2.789 -0.936 1.637 4.021 -0.265 -1.630 -0.787 -1.357 1.168 3.132 1.454 2.830 2.034 3.112 3.097 5.104 3.302 2.055 0.976 1.557 -0.108 1.989 1.229 0.907 1.094 2.262 0.105 ; 15.550 15.325 3.538 2.800 -0.911 1.627 4.016 -0.247 -1.617 -0.779 -1.355 1.157 3.127 1.460 2.833 2.048 3.110 3.095 5.106 3.314 2.065 0.992 1.554 -0.102 2.000 1.232 0.915 1.105 2.258 0.114 ; 15.763 15.550 3.586 2.811 -0.885 1.617 4.010 -0.231 -1.604 -0.771 -1.352 1.146 3.120 1.466 2.837 2.062 3.109 3.092 5.106 3.325 2.075 1.008 1.553 -0.095 2.008 1.235 0.924 1.116 2.254 0.123 ; 15.976 15.773 3.633 2.821 -0.861 1.608 4.003 -0.214 -1.590 -0.763 -1.349 1.137 3.112 1.472 2.840 2.077 3.109 3.088 5.106 3.336 2.084 1.023 1.551 -0.088 2.017 1.238 0.934 1.126 2.250 0.132 ; 16.187 15.997 3.681 2.832 -0.836 1.599 3.995 -0.197 -1.577 -0.755 -1.347 1.127 3.103 1.479 2.844 2.092 3.108 3.086 5.104 3.347 2.093 1.037 1.548 -0.081 2.024 1.242 0.943 1.136 2.245 0.141 ; 16.397 16.220 3.731 2.843 -0.810 1.590 3.986 -0.181 -1.563 -0.747 -1.345 1.117 3.095 1.485 2.847 2.107 3.106 3.083 5.102 3.358 2.103 1.053 1.546 -0.075 2.032 1.245 0.952 1.146 2.240 0.150 ; 16.606 16.442 3.782 2.855 -0.785 1.582 3.978 -0.164 -1.549 -0.738 -1.343 1.107 3.087 1.492 2.849 2.121 3.106 3.080 5.100 3.368 2.113 1.069 1.545 -0.068 2.040 1.248 0.961 1.157 2.236 0.158 ; 16.816 16.664 3.832 2.867 -0.761 1.573 3.969 -0.147 -1.535 -0.731 -1.340 1.097 3.078 1.498 2.852 2.133 3.105 3.077 5.098 3.378 2.123 1.084 1.543 -0.061 2.047 1.251 0.972 1.167 2.231 0.166 ; 17.024 16.884 3.883 2.878 -0.736 1.564 3.960 -0.131 -1.522 -0.724 -1.338 1.086 3.069 1.504 2.856 2.148 3.104 3.074 5.096 3.389 2.133 1.099 1.541 -0.054 2.054 1.255 0.982 1.177 2.227 0.175 ; 17.230 17.105 3.936 2.892 -0.711 1.556 3.952 -0.114 -1.509 -0.717 -1.336 1.076 3.059 1.511 2.859 2.161 3.103 3.070 5.092 3.399 2.142 1.113 1.539 -0.047 2.061 1.258 0.990 1.187 2.223 0.183 ; 17.437 17.324 3.989 2.904 -0.687 1.547 3.944 -0.098 -1.495 -0.709 -1.334 1.066 3.049 1.517 2.861 2.174 3.103 3.068 5.091 3.408 2.153 1.128 1.538 -0.042 2.067 1.260 0.999 1.198 2.219 0.191 ; 17.641 17.543 4.042 2.916 -0.663 1.539 3.936 -0.081 -1.481 -0.702 -1.332 1.057 3.040 1.523 2.865 2.187 3.101 3.065 5.088 3.418 2.163 1.142 1.535 -0.034 2.073 1.264 1.008 1.207 2.215 0.199 ; 17.847 17.760 4.097 2.929 -0.638 1.531 3.927 -0.064 -1.467 -0.696 -1.329 1.048 3.032 1.530 2.868 2.200 3.101 3.062 5.085 3.429 2.173 1.156 1.534 -0.028 2.080 1.267 1.016 1.217 2.211 0.207 ; 18.051 17.977 4.152 2.943 -0.614 1.523 3.918 -0.048 -1.453 -0.689 -1.326 1.038 3.023 1.536 2.870 2.213 3.099 3.059 5.083 3.439 2.182 1.171 1.533 -0.022 2.087 1.270 1.026 1.226 2.207 0.215 ; 18.254 18.193 4.207 2.956 -0.591 1.516 3.909 -0.031 -1.440 -0.682 -1.324 1.029 3.015 1.542 2.873 2.227 3.100 3.057 5.081 3.448 2.192 1.185 1.531 -0.015 2.094 1.274 1.035 1.237 2.204 0.223 ; 18.455 18.408 4.263 2.970 -0.567 1.509 3.900 -0.016 -1.426 -0.676 -1.321 1.020 3.006 1.548 2.877 2.240 3.099 3.053 5.079 3.459 2.202 1.198 1.530 -0.009 2.100 1.278 1.045 1.245 2.199 0.231 ; 18.656 18.622 4.320 2.983 -0.543 1.501 3.892 -0.000 -1.411 -0.668 -1.318 1.011 2.997 1.553 2.880 2.252 3.099 3.050 5.075 3.468 2.211 1.213 1.529 -0.003 2.107 1.281 1.054 1.255 2.195 0.239 ; 18.856 18.835 4.377 2.997 -0.519 1.493 3.883 0.015 -1.397 -0.661 -1.315 1.002 2.989 1.559 2.883 2.264 3.099 3.047 5.073 3.479 2.220 1.227 1.528 0.003 2.113 1.284 1.063 1.264 2.191 0.247 ; 19.055 19.048 4.435 3.010 -0.496 1.486 3.876 0.031 -1.383 -0.654 -1.313 0.993 2.981 1.564 2.886 2.276 3.098 3.044 5.069 3.489 2.230 1.240 1.526 0.009 2.119 1.288 1.073 1.274 2.187 0.255 ; 19.254 19.260 4.493 3.023 -0.472 1.478 3.866 0.047 -1.370 -0.647 -1.310 0.984 2.970 1.571 2.890 2.289 3.097 3.042 5.064 3.498 2.239 1.254 1.525 0.016 2.121 1.292 1.081 1.283 2.183 0.263 ; 19.449 19.469 4.552 3.038 -0.449 1.470 3.854 0.061 -1.356 -0.641 -1.308 0.974 2.958 1.575 2.893 2.301 3.097 3.038 5.058 3.508 2.250 1.267 1.524 0.022 2.122 1.294 1.091 1.292 2.179 0.270 ; 19.642 19.678 4.613 3.052 -0.425 1.463 3.839 0.076 -1.342 -0.633 -1.305 0.966 2.943 1.581 2.896 2.312 3.097 3.035 5.049 3.517 2.260 1.281 1.523 0.029 2.123 1.297 1.099 1.300 2.176 0.277 ; 19.834 19.886 4.672 3.065 -0.402 1.457 3.824 0.091 -1.329 -0.627 -1.303 0.957 2.928 1.586 2.900 2.324 3.097 3.032 5.038 3.526 2.269 1.294 1.522 0.034 2.122 1.300 1.108 1.309 2.173 0.285 ; 20.023 20.093 4.732 3.079 -0.379 1.450 3.810 0.106 -1.315 -0.621 -1.300 0.948 2.913 1.591 2.901 2.336 3.097 3.030 5.027 3.536 2.278 1.308 1.522 0.040 2.120 1.303 1.116 1.318 2.170 0.292 ; 20.210 20.297 4.794 3.094 -0.355 1.443 3.794 0.121 -1.302 -0.614 -1.297 0.939 2.897 1.595 2.904 2.348 3.097 3.027 5.016 3.545 2.287 1.321 1.521 0.046 2.118 1.307 1.124 1.327 2.166 0.300 ; 20.394 20.499 4.856 3.109 -0.332 1.436 3.778 0.136 -1.288 -0.609 -1.294 0.931 2.880 1.601 2.906 2.358 3.098 3.023 5.005 3.554 2.296 1.334 1.521 0.051 2.116 1.310 1.132 1.336 2.162 0.308 ; 20.578 20.698 4.920 3.123 -0.310 1.428 3.761 0.150 -1.275 -0.601 -1.292 0.922 2.863 1.605 2.908 2.370 3.097 3.020 4.993 3.564 2.305 1.346 1.520 0.057 2.113 1.314 1.140 1.345 2.160 0.315 ; 20.759 20.896 4.982 3.138 -0.287 1.422 3.744 0.164 -1.262 -0.595 -1.290 0.913 2.847 1.611 2.911 2.382 3.097 3.017 4.980 3.574 2.315 1.360 1.519 0.063 2.110 1.318 1.148 1.353 2.157 0.323 ; 20.940 21.092 5.046 3.152 -0.264 1.414 3.727 0.178 -1.249 -0.589 -1.288 0.904 2.829 1.615 2.914 2.392 3.097 3.013 4.969 3.582 2.323 1.373 1.518 0.069 2.106 1.322 1.156 1.362 2.154 0.330 ; 21.118 21.286 5.110 3.167 -0.241 1.408 3.709 0.192 -1.237 -0.582 -1.285 0.895 2.811 1.620 2.916 2.404 3.097 3.010 4.957 3.591 2.332 1.386 1.518 0.075 2.102 1.324 1.165 1.371 2.151 0.336 ; 21.293 21.479 5.175 3.183 -0.219 1.402 3.692 0.206 -1.224 -0.577 -1.283 0.887 2.794 1.624 2.919 2.414 3.098 3.008 4.945 3.600 2.340 1.398 1.519 0.081 2.098 1.327 1.174 1.379 2.147 0.343 ; 21.467 21.669 5.240 3.199 -0.197 1.396 3.675 0.219 -1.211 -0.570 -1.280 0.877 2.778 1.629 2.920 2.425 3.099 3.006 4.933 3.609 2.349 1.411 1.517 0.086 2.095 1.329 1.181 1.386 2.143 0.350 ; 21.638 21.858 5.305 3.214 -0.174 1.389 3.658 0.233 -1.198 -0.565 -1.278 0.869 2.760 1.634 2.923 2.436 3.100 3.003 4.921 3.618 2.358 1.423 1.516 0.092 2.091 1.333 1.190 1.394 2.139 0.358 ; 21.807 22.044 5.371 3.230 -0.153 1.382 3.640 0.247 -1.185 -0.559 -1.275 0.861 2.742 1.638 2.925 2.446 3.100 3.000 4.908 3.627 2.366 1.435 1.517 0.096 2.087 1.336 1.198 1.402 2.136 0.364 ; 21.975 22.228 5.437 3.246 -0.132 1.376 3.624 0.260 -1.173 -0.553 -1.273 0.853 2.725 1.644 2.927 2.456 3.101 2.998 4.895 3.635 2.374 1.447 1.516 0.103 2.082 1.339 1.206 1.411 2.133 0.371 ; 22.141 22.409 5.505 3.261 -0.110 1.369 3.606 0.273 -1.161 -0.547 -1.271 0.845 2.708 1.648 2.929 2.466 3.101 2.995 4.883 3.644 2.382 1.459 1.516 0.108 2.078 1.342 1.214 1.418 2.130 0.377 ; 22.304 22.589 5.572 3.277 -0.088 1.364 3.589 0.287 -1.149 -0.540 -1.268 0.836 2.691 1.652 2.931 2.476 3.102 2.992 4.870 3.653 2.391 1.472 1.516 0.113 2.074 1.344 1.220 1.425 2.127 0.385 ; 22.467 22.767 5.639 3.293 -0.067 1.358 3.571 0.301 -1.137 -0.535 -1.266 0.827 2.674 1.655 2.933 2.485 3.102 2.990 4.858 3.662 2.399 1.483 1.516 0.120 2.069 1.347 1.227 1.432 2.124 0.392 ; 22.627 22.943 5.707 3.309 -0.045 1.352 3.555 0.315 -1.124 -0.528 -1.262 0.818 2.657 1.659 2.934 2.495 3.103 2.986 4.847 3.670 2.407 1.495 1.516 0.125 2.066 1.350 1.235 1.441 2.121 0.400 ; 22.781 23.117 5.776 3.325 -0.025 1.346 3.533 0.328 -1.113 -0.522 -1.259 0.810 2.634 1.663 2.936 2.505 3.104 2.984 4.829 3.679 2.414 1.508 1.516 0.130 2.056 1.353 1.242 1.448 2.119 0.407 ; 22.932 23.289 5.844 3.341 -0.002 1.341 3.507 0.341 -1.101 -0.517 -1.257 0.802 2.609 1.668 2.937 2.514 3.105 2.982 4.809 3.687 2.423 1.518 1.515 0.136 2.043 1.356 1.248 1.455 2.117 0.413 ; 23.079 23.457 5.915 3.358 0.020 1.335 3.478 0.353 -1.088 -0.511 -1.254 0.794 2.580 1.672 2.938 2.525 3.106 2.979 4.785 3.695 2.432 1.531 1.515 0.142 2.027 1.359 1.254 1.463 2.114 0.420 ; 23.222 23.621 5.986 3.375 0.040 1.329 3.447 0.366 -1.076 -0.505 -1.251 0.786 2.551 1.675 2.940 2.535 3.107 2.975 4.760 3.702 2.440 1.542 1.515 0.148 2.010 1.361 1.262 1.470 2.110 0.427 ; 23.359 23.782 6.056 3.390 0.062 1.324 3.416 0.377 -1.065 -0.498 -1.247 0.777 2.519 1.680 2.940 2.544 3.108 2.973 4.733 3.709 2.447 1.554 1.514 0.154 1.990 1.363 1.269 1.476 2.108 0.433 ; 23.494 23.939 6.127 3.407 0.084 1.320 3.382 0.390 -1.054 -0.492 -1.244 0.769 2.487 1.683 2.942 2.554 3.109 2.971 4.704 3.718 2.456 1.566 1.515 0.159 1.969 1.366 1.275 1.484 2.105 0.440 ; 23.623 24.091 6.199 3.424 0.106 1.315 3.348 0.402 -1.042 -0.486 -1.241 0.762 2.454 1.685 2.942 2.564 3.110 2.968 4.675 3.725 2.463 1.578 1.515 0.165 1.949 1.369 1.282 1.491 2.103 0.446 ; 23.750 24.241 6.271 3.441 0.128 1.310 3.314 0.414 -1.030 -0.480 -1.238 0.754 2.421 1.689 2.943 2.573 3.112 2.966 4.645 3.732 2.471 1.590 1.516 0.170 1.927 1.371 1.288 1.498 2.100 0.452 ; 23.872 24.386 6.342 3.459 0.150 1.306 3.278 0.426 -1.018 -0.474 -1.236 0.746 2.387 1.692 2.942 2.583 3.113 2.962 4.613 3.740 2.478 1.602 1.515 0.175 1.904 1.374 1.294 1.505 2.098 0.458 ; 23.988 24.527 6.415 3.477 0.171 1.302 3.243 0.437 -1.007 -0.468 -1.232 0.739 2.353 1.695 2.944 2.593 3.115 2.959 4.583 3.748 2.486 1.613 1.515 0.180 1.881 1.376 1.301 1.513 2.096 0.465 ; 24.101 24.663 6.488 3.494 0.192 1.297 3.209 0.449 -0.995 -0.462 -1.230 0.730 2.318 1.697 2.943 2.603 3.116 2.957 4.553 3.755 2.492 1.625 1.515 0.186 1.858 1.378 1.307 1.520 2.093 0.470 ; 24.210 24.794 6.561 3.512 0.214 1.292 3.174 0.459 -0.983 -0.456 -1.227 0.722 2.284 1.699 2.944 2.612 3.117 2.956 4.522 3.762 2.499 1.637 1.516 0.191 1.835 1.380 1.313 1.527 2.092 0.476 ; 24.314 24.923 6.634 3.529 0.236 1.288 3.139 0.469 -0.971 -0.450 -1.224 0.714 2.249 1.702 2.945 2.622 3.119 2.954 4.491 3.769 2.507 1.648 1.516 0.196 1.811 1.382 1.319 1.534 2.090 0.482 ; 24.414 25.046 6.707 3.547 0.258 1.283 3.102 0.480 -0.960 -0.443 -1.222 0.706 2.214 1.704 2.946 2.631 3.120 2.951 4.460 3.775 2.513 1.660 1.516 0.202 1.787 1.385 1.324 1.541 2.088 0.488 ; 24.510 25.166 6.780 3.564 0.280 1.278 3.066 0.491 -0.949 -0.437 -1.218 0.699 2.179 1.707 2.946 2.641 3.121 2.948 4.429 3.782 2.520 1.670 1.516 0.207 1.763 1.385 1.328 1.548 2.087 0.494 ; 24.601 25.280 6.853 3.583 0.301 1.273 3.030 0.502 -0.938 -0.432 -1.215 0.691 2.143 1.709 2.945 2.651 3.123 2.947 4.397 3.788 2.526 1.681 1.517 0.211 1.740 1.386 1.334 1.555 2.084 0.502 ; 24.688 25.390 6.927 3.601 0.322 1.269 2.994 0.512 -0.926 -0.425 -1.212 0.683 2.109 1.712 2.945 2.660 3.124 2.945 4.366 3.794 2.532 1.693 1.518 0.216 1.716 1.387 1.340 1.563 2.083 0.508 ; 24.772 25.495 7.000 3.620 0.343 1.264 2.957 0.522 -0.915 -0.419 -1.210 0.676 2.073 1.714 2.944 2.668 3.124 2.942 4.335 3.800 2.538 1.703 1.520 0.222 1.691 1.388 1.344 1.570 2.081 0.514 ; 24.852 25.596 7.074 3.638 0.365 1.261 2.922 0.530 -0.904 -0.413 -1.208 0.669 2.039 1.715 2.944 2.678 3.125 2.941 4.304 3.806 2.546 1.716 1.521 0.228 1.668 1.389 1.349 1.577 2.079 0.520 ; 24.927 25.694 7.148 3.657 0.387 1.256 2.887 0.540 -0.894 -0.406 -1.205 0.663 2.005 1.717 2.944 2.686 3.126 2.938 4.273 3.812 2.551 1.728 1.521 0.233 1.644 1.390 1.354 1.584 2.077 0.526 ; 24.999 25.786 7.223 3.675 0.409 1.252 2.851 0.549 -0.883 -0.399 -1.202 0.656 1.970 1.717 2.944 2.696 3.127 2.935 4.241 3.818 2.557 1.739 1.522 0.239 1.619 1.391 1.358 1.592 2.075 0.533 ; 25.066 25.874 7.297 3.695 0.430 1.248 2.816 0.559 -0.873 -0.393 -1.199 0.647 1.936 1.718 2.944 2.704 3.128 2.932 4.210 3.824 2.562 1.750 1.523 0.243 1.596 1.392 1.364 1.600 2.074 0.539 ; 25.129 25.958 7.371 3.715 0.451 1.244 2.779 0.569 -0.862 -0.386 -1.196 0.639 1.901 1.719 2.944 2.713 3.129 2.930 4.179 3.829 2.567 1.761 1.523 0.248 1.572 1.393 1.368 1.606 2.073 0.545 ; 25.189 26.038 7.445 3.733 0.473 1.241 2.744 0.577 -0.852 -0.380 -1.193 0.631 1.867 1.720 2.943 2.722 3.130 2.928 4.147 3.834 2.574 1.772 1.524 0.253 1.548 1.394 1.373 1.613 2.070 0.552 ; 25.243 26.113 7.518 3.752 0.494 1.238 2.709 0.585 -0.840 -0.375 -1.191 0.623 1.833 1.721 2.942 2.730 3.131 2.926 4.115 3.839 2.580 1.784 1.525 0.259 1.525 1.395 1.378 1.621 2.068 0.558 ; 25.294 26.185 7.592 3.772 0.515 1.234 2.673 0.593 -0.831 -0.369 -1.187 0.616 1.797 1.721 2.941 2.739 3.133 2.924 4.084 3.844 2.586 1.794 1.527 0.264 1.500 1.395 1.383 1.627 2.067 0.564 ; 25.341 26.251 7.666 3.791 0.536 1.230 2.637 0.602 -0.820 -0.363 -1.183 0.609 1.762 1.722 2.941 2.746 3.135 2.923 4.052 3.848 2.592 1.804 1.529 0.269 1.476 1.395 1.389 1.634 2.065 0.570 ; 25.385 26.314 7.740 3.812 0.558 1.227 2.601 0.611 -0.810 -0.357 -1.179 0.602 1.727 1.722 2.941 2.754 3.137 2.920 4.022 3.853 2.598 1.815 1.530 0.274 1.451 1.394 1.393 1.641 2.063 0.576 ; 25.425 26.373 7.814 3.832 0.579 1.224 2.566 0.620 -0.799 -0.351 -1.176 0.594 1.693 1.721 2.940 2.763 3.139 2.918 3.991 3.857 2.604 1.825 1.531 0.278 1.427 1.395 1.398 1.648 2.062 0.582 ; 25.462 26.428 7.889 3.852 0.600 1.221 2.530 0.627 -0.789 -0.346 -1.174 0.587 1.658 1.721 2.939 2.772 3.140 2.916 3.960 3.862 2.609 1.836 1.532 0.282 1.403 1.395 1.403 1.654 2.061 0.589 ; 25.494 26.479 7.965 3.872 0.622 1.218 2.496 0.635 -0.780 -0.340 -1.171 0.581 1.623 1.721 2.939 2.781 3.142 2.914 3.929 3.866 2.615 1.847 1.533 0.287 1.378 1.394 1.407 1.661 2.059 0.594 ; 25.523 26.526 8.039 3.892 0.643 1.215 2.462 0.643 -0.771 -0.333 -1.167 0.575 1.588 1.721 2.938 2.788 3.144 2.912 3.899 3.870 2.619 1.857 1.534 0.292 1.355 1.394 1.411 1.667 2.056 0.601 ; 25.547 26.568 8.113 3.913 0.665 1.212 2.427 0.650 -0.761 -0.328 -1.164 0.568 1.554 1.720 2.937 2.796 3.146 2.908 3.867 3.874 2.624 1.868 1.536 0.297 1.331 1.394 1.415 1.672 2.055 0.606 ; 25.566 26.607 8.187 3.933 0.686 1.210 2.392 0.657 -0.752 -0.322 -1.160 0.562 1.521 1.719 2.936 2.804 3.148 2.905 3.836 3.877 2.629 1.877 1.537 0.302 1.306 1.393 1.419 1.679 2.054 0.612 ; 25.584 26.641 8.261 3.954 0.707 1.207 2.359 0.663 -0.744 -0.317 -1.156 0.555 1.487 1.717 2.934 2.813 3.149 2.903 3.804 3.881 2.634 1.888 1.539 0.307 1.281 1.393 1.424 1.685 2.053 0.618 ; 25.596 26.672 8.335 3.975 0.728 1.204 2.325 0.670 -0.734 -0.312 -1.153 0.549 1.453 1.717 2.932 2.820 3.151 2.900 3.772 3.885 2.638 1.897 1.540 0.311 1.257 1.394 1.426 1.691 2.051 0.624 ; 25.605 26.698 8.409 3.995 0.749 1.202 2.291 0.676 -0.724 -0.307 -1.149 0.542 1.419 1.716 2.931 2.827 3.154 2.898 3.741 3.887 2.642 1.907 1.542 0.317 1.233 1.393 1.430 1.697 2.049 0.630 ; 25.610 26.721 8.481 4.017 0.769 1.200 2.256 0.683 -0.716 -0.302 -1.145 0.534 1.386 1.714 2.929 2.835 3.156 2.896 3.709 3.891 2.646 1.917 1.543 0.322 1.208 1.392 1.433 1.702 2.048 0.635 ; 25.613 26.740 8.554 4.038 0.789 1.197 2.222 0.689 -0.707 -0.297 -1.142 0.528 1.352 1.712 2.927 2.842 3.157 2.895 3.679 3.894 2.650 1.927 1.544 0.327 1.183 1.391 1.437 1.707 2.047 0.640 ; 25.610 26.754 8.626 4.059 0.809 1.195 2.188 0.696 -0.698 -0.292 -1.138 0.521 1.318 1.710 2.926 2.849 3.159 2.892 3.648 3.897 2.655 1.936 1.546 0.333 1.159 1.391 1.440 1.712 2.045 0.647 ; 25.607 26.764 8.699 4.081 0.829 1.192 2.162 0.701 -0.690 -0.287 -1.134 0.515 1.292 1.708 2.925 2.857 3.161 2.889 3.624 3.899 2.659 1.945 1.548 0.337 1.143 1.390 1.443 1.717 2.044 0.651 ; 25.605 26.771 8.772 4.103 0.849 1.190 2.141 0.707 -0.680 -0.282 -1.130 0.508 1.270 1.706 2.923 2.863 3.163 2.886 3.606 3.902 2.664 1.955 1.550 0.343 1.130 1.388 1.446 1.722 2.043 0.657 ; 25.603 26.776 8.844 4.126 0.869 1.187 2.125 0.712 -0.671 -0.277 -1.127 0.502 1.253 1.704 2.921 2.870 3.165 2.884 3.592 3.905 2.668 1.963 1.552 0.348 1.123 1.387 1.448 1.728 2.041 0.664 ; 25.602 26.779 8.916 4.148 0.890 1.184 2.112 0.717 -0.663 -0.272 -1.123 0.495 1.239 1.702 2.918 2.878 3.166 2.882 3.581 3.908 2.673 1.973 1.554 0.352 1.120 1.385 1.452 1.735 2.040 0.669 ; 25.599 26.782 8.988 4.170 0.910 1.182 2.102 0.723 -0.654 -0.268 -1.121 0.490 1.228 1.701 2.917 2.884 3.167 2.880 3.571 3.910 2.677 1.982 1.555 0.358 1.118 1.384 1.455 1.741 2.039 0.675 ; 25.597 26.784 9.058 4.192 0.931 1.180 2.093 0.729 -0.644 -0.264 -1.118 0.484 1.218 1.699 2.915 2.891 3.169 2.878 3.565 3.912 2.681 1.991 1.556 0.364 1.119 1.384 1.457 1.745 2.039 0.681 ; 25.594 26.784 9.130 4.215 0.951 1.178 2.087 0.735 -0.636 -0.259 -1.114 0.477 1.209 1.697 2.913 2.898 3.172 2.875 3.559 3.914 2.685 2.000 1.557 0.368 1.121 1.383 1.460 1.751 2.037 0.687 ; 25.592 26.782 9.200 4.238 0.972 1.176 2.081 0.741 -0.628 -0.253 -1.110 0.471 1.201 1.695 2.912 2.904 3.174 2.874 3.554 3.918 2.690 2.009 1.559 0.372 1.123 1.382 1.463 1.757 2.035 0.693 ; 25.590 26.782 9.270 4.261 0.993 1.175 2.075 0.746 -0.619 -0.248 -1.108 0.464 1.193 1.693 2.910 2.910 3.176 2.873 3.550 3.920 2.695 2.019 1.561 0.377 1.126 1.381 1.465 1.762 2.035 0.698 ; 25.588 26.782 9.339 4.284 1.013 1.174 2.070 0.752 -0.610 -0.243 -1.105 0.457 1.186 1.692 2.909 2.917 3.178 2.870 3.546 3.922 2.699 2.029 1.562 0.381 1.129 1.380 1.469 1.767 2.034 0.704 ; 25.586 26.779 9.409 4.308 1.034 1.173 2.067 0.757 -0.602 -0.238 -1.102 0.451 1.179 1.690 2.906 2.924 3.181 2.869 3.543 3.924 2.703 2.038 1.564 0.386 1.132 1.380 1.472 1.772 2.033 0.709 ; 25.584 26.778 9.479 4.331 1.055 1.171 2.064 0.762 -0.593 -0.233 -1.099 0.445 1.172 1.689 2.904 2.930 3.183 2.866 3.540 3.926 2.708 2.047 1.565 0.391 1.136 1.379 1.476 1.778 2.033 0.714 ; 25.582 26.777 9.548 4.355 1.076 1.169 2.060 0.767 -0.584 -0.228 -1.094 0.438 1.166 1.687 2.904 2.936 3.186 2.865 3.537 3.928 2.712 2.057 1.566 0.396 1.140 1.378 1.478 1.784 2.032 0.718 ; 25.580 26.775 9.618 4.379 1.096 1.168 2.058 0.773 -0.575 -0.223 -1.091 0.431 1.160 1.685 2.902 2.942 3.188 2.863 3.535 3.931 2.716 2.067 1.568 0.401 1.144 1.376 1.482 1.790 2.031 0.723 ; 25.578 26.774 9.687 4.403 1.117 1.167 2.056 0.778 -0.566 -0.217 -1.088 0.425 1.153 1.683 2.900 2.949 3.191 2.861 3.534 3.933 2.721 2.077 1.571 0.406 1.148 1.375 1.485 1.796 2.031 0.729 ; 25.576 26.770 9.755 4.428 1.138 1.165 2.054 0.784 -0.558 -0.212 -1.085 0.418 1.147 1.681 2.899 2.956 3.192 2.859 3.532 3.935 2.724 2.085 1.573 0.409 1.152 1.374 1.488 1.801 2.029 0.734 ; 25.573 26.769 9.823 4.453 1.159 1.165 2.052 0.789 -0.549 -0.207 -1.081 0.413 1.140 1.678 2.897 2.963 3.195 2.857 3.530 3.937 2.727 2.094 1.575 0.414 1.155 1.374 1.490 1.805 2.028 0.739 ; 25.570 26.766 9.891 4.478 1.179 1.163 2.051 0.793 -0.541 -0.201 -1.078 0.408 1.135 1.676 2.894 2.969 3.197 2.856 3.528 3.940 2.732 2.104 1.578 0.418 1.160 1.373 1.493 1.811 2.028 0.744 ; 25.569 26.764 9.959 4.503 1.201 1.163 2.049 0.798 -0.532 -0.195 -1.074 0.402 1.130 1.673 2.892 2.975 3.198 2.854 3.526 3.943 2.736 2.114 1.579 0.422 1.165 1.372 1.496 1.817 2.027 0.749 ; 25.566 26.762 10.026 4.528 1.221 1.163 2.048 0.803 -0.523 -0.190 -1.071 0.396 1.124 1.671 2.891 2.981 3.201 2.852 3.525 3.945 2.741 2.122 1.582 0.427 1.169 1.372 1.498 1.822 2.027 0.754 ; 25.562 26.760 10.093 4.554 1.242 1.162 2.045 0.807 -0.515 -0.185 -1.068 0.390 1.115 1.669 2.890 2.986 3.203 2.850 3.519 3.947 2.745 2.132 1.584 0.432 1.170 1.371 1.500 1.826 2.026 0.759 ; 25.557 26.757 10.160 4.580 1.263 1.160 2.039 0.812 -0.506 -0.179 -1.065 0.383 1.106 1.667 2.888 2.993 3.205 2.849 3.513 3.949 2.750 2.142 1.587 0.437 1.169 1.371 1.502 1.832 2.025 0.763 ; 25.552 26.753 10.227 4.605 1.283 1.159 2.032 0.817 -0.497 -0.174 -1.061 0.377 1.094 1.665 2.886 2.999 3.206 2.847 3.506 3.952 2.754 2.151 1.588 0.442 1.168 1.370 1.504 1.838 2.025 0.768 ; 25.544 26.750 10.294 4.630 1.305 1.158 2.024 0.822 -0.489 -0.169 -1.056 0.371 1.082 1.663 2.884 3.005 3.209 2.844 3.497 3.954 2.757 2.160 1.591 0.447 1.167 1.369 1.506 1.843 2.024 0.772 ; 25.535 26.745 10.360 4.655 1.327 1.157 2.015 0.827 -0.482 -0.164 -1.053 0.365 1.071 1.661 2.882 3.011 3.212 2.842 3.488 3.957 2.761 2.169 1.593 0.452 1.165 1.368 1.509 1.849 2.022 0.777 ; 25.526 26.739 10.425 4.681 1.348 1.156 2.005 0.831 -0.474 -0.158 -1.048 0.360 1.056 1.659 2.881 3.017 3.214 2.840 3.478 3.958 2.764 2.178 1.596 0.456 1.162 1.367 1.512 1.854 2.022 0.782 ; 25.516 26.733 10.490 4.707 1.369 1.155 1.996 0.836 -0.467 -0.153 -1.045 0.354 1.042 1.656 2.878 3.023 3.215 2.838 3.467 3.961 2.767 2.187 1.598 0.461 1.157 1.367 1.515 1.859 2.021 0.786 ; 25.504 26.726 10.555 4.734 1.391 1.155 1.984 0.840 -0.459 -0.147 -1.041 0.348 1.028 1.652 2.875 3.029 3.218 2.836 3.456 3.963 2.770 2.195 1.601 0.465 1.152 1.366 1.516 1.865 2.020 0.791 ; 25.492 26.716 10.620 4.759 1.413 1.153 1.974 0.845 -0.451 -0.141 -1.037 0.343 1.014 1.650 2.872 3.035 3.221 2.834 3.446 3.965 2.775 2.205 1.604 0.470 1.148 1.364 1.518 1.870 2.019 0.796 ; 25.476 26.707 10.684 4.785 1.434 1.153 1.962 0.849 -0.443 -0.136 -1.034 0.337 1.000 1.648 2.870 3.041 3.222 2.833 3.435 3.966 2.779 2.214 1.606 0.475 1.144 1.364 1.520 1.876 2.020 0.801 ; 25.461 26.695 10.748 4.810 1.456 1.154 1.953 0.854 -0.436 -0.131 -1.030 0.331 0.985 1.645 2.868 3.047 3.225 2.832 3.424 3.968 2.783 2.223 1.609 0.479 1.140 1.363 1.522 1.881 2.019 0.805 ; 25.445 26.683 10.812 4.837 1.478 1.154 1.942 0.859 -0.429 -0.126 -1.027 0.326 0.972 1.642 2.865 3.054 3.227 2.830 3.414 3.970 2.785 2.233 1.612 0.484 1.134 1.361 1.523 1.886 2.019 0.810 ; 25.426 26.670 10.876 4.864 1.500 1.154 1.931 0.863 -0.421 -0.120 -1.023 0.321 0.957 1.640 2.863 3.059 3.229 2.828 3.402 3.972 2.788 2.241 1.614 0.488 1.129 1.360 1.524 1.891 2.019 0.814 ; 25.407 26.655 10.938 4.890 1.522 1.153 1.921 0.866 -0.414 -0.115 -1.019 0.316 0.943 1.638 2.860 3.064 3.232 2.826 3.391 3.973 2.792 2.251 1.617 0.491 1.124 1.358 1.526 1.896 2.019 0.819 ; 25.387 26.639 11.001 4.917 1.543 1.153 1.910 0.871 -0.407 -0.110 -1.016 0.310 0.929 1.635 2.858 3.070 3.234 2.824 3.380 3.975 2.794 2.260 1.620 0.496 1.119 1.358 1.527 1.901 2.019 0.824 ; 25.364 26.622 11.064 4.944 1.564 1.154 1.900 0.875 -0.400 -0.104 -1.012 0.306 0.915 1.631 2.855 3.076 3.236 2.822 3.368 3.977 2.798 2.270 1.623 0.499 1.112 1.357 1.528 1.906 2.018 0.829 ; 25.342 26.603 11.126 4.970 1.586 1.155 1.890 0.879 -0.393 -0.099 -1.008 0.301 0.901 1.628 2.852 3.081 3.238 2.821 3.357 3.978 2.800 2.279 1.624 0.504 1.107 1.356 1.529 1.912 2.019 0.834 ; 25.318 26.582 11.188 4.998 1.609 1.154 1.880 0.883 -0.387 -0.093 -1.005 0.296 0.887 1.625 2.848 3.087 3.241 2.820 3.346 3.980 2.804 2.288 1.628 0.508 1.100 1.356 1.531 1.917 2.018 0.839 ; 25.293 26.561 11.250 5.024 1.630 1.154 1.869 0.887 -0.380 -0.087 -1.001 0.291 0.874 1.622 2.845 3.093 3.243 2.818 3.334 3.982 2.807 2.297 1.630 0.511 1.095 1.355 1.531 1.923 2.018 0.844 ] }, ...
{ [ 0.000 ; 0.500 ; 1.000 ; 1.500 ; 2.000 ; 2.500 ; 3.000 ; 3.500 ; 4.000 ; 4.500 ; 5.000 ; 5.500 ; 6.000 ; 6.500 ; 7.000 ; 7.500 ; 8.000 ; 8.500 ; 9.000 ; 9.500 ; 10.000 ; 10.500 ; 11.000 ; 11.500 ; 12.000 ; 12.500 ; 13.000 ; 13.500 ; 14.000 ; 14.500 ; 15.000 ; 15.500 ; 16.000 ; 16.500 ; 17.000 ; 17.500 ; 18.000 ; 18.500 ; 19.000 ; 19.500 ; 20.000 ; 20.500 ; 21.000 ; 21.500 ; 22.000 ; 22.500 ; 23.000 ; 23.500 ; 24.000 ; 24.500 ; 25.000 ; 25.500 ; 26.000 ; 26.500 ; 27.000 ; 27.500 ; 28.000 ; 28.500 ; 29.000 ; 29.500 ; 30.000 ; 30.500 ; 31.000 ; 31.500 ; 32.000 ; 32.500 ; 33.000 ; 33.500 ; 34.000 ; 34.500 ; 35.000 ; 35.500 ; 36.000 ; 36.500 ; 37.000 ; 37.500 ; 38.000 ; 38.500 ; 39.000 ; 39.500 ; 40.000 ; 40.500 ; 41.000 ; 41.500 ; 42.000 ; 42.500 ; 43.000 ; 43.500 ; 44.000 ; 44.500 ; 45.000 ; 45.500 ; 46.000 ; 46.500 ; 47.000 ; 47.500 ; 48.000 ; 48.500 ; 49.000 ; 49.500 ; 50.000 ; 50.500 ; 51.000 ; 51.500 ; 52.000 ; 52.500 ; 53.000 ; 53.500 ; 54.000 ; 54.500 ; 55.000 ; 55.500 ; 56.000 ; 56.500 ; 57.000 ; 57.500 ; 58.000 ; 58.500 ; 59.000 ; 59.500 ; 60.000 ; 60.500 ; 61.000 ; 61.500 ; 62.000 ; 62.500 ; 63.000 ; 63.500 ; 64.000 ; 64.500 ; 65.000 ; 65.500 ; 66.000 ; 66.500 ; 67.000 ; 67.500 ; 68.000 ; 68.500 ; 69.000 ; 69.500 ; 70.000 ; 70.500 ; 71.000 ; 71.500 ; 72.000 ; 72.500 ; 73.000 ; 73.500 ; 74.000 ; 74.500 ; 75.000 ; 75.500 ; 76.000 ; 76.500 ; 77.000 ; 77.500 ; 78.000 ; 78.500 ; 79.000 ; 79.500 ; 80.000 ; 80.500 ; 81.000 ; 81.500 ; 82.000 ; 82.500 ; 83.000 ; 83.500 ; 84.000 ; 84.500 ; 85.000 ; 85.500 ; 86.000 ; 86.500 ; 87.000 ; 87.500 ; 88.000 ; 88.500 ; 89.000 ; 89.500 ; 90.000 ; 90.500 ; 91.000 ; 91.500 ; 92.000 ; 92.500 ; 93.000 ; 93.500 ; 94.000 ; 94.500 ; 95.000 ; 95.500 ; 96.000 ; 96.500 ; 97.000 ; 97.500 ; 98.000 ; 98.500 ; 99.000 ; 99.500 ; 100.000 ; 100.500 ; 101.000 ; 101.500 ; 102.000 ; 102.500 ; 103.000 ; 103.500 ; 104.000 ; 104.500 ; 105.000 ; 105.500 ; 106.000 ; 106.500 ; 107.000 ; 107.500 ; 108.000 ; 108.500 ; 109.000 ; 109.500 ; 110.000 ; 110.500 ; 111.000 ; 111.500 ; 112.000 ; 112.500 ; 113.000 ; 113.500 ; 114.000 ; 114.500 ; 115.000 ; 115.500 ; 116.000 ; 116.500 ; 117.000 ] }, ...
[], ...
{}, ...
{} ...
);

end

% ------------------------------ END OF CODE ------------------------------
