function res = example_CORAcolor_light()
% example_CORAcolor_light - example plotting sets with CORAcolor
%
% Syntax:
%    res = example_CORAcolor_light()
%
% Inputs:
%    -
%
% Outputs:
%    res - 
%
% References:
%    -
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: -

% Authors:       ---
% Written:       25-August-2025
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% Create a zonotope.
Z = zonotope([2;2],[eye(2) [1;1]]);
% Create a polytope.
P = polytope([-1 3/2 3/2 0; -3 -2 -4 -9/2]);
% Create an ellipsoid.
E = ellipsoid([2 1; 1 2],[-3;1]);

% Plot the zonotope using CORAcolors.
figure; hold on; grid on;
xlim([-5 5]);
ylim([-5 5]);
useCORAcolors('CORA:contDynamics');
plot(Z,1:2, ...
    FaceColor=CORAcolor('CORA:next:light'), ...
    EdgeColor=CORAcolor('CORA:next:dark'),LineWidth=2);
plot(P,1:2, ...
    FaceColor=CORAcolor('CORA:next:light'), ...
    EdgeColor=CORAcolor('CORA:next:dark'),LineWidth=2);
plot(E,1:2, ...
    FaceColor=CORAcolor('CORA:highlight1:light'), ...
    EdgeColor=CORAcolor('CORA:highlight1:dark'),LineWidth=2);

res = true;

end


% ------------------------------ END OF CODE ------------------------------
