classdef nnFixedLinearLayer < nnLinearLayer
% nnFixedLinearLayer - class for linear layers with fixed weights
%
% Syntax:
%    obj = nnFixedLinearLayer(W, b)
%    obj = nnFixedLinearLayer(W, b, name)
%
% Inputs:
%    W - weight matrix
%    b - bias column vector
%    name - name of the layer, defaults to type
%
% Outputs:
%    obj - generated object
%
% Other m-files required: none
% Subfunctions: none
% MAT-files required: none
%
% See also: neuralNetwork

% Authors:       Lukas Koller
% Written:       18-August-2025
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

methods
    % constructor
    function obj = nnFixedLinearLayer(W, varargin)
        % Parse the constructor arguments.
        [b, name] = setDefaultValues({0, []}, varargin);
        inputArgsCheck({ ...
            {W, 'att', {'numeric', 'gpuArray'}}; ...
            {b, 'att', {'numeric', 'gpuArray'}}; ...
        })
        % Call constructor of super class.
        obj@nnLinearLayer(W,b,name)
    end
end

methods
    function names = getLearnableParamNames(obj)
        % The parameters are fixed there are no learnable properties.
        names = {};
    end
end

end

% ------------------------------ END OF CODE ------------------------------
