#!/bin/bash

# Check if the directory is passed as an argument, if not use the current directory
DIR="${1:-.}"

# Find all .counterexample files recursively in the directory
find "$DIR" -type f -name "*.counterexample" | while read -r file; do
  # Create a temporary file to store the modified content
  tmp_file=$(mktemp)

  # Remove the 'sat\n' prefix from the file
  # Skip the first line and output the rest to the temporary file
  tail -n +2 "$file" > "$tmp_file"

  # Move the modified content back to the original file
  mv "$tmp_file" "$file"

  # Compress the modified file using gzip
  gzip "$file"
done

echo "All .counterexample files have been processed and compressed to .gz"
