function res = example_linear_verify_randomGeneration
% example_linear_verify_randomGeneration - example for the random
%    generation of verification benchmarks in 2D from [1, Sec. 4.1]
%
% Syntax:
%    res = example_linear_verify_randomGeneration
%
% Inputs:
%    -
%
% Outputs:
%    res - true/false
%
% Reference:
%    [1] M. Wetzlinger and M. Althoff. "Randomized Generation of
%        Arbitrarily Difficult Verification Tasks for Linear Time-Invariant
%        Systems", ARCH 2024.

% Authors:       Mark Wetzlinger
% Written:       06-June-2024
% Last update:   ---
% Last revision: ---

% ------------------------------ BEGIN CODE -------------------------------

% random generation - satisfiable
[sys,params,options,spec] = aux_load_ARCH2024_verify();

% call verification algorithm
options.verifyAlg = 'reachavoid:zonotope';
res_verify = verify(sys,params,options,spec);
disp("Verifiable verification benchmark verified? " + res_verify);


% random generation - unsatisfiable
[sys,params,options,spec] = aux_load_ARCH2024_falsify();

% call verification algorithm
options.verifyAlg = 'reachavoid:supportFunc';
res_falsify = verify(sys,params,options,spec);
disp("Falsifiable verification benchmark falsified? " + ~res_falsify);


% example completed
res = true;

end


% Auxiliary functions -----------------------------------------------------

function [sys,params,options,spec] = aux_load_ARCH2024_verify()
% load sys, params, options, spec, ...

% generated semi-automatically using printSystem, printSet, etc. 
% from saved .mat file

% build system
name = 'linearSys';
A = [ -3.8110475311047138 -0.3574052422367517 0.6027521394754989 0.2570578967602768 0.1644684054936587 ; -0.8718050621031210 -2.0943819122997693 -0.4377631732592620 0.3334017968818761 -0.0179652936472129 ; -0.6118106481950333 -0.4400926849738758 -3.5845683340009540 -0.3372670173700230 0.6085701344475409 ; 2.6576987783168788 1.0224901389350634 1.0469191652255518 -2.6319247591561759 -1.4335550605533696 ; -0.3236970705311601 0.0891961342462380 0.7438665945729266 0.1053160441848493 -2.9944440656356028 ];
B = [ -2.4674110411845001 ; -0.8140879900710041 ; 0.4628677384080593 ; -1.2834988597454271 ; -1.5392273283191495 ];
c = [ 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ];
C = [ -2.1451703882016271 -0.0543112582512360 -1.8625273655864922 -1.3695769532086275 -0.0005752711189823 ; -0.2227538686676293 -1.1456842969525978 -1.4697797059064004 1.2952777039539076 0.8985646905724420 ];
D = [ 0.0000000000000000 ; 0.0000000000000000 ];
k = [ 0.0000000000000000 ; 0.0000000000000000 ];
E = [ 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ];
F = [ 0.0000000000000000 ; 0.0000000000000000 ];
sys = linearSys(name,A,B,c,C,D,k,E,F);

% build params
params = struct( ...
    'R0', zonotope([ 5.0000000000000000 ; 5.0000000000000000 ; 5.0000000000000000 ; 5.0000000000000000 ; 5.0000000000000000 ], [ 0.0420970046393077 0.0029937905249039 0.0451959045958292 -0.0075680364861758 -0.0602790863093337 0.0195474003436262 -0.0176246733278821 -0.0423232073748414 0.0161977212002309 -0.1057077147673123 ; -0.0243695401224142 0.0019997780619650 -0.0639953494650813 -0.0047445287429414 -0.0126536896672063 0.0030664058378992 -0.0127421706529831 0.1171718987697493 -0.0463199429832771 -0.0328299857658403 ; 0.0070738532551941 -0.0005010817495392 -0.1163204422390537 -0.0220514652100213 0.0369304365295748 0.0043437639089805 0.0081963454578027 -0.0705513210011491 0.0592118846917073 -0.1015258767571739 ; -0.0300821231419568 -0.0028145810989033 -0.0116295746215172 0.0009488966475031 0.0081860439437046 -0.0798080567242666 0.0345389853279280 -0.0375549130348037 -0.1365704108743161 -0.0848000144878991 ; 0.0173585919547277 -0.0016495213727813 -0.0147806077997936 0.0174589241165023 0.0342135178569998 -0.0330157823182382 -0.0335590293060109 0.0745153490318801 -0.0411975619869034 0.1237218120153172 ]), ...
    'U', interval(-0.0365421391556038, -0.0023256695216301), ...
    'tFinal', 3.9775586689543942 ...
);

% build options
options = struct('verifyAlg', 'reachavoid:zonotope');

% build specification
% model
spec(1) = specification( ...
zonotope([ 0.8321242166121859 ; 0.9249164226204218 ], [ -0.1290763696873559 -0.5210929880113826 -0.0300681226338415 -0.1520388371196198 ; 0.0786343210422230 -0.2798101231411240 -0.1587562552661529 -0.5184351353260483 ]), ...
'unsafeSet', ...
interval(0, 3.9775586689543942), ...
[] ...
);
spec(2) = specification( ...
zonotope([ -15.4880103360023131 ; 3.5770290208234128 ], [ 0.0070827669233348 -0.3976770811006630 0.4293685664973709 -0.0615777042429111 ; -0.2594286116242237 0.3849966999308178 0.1187699853355841 -0.0539213975554581 ]), ...
'unsafeSet', ...
interval(0, 3.9775586689543942), ...
[] ...
);
spec(3) = specification( ...
zonotope([ -1.1737160423118080 ; 3.1425636873686877 ], [ 0.6199628996059953 0.4390111563112483 -0.6092322865148607 -0.7805103440994494 ; 0.2474604303873895 -0.0749595894401190 -0.5647776745804514 -0.1934236019694682 ]), ...
'unsafeSet', ...
interval(0, 3.9775586689543942), ...
[] ...
);

end

function [sys,params,options,spec] = aux_load_ARCH2024_falsify()
% load sys, params, options, spec, ...

% generated semi-automatically using printSystem, printSet, etc. 
% from saved .mat file

% build system
name = 'linearSys';
A = [ -1.0459332749972985 0.3054275400507984 -0.1892572088950447 -0.5885945040769969 0.5323634871869890 ; 4.5521214530351575 -4.9609273298437371 -0.4554602208674191 -10.2278168165740784 1.3225661454295421 ; -1.6442151581515252 1.6117062024370101 -1.5615182821575708 3.8907158275777998 -0.3127464045587209 ; -0.3517371869910703 0.3375721657406501 0.1277651675237905 -0.6123370356534639 -0.0665303140286951 ; -3.3324296359234715 0.6919991747371057 0.7020337064344012 7.2766104853075300 -4.1958866122811420 ];
B = [ 0.2453157639580785 ; 0.3138205320492265 ; 0.2540744813168389 ; -0.5267631119971203 ; 0.0060890903375406 ];
c = [ 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ];
C = [ 0.4529629934375169 1.2458935147759653 0.8127191434335793 0.9236156547948671 -0.4215845238023600 ; -0.7960534698866982 -1.2404836122416405 1.5599665332397414 -0.1138069230268073 0.2636217587652020 ];
D = [ 0.0000000000000000 ; 0.0000000000000000 ];
k = [ 0.0000000000000000 ; 0.0000000000000000 ];
E = [ 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ; 0.0000000000000000 ];
F = [ 0.0000000000000000 ; 0.0000000000000000 ];
sys = linearSys(name,A,B,c,C,D,k,E,F);

% build params
params = struct( ...
    'R0', zonotope([ 5.0000000000000000 ; 5.0000000000000000 ; 5.0000000000000000 ; 5.0000000000000000 ; 5.0000000000000000 ], [ -0.0219438285911679 0.0025313254401775 -0.0182185435186532 0.0004281830427728 0.0296890971701106 -0.0030465848155245 0.0004729041208615 0.0181188371394631 -0.0613343114396806 -0.0089172264868801 ; -0.0027405423806031 -0.0056583558031919 -0.0077067533168980 -0.0036541268818516 -0.0044543722056730 -0.0036118618143199 -0.0015527370833870 -0.0262990330593082 0.0236607243567853 0.0029172559719851 ; -0.0093559666344714 0.0456938722241940 -0.0432938500281280 -0.0086197163650166 -0.0075974901778377 -0.0405711292410365 -0.0083839783751528 0.1410776254996178 0.0007745138396136 -0.0008766887051003 ; 0.0165328400799349 0.0010580352447704 -0.0230504889788778 0.0036436703787987 -0.0633297198358481 -0.0326099815068661 0.0065756821953867 0.0718192056336443 -0.0090778399936876 -0.0194197483871550 ; 0.0023339493504228 0.0048390043308605 -0.0110316725977968 0.0015291440961949 0.0229133457339461 -0.0013889236360237 -0.0034412893464012 -0.0137891382232569 -0.0008260040107300 -0.0021014179774771 ]), ...
    'U', interval(-0.0298849993292831, 0.0139829161624792), ...
    'tFinal', 5.1535963807200096 ...
);

% build options
options = struct('verifyAlg', 'reachavoid:zonotope');

% build specification
% model
spec(1) = specification( ...
polytope([ -0.2207451350943051 -0.9753315258578474 ], -10.8108936253570818, zeros(0,2), zeros(0,1)), ...
'unsafeSet', ...
interval(0, 5.1535963807200096), ...
[] ...
);
spec(2) = specification( ...
polytope([ 0.4065508403784009 -0.9136281596949690 ], -8.5830388192822156, zeros(0,2), zeros(0,1)), ...
'unsafeSet', ...
interval(0, 5.1535963807200096), ...
[] ...
);
spec(3) = specification( ...
polytope([ 0.6843505743567261 0.7291531330095339 ], 0.0007256917971558, zeros(0,2), zeros(0,1)), ...
'unsafeSet', ...
interval(0, 5.1535963807200096), ...
[] ...
);

end

% ------------------------------ END OF CODE ------------------------------
