from functools import partial
from smac.env import MultiAgentEnv, StarCraft2Env
from .mpe_spread import MPESpread
from .mpe_gather import MPEGather
from .mpe_formation import MPEFormation
import sys
import os

def env_fn(env, **kwargs) -> MultiAgentEnv:
    return env(**kwargs)

REGISTRY = {}
REGISTRY["sc2"] = partial(env_fn, env=StarCraft2Env)
REGISTRY["mpe_spread"] = partial(env_fn, env=MPESpread)
REGISTRY["mpe_gather"] = partial(env_fn, env=MPEGather)
REGISTRY["mpe_formation"] = partial(env_fn, env=MPEFormation)

if sys.platform == "linux":
    os.environ.setdefault("SC2PATH",
                          os.path.join(os.getcwd(), "3rdparty", "StarCraftII"))
