library(ggplot2)

substrRight <- function(x, n){
  substr(x, nchar(x)-n+1, nchar(x))
}


results <- read.csv("results.csv", stringsAsFactors = F)


name <- results[, 2]
K <- sapply(name, function(x){
  y <- sub("_keys.*", "",  x)
  z <- sub(".*SynSep_K", "", y)
  return(as.integer(z))
}, USE.NAMES = F)
di <- sapply(name, function(x){
  y <- sub("_keylow.*", "",  x)
  z <- substrRight(y, 2)
  return(as.integer(z)/10)
}, USE.NAMES = F)
noise <- sapply(name, function(x){
  y <- sub(".*labelnoise", "",  x)
  return(as.numeric(y))
}, USE.NAMES = F)

sn <- results$algname
sn[sn == "RABanditron"] <- "Banditron"
sn[sn == "IWBanditron"] <- "Banditron"
sn[sn == "perceptron"] <- "Perceptron"
sn[sn == "soperceptron"] <- "soPerceptron"

shortname <- sapply(1:nrow(results), function(i){
  if(results$algname[i] == "Gappletron-adaL2"){
    if(results$lossname[i] == "logistic"){
      sni <- "GapLog"
    }
    if(results$lossname[i] == "hinge"){
      sni <- "GapHin"
    }
    if(results$lossname[i] == "smooth hinge"){
      sni <- "GapSmH"
    }
  }
  else if(results$algname[i] == "Gaptron-adaL2"){
    if(results$lossname[i] == "logistic"){
      sni <- "GTronLog"
    }
    if(results$lossname[i] == "hinge"){
      sni <- "GTronHin"
    }
    if(results$lossname[i] == "smooth hinge"){
      sni <- "GTronSmH"
    }
  }
  else{
    sni = sn[i]
  }
  return(sni)
})
shortname <- unlist(shortname)


rs <- subset(results, select = - c(dataname))
rs$noise <- noise
rs$d <- di * 40
rs$K <- K
rs$Algorithm <- shortname
rs$missclassification_rate <- rs$meanL/10^5

shpsbandit = c("GapHin" = 16, "GapLog" = 20, "GapSmH" = 18, "Banditron" = 19, "PNewtron" = 17, "SOBAdiag" = 15)
shpsfull = c("GapHin" = 16, "GapLog" = 20, "GapSmH" = 18, "Perceptron" = 19, "soPerceptron" = 17, "Pass-Aggr" = 15)



colsbandit = c("GapHin" = 'red', "GapLog" = 'blue', "GapSmH" = 'green', "Banditron" = 'purple', "PNewtron" = 'black', "SOBAdiag" = 'orange')
colsfull = c("GapHin" = 'red', "GapLog" = 'blue', "GapSmH" = 'green', "Perceptron" = 'purple', "soPerceptron" = 'black', "Pass-Aggr" = 'orange')


shpsGAP = c("GapHin" = 16, "GapLog" = 20, "GapSmH" = 18, "GTronHin" = 19, "GTronLog" = 17, "GTronSmH" = 15)
colsGAP = c("GapHin" = 'red', "GapLog" = 'blue', "GapSmH" = 'green', "GTronHin" = 'purple', "GTronLog" = 'black', "GTronSmH" = 'orange')



colsRA = c("GapHin" = 'red', "GapLog" = 'blue', "GapSmH" = 'green', "Banditron" = 'purple')
shpsRA = c("GapHin" = 16, "GapLog" = 20, "GapSmH" = 18, "Banditron" = 19)






# Bandit with only T tuning
test <- rs[rs$bandit == "True", ]
test <- test[test$gamma == "onlyT", ]
test <- test[test$algname != "Gaptron-adaL2", ]


sz <- 1.4
ddg <- 0.04
scaletext <- 1.75
scalelines <- 1.5
onlyTplot <- ggplot(test, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsbandit) +
  scale_colour_manual(values = colsbandit) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=12 * scaletext),
        axis.text.y = element_text(face="bold", size=12 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 17 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 17 * scaletext),
        legend.title = element_text(face="bold", size = 14 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 12 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 12 * scaletext, colour = "black"))
onlyTplot
ggsave(file = "onlyT.pdf", plot = onlyTplot)



# Bandit with theoretical tuning
test2 <- rs[rs$bandit == "True", ]
test2 <- test2[test2$gamma == "theo", ]
test2 <- test2[test2$algname != "Gaptron-adaL2", ]

theoplot <- ggplot(test2, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsbandit) +
  scale_colour_manual(values = colsbandit) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=12 * scaletext),
        axis.text.y = element_text(face="bold", size=12 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 17 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 17 * scaletext),
        legend.title = element_text(face="bold", size = 14 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 12 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 12 * scaletext, colour = "black"))
theoplot
ggsave(file = "theo.pdf", plot = theoplot)


# Full information
test3 <- rs[rs$bandit == "False", ]
test3 <- test3[test3$algname != "Gaptron-adaL2", ]

fullplot <- ggplot(test3, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsfull) +
  scale_colour_manual(values = colsfull) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=10 * scaletext),
        axis.text.y = element_text(face="bold", size=10 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        legend.title = element_text(face="bold", size = 12 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 10 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 10 * scaletext, colour = "black"))
fullplot
ggsave(file = "full.pdf", plot = fullplot)




# Revealing action theoretical tuning
test4 <- rs[rs$RA == "True", ]
test4 <- test4[test4$gamma == "theo", ]
test4 <- test4[test4$algname != "Gaptron-adaL2", ]

RAtheoplot <- ggplot(test4, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsRA) +
  scale_colour_manual(values = colsRA) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=10 * scaletext),
        axis.text.y = element_text(face="bold", size=10 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        legend.title = element_text(face="bold", size = 12 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 10 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 10 * scaletext, colour = "black"))
RAtheoplot
ggsave(file = "RAtheo.pdf", plot = RAtheoplot)



# Revealing action onlyT tuning
test5 <- rs[rs$RA == "True", ]
test5 <- test5[test5$gamma == "onlyT", ]
test5 <- test5[test5$algname != "Gaptron-adaL2", ]

RAonlyTplot <- ggplot(test5, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsRA) +
  scale_colour_manual(values = colsRA) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=10 * scaletext),
        axis.text.y = element_text(face="bold", size=10 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        legend.title = element_text(face="bold", size = 12 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 10 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 10 * scaletext, colour = "black"))
RAonlyTplot
ggsave(file = "RAonlyT.pdf", plot = RAonlyTplot)



#bandit best tuning plot 
test6 <- rs[rs$bandit == "True", ]
ovec <- order(test6$Algorithm, test6$K, test6$d, test6$noise, test6$gamma)
test6 <- test6[ovec, ]
temp6 <- lapply(1:(nrow(test6)/2), function(i){
  besttune <- which.min(c(test6[2 * i - 1, "meanL"], test6[2 * i, "meanL"]))
  row <- as.numeric(besttune == 1)
  return(test6[2 * i - row, ])
})
test6 <- do.call(rbind.data.frame, temp6)
test6 <- test6[test6$algname != "Gaptron-adaL2", ]



bestbanditplot <- ggplot(test6, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsbandit) +
  scale_colour_manual(values = colsbandit) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=12 * scaletext),
        axis.text.y = element_text(face="bold", size=12 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 17 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 17 * scaletext),
        legend.title = element_text(face="bold", size = 14 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 12 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 12 * scaletext, colour = "black"))
bestbanditplot
ggsave(file = "bestbandit.pdf", plot = bestbanditplot)






#Revealing action best tuning plot 
test7 <- rs[rs$RA == "True", ]
ovec <- order(test7$Algorithm, test7$K, test7$d, test7$noise, test7$gamma)
test7 <- test7[ovec, ]
temp7 <- lapply(1:(nrow(test7)/2), function(i){
  besttune <- which.min(c(test7[2 * i - 1, "meanL"], test7[2 * i, "meanL"]))
  row <- as.numeric(besttune == 1)
  return(test7[2 * i - row, ])
})
test7 <- do.call(rbind.data.frame, temp7)
test7 <- test7[test7$algname != "Gaptron-adaL2", ]



bestRAplot <- ggplot(test7, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsRA) +
  scale_colour_manual(values = colsRA) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=12 * scaletext),
        axis.text.y = element_text(face="bold", size=12 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 17 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 17 * scaletext),
        legend.title = element_text(face="bold", size = 14 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 12 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 12 * scaletext, colour = "black"))
bestRAplot
ggsave(file = "bestRA.pdf", plot = bestRAplot)






# checking label efficient
test8 <- rs[rs$LE == "True", ]
test8[test8$algname == "Gappletron-adaL2" & test8$gamma == "onlyT" & test8$lossname == "smooth hinge", ]







#%%
#Introducion  plot 

sz <- 1.4
ddg <- 0.010
scaletext <- 2.6
scalelines <- 3.4
colsbandit = c("GapHin" = 'red', "GapLog" = 'blue', "Gappletron" = 'green', "Banditron" = 'purple', "PNewtron" = 'black', "SOBAdiag" = 'orange')
shpsbandit = c("GapHin" = 16, "GapLog" = 20, "Gappletron" = 18, "Banditron" = 19, "PNewtron" = 17, "SOBAdiag" = 15)


test6 <- rs[rs$bandit == "True", ]
ovec <- order(test6$Algorithm, test6$K, test6$d, test6$noise, test6$gamma)
test6 <- test6[ovec, ]
temp6 <- lapply(1:(nrow(test6)/2), function(i){
  besttune <- which.min(c(test6[2 * i - 1, "meanL"], test6[2 * i, "meanL"]))
  row <- as.numeric(besttune == 1)
  return(test6[2 * i - row, ])
})
test6 <- do.call(rbind.data.frame, temp6)
test8 <- test6[test6$d == 120 & test6$K == 12 & test6$noise == 0.05, ]
test8 <- test8[test8$Algorithm != "GapHin" & test8$Algorithm != "GapLog", ]
test8$Algorithm[test8$Algorithm == "GapSmH"] <- "Gappletron"


introplot <- ggplot(test8, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4/1.5 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.0025 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  scale_shape_manual(values = shpsbandit) +
  scale_colour_manual(values = colsbandit) + 
  theme_bw() + 
  ylab("error rate") + 
  theme(axis.text.y = element_text(face="bold", size=12 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 17 * scaletext), #element_blank(),
        legend.title = element_text(face="bold", size = 14 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 12 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 12 * scaletext, colour = "black"),
        axis.title.x = element_blank(),
        axis.text.x = element_blank(),
        axis.ticks.x = element_blank(),
        legend.position = "top")
introplot
ggsave(file = "introplot.pdf", plot = introplot)

















# Gaptron vs Gappletron Plots

Gap1 <- rs[rs$bandit == "False", ]
Gap1 <- Gap1[!(Gap1$algname %in% c("perceptron", 'soperceptron', 'Pass-Aggr')), ]
gapfullplot <- ggplot(Gap1, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsGAP) +
  scale_colour_manual(values = colsGAP) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=10 * scaletext),
        axis.text.y = element_text(face="bold", size=10 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        legend.title = element_text(face="bold", size = 12 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 10 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 10 * scaletext, colour = "black"))
gapfullplot
ggsave(file = "gapfull.pdf", plot = gapfullplot)




Gap2 <- rs[rs$bandit == "True", ]
Gap2 <- Gap2[Gap2$gamma == "theo", ]
Gap2 <- Gap2[!(Gap2$algname %in% c("PNewtron", 'SOBAdiag', 'IWBanditron')), ]
gaptheoplot <- ggplot(Gap2, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsGAP) +
  scale_colour_manual(values = colsGAP) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=10 * scaletext),
        axis.text.y = element_text(face="bold", size=10 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        legend.title = element_text(face="bold", size = 12 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 10 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 10 * scaletext, colour = "black"))
gaptheoplot
ggsave(file = "gaptheo.pdf", plot = gaptheoplot)




Gap3 <- rs[rs$bandit == "True", ]
Gap3 <- Gap3[Gap3$gamma == "onlyT", ]
Gap3 <- Gap3[!(Gap3$algname %in% c("PNewtron", 'SOBAdiag', 'IWBanditron')), ]
gaponlyTplot <- ggplot(Gap3, aes(noise, missclassification_rate, colour = Algorithm, shape = Algorithm)) + 
  geom_point(size = 4 * scalelines, position = position_dodge(width = ddg)) + 
  geom_errorbar(aes(ymin = minL/10^5, ymax = maxL/10^5), position = position_dodge(width = ddg), width = 0.02 * scalelines, size = 0.75 * scalelines, show.legend = F) + 
  facet_grid(rows = vars(K), cols = vars(d)) +
  scale_shape_manual(values = shpsGAP) +
  scale_colour_manual(values = colsGAP) + 
  theme_bw() + 
  ylab("error rate") + 
  scale_x_continuous(breaks = c(0 , 0.05, 0.1)) +
  theme(axis.text.x = element_text(face="bold", size=10 * scaletext),
        axis.text.y = element_text(face="bold", size=10 * scaletext),
        axis.title.x = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        axis.title.y = element_text(face="bold", colour = 'black', size = 15 * scaletext),
        legend.title = element_text(face="bold", size = 12 * scaletext),
        legend.text = element_text(size = 14 * scaletext, margin = margin(t = 10)),
        strip.text.x = element_text(face = "bold", size = 10 * scaletext, colour = "black"),
        strip.text.y = element_text(face = "bold", size = 10 * scaletext, colour = "black"))
gaponlyTplot
ggsave(file = "gaponlyT.pdf", plot = gaponlyTplot)