# Hybrid Kernel Stein Variational Gradient Descent (h-SVGD)

This repository contains code accompanying the paper Hybrid Kernel Stein Variational Gradient Descent, currently under double-blind review for ICLR 2024. Much of the code in this repository is adapted from the <a href="https://github.com/DartML/Stein-Variational-Gradient-Descent" target="_blank">repository</a> that accompanies the <a href="https://proceedings.neurips.cc/paper_files/paper/2016/hash/b3ba8f1bee1238a2f37603d90b58898d-Abstract.html" target="_blank">Stein Variational Gradient Descent paper</a> (Liu & Wang), which appeared in NeurIPS 2016.

## Environment and Data Setup

The code in this repository has been developed and executed on a MacBook Pro with Apple M1 chip.

To run the Python code in this repository, first build the conda environment.

    conda env create -f environment.yml

Then activate the conda environment and navigate to the <tt>python</tt> directory.

    conda activate h-svgd
    cd python

The code to generate figures requires LaTeX to be installed for typesetting of the legends and axis titles.

## Proportional Limit Example (Multivariate Normal)

To recreate the multivariate normal results in the proportional limit result (Section 5.1 and Appendix D.1), choose a config file from the <tt>python/mvn/config</tt> directory and run the <tt>mvn.py</tt> script. For example, the following command will run the $d/N \to \gamma = 1$ scheme.

    python mvn.py -f gamma_1.py

The following command will run all config files in the <tt>python/mvn/config</tt> directory in sequence.

    ./mvn.sh

The following command will read outputs from the <tt>python/mvn/out</tt> directory and generate the plots in Figure 1 and Figure 4. Plots will be saved to the <tt>python/mvn/img</tt> directory.

    python mvn_plots.py

## Bayesian Neural Network Example

All datasets processed in this example should be placed in the <tt>data</tt> directory in either <tt>.csv</tt> or <tt>.arff</tt> format. Ensure that the label being predicted is in the last column and that features are in the other columns. This repository does not contain datasets, but the datasets used can all be retrieved from the <a href="https://archive.ics.uci.edu/" target="_blank">UCI Machine Learning Repository</a> or the <a href="https://www.openml.org/" target="_blank">OpenML Data Repository</a>.

To recreate the Bayesian neural network results (Section 5.2 and Appendix D.2), choose a config file from the <tt>python/bnn/config</tt> directory and run the <tt>bnn.py</tt> script. For example, the following command will run h-SVGD on the Boston housing dataset and store outputs in the <tt>python/bnn/out</tt> directory.

    python bnn.py -f boston.yml

The following command will run all datasets in sequence and store the output logs in the <tt>python/bnn/log</tt> directory.

    ./bnn.sh

The following command will read outputs from the <tt>python/bnn/out</tt> directory and generate the plot in Figure 2. The plot will be saved to the <tt>python/bnn/img</tt> directory.

    python bnn_damv_plot.py

## KSD Numerical Calculations

To compute the tractable form of the KSD and generate the plot in Figure 3, run the following command. The plot will be saved to the <tt>python/hKSD</tt> directory.

    python hksd.py