from setuptools import find_packages, setup

setup(
    name='hienet',
    version='1.0.0',
    description='HIENet',
    author='',
    python_requires='>=3.8',
    packages=find_packages(include=['hienet', 'hienet*']),
    install_requires=[
        'ase',
        'pymatviz',
        'torch-geometric',
        'braceexpand',
        'pyyaml',
        'torch-scatter',
        'e3nn',
        'scikit-learn',
        'pymatgen',
        'wandb',
        'torch-ema'
    ],

    entry_points={
        'console_scripts': [
            'hienet = hienet.main.hienet_main:main',
            'hienet_get_model = hienet.main.hienet_get_model:main',
            'hienet_graph_build = hienet.main.hienet_graph_build:main',
            'hienet_inference = hienet.main.hienet_inference:main',
            'hienet_lightning = hienet.main.hienet_lightning:main'
        ]
    },

)
