# Learning Materials Interatomic Potentials via Hybrid Invariant-Equivariant Architectures

The official implementation for the HIENet model from the "Learning Materials Interatomic Potentials via Hybrid Invariant-Equivariant Architectures" for the ICLR 2026 Submission.

![cover](figures/HIENet-overview.png)


## Performance Comparison
HIENet leverages a combination of invariant and equivariant layers to outperform purely invariant (InvNet) and purely equivariant (EqvNet) models in validation loss across different throughput settings. Moreover, this approach generalizes to other model architectures. For example, we demonstrate that adding an invariant layer to SevenNet (InvSevNet) outperforms the base architecture (SevenNet).
<table>
  <tr>
    <td><img src="figures/ThroughputComparison.png" alt="Throughput vs. Validation Loss comparison"></td>
    <td><img src="figures/ThroughputComparison-SevenNet.png" alt="Throughput vs. Validation Loss comparison with SevenNet"></td>
  </tr>
</table>

## Installation

### Requirements
- Python >= 3.8
- PyTorch >= 1.12.0

We have tested the model with the following configuration:
- Python 3.9
- PyTorch 2.1.2


After installing PyTorch, you can install HIENet from source:

```bash
git clone https://github.com/<repo>
cd <repo>
pip install .
```

## Training
To train the model you can use the training script:
```bash
./train.sh
```

You can adjust the model settings in the `train.yaml` file.

## Usage

### ASE Calculator
HIENet provides an interface with the Atomic Simulation Environment (ASE) through its calculator implementation. You can use the pretrained model as follows:

```python
from hienet.hienet_calculator import HIENetCalculator
from ase.io import read

# Load a structure from a file
atoms = read('your_structure.cif')

# Load from a specific checkpoint file and optionally specify the device to run on
calc = HIENetCalculator(model='path/to/your/checkpoint.pth', device='cuda:0')

# Attach the calculator to the atoms object
atoms.calc = calc

# Calculate energy, forces, and stress
energy = atoms.get_potential_energy()
forces = atoms.get_forces()
stress = atoms.get_stress()
```


## Acknowledgements

This project builds upon [SevenNet](https://github.com/MDIL-SNU/SevenNet) as starter code, which is licensed under the GNU General Public License v3.0. In addition to adding our own files, we made significant changes to the following files to implement HIENet architecture within the SevenNet's training pipeline:
- hienet/model_build.py
- hienet/nn/linear.py
- hienet/nn/edge_embedding.py
- hienet/train/loss.py
- hienet/train/optim.py

We have also adjusted function and file names and made other slight changes in other files for consistency:
- hienet/main/*.py
- hienet/train/*.py 
- hienet/nn/*.py
- hienet/scripts/*.py
- hienet/*.py
