# Local Differential Privacy for Mixtures of Experts

## Requirements
- Python 3.8
- Pytorch 1.9.0
- Numpy 1.17.4
- Scikit-learn 0.22.2
- Pandas 0.25.3


To install requirements:

```setup
pip install -r requirements.txt
```


## Training

To reproduce the experiments presented in Section 5 of the paper, run:

```
python main.py --dataset dataset_name --n_experts 100 --epochs num_epochs --runs 10
```

- **dataset_name**: the name of the dataset for which you intend to conduct the experiment. It can be 'ads', 'heart', 'breast' for the Breast Cancer dataset, 'mnist17' or 'mnist56' for MNIST 1 vs 7 and MNIST 5 vs 6 respectively.

- **num_epochs**: the number of epochs you want to train the model for. To reproduce our experiments set this number to 300 for experiments on MNIST and set it to 1000 otherwise.

For example, to reproduce the experiments presented in Table 1 of the article, for the dataset Breast Cancer, you will need to run the following:

```
python main.py --dataset breast --n_experts 100 --epochs 1000 --runs 10

```
