from collections_extended import setlist
from transformers import AutoTokenizer
import torch

GLUE_TASKS = ["cola", "sst2", "mrpc", "qqp", "mnli", "qnli", "rte"]
metaeval_path = "/cw/working-arwen/damien/datasets/arr"


class args:
    gpus = 1
    seed = 2
    accumulate_grad_batches = 1
    gradient_clip_val = 1.0
    train_batch_size = 32
    eval_batch_size = 128
    learning_rate = 3e-5
    adam_epsilon = 1e-8
    max_epochs = 1
    max_samples = 30000
    max_samples_2 = max_samples
    max_test_samples = 10000
    glue_max_samples = None
    max_epochs_2 = 3
    weight_decay = 0.0
    warmup_prop = 0.1
    eval_splits = None
    amp_level = "O1"
    model_name_or_path = "roberta-base"
    num_workers = 16
    num_adapter_layers = 12
    adapter_size = 256
    shuffle_tasks = True
    ln_mode = "ln"
    strip_pooler = True
    tok = AutoTokenizer.from_pretrained(model_name_or_path)
    special_tokens = list(set(tok.all_special_ids))
    trained_tokens = special_tokens
    metaeval_path = metaeval_path
    learning_rate = 2e-5
    loss_cap = 1.0
    optimizer = torch.optim.Adam
    task_embedding_sizes = 32
    adapter_activation = torch.nn.Identity
    task_embedding_activation = torch.nn.Identity
    use_task_features = False
    share_labels = False
    adapter_mode = "gated"
    embedding_mode = "hyper"
    training_task = None
    inference_test_task = None
    name = None
    task_embedding_size = 32
    inference = "supervised"
    features_path = f"{metaeval_path}/task_features.csv"
    inference_task_embedding = ""
    finetuning_trained_modules = setlist()
    repeat_test = False
