__author__ = 'Qi'
# Created by on 9/8/22.
import numpy as np


def get_accuracy(truth, pred):
    assert len(truth) == len(pred)
    right = 0
    for i in range(len(truth)):
        if truth[i] == pred[i]:
            right += 1.0
    return right / len(truth)

def get_demographic_parity(pred, attributes):

    pred = np.array(pred)
    attributes = np.array(attributes)
    pos_pred_for_f = np.sum(pred[attributes==0])/len(pred[attributes==0])
    pos_pred_for_m = np.sum(pred[attributes==1])/len(pred[attributes==1])
    # print(pred, len(pred[attributes==1]), len(pred[attributes==0]))
    return pos_pred_for_f/pos_pred_for_m
