__author__ = 'Qi'
# Created by on 9/8/22.

import argparse

model_names = ['resnet18', 'resnet34', 'resnet50']
def get_parameters():
    # Parse arguments
    parser = argparse.ArgumentParser(description='RAAN Objective Training Parameters')
    parser.add_argument('--data', default='celeba', type=str)

    parser.add_argument('--methods', default='SCRAAN', type=str, help='which algorithms used for training')

    # Optimization options
    parser.add_argument('--first_stage_epochs', default=90, type=int, metavar='N',
                        help='number of fist stage epochs to run')
    parser.add_argument('--second_stage_epochs', default=90, type=int, metavar='N',
                        help='number of second stage epochs to run')

    parser.add_argument('--HIDDEN_DIM', default=50, type=int, metavar='N',
                        help='Input data dimension, ')
    parser.add_argument('--INPUT_DIM', default=120, type=int, choices = [138, 120], metavar='N',
                        help='Hidden layer data dimension, ')
    parser.add_argument('--train_batch', default=256, type=int, metavar='N',
                        help='train batchsize (default: 256)')

    parser.add_argument('--lr', '--learning-rate', default=1e-2, type=float,
                        metavar='LR', help='initial/first stage learning rate')
    parser.add_argument('--lr2', '--learning-rate2', default=1e-3, type=float,
                        metavar='LR', help='second stage learning rate')

    parser.add_argument('--neb_tau', type=float, default=0.1,
                        help='neighbourhood parameter for RAAN objective')
    parser.add_argument('--tau', type=float, default=0.9,
                        help='temperature parameter for DRO')
    parser.add_argument('--is_feature_trainable', default=False, type=bool, metavar='M',
                        help='momentum')
    parser.add_argument('--neb_tau_list', type=float, nargs='+', default=[0.1, 0.3, 0.5, 0.7], # [0.01, 0.03, 0.05, 0.07] , # ,
                        help='decrease learning rate at these epochs.')

    parser.add_argument('--class_tau', type=float, default = 0,
                        help='neighbourhood parameter for RAAN objective')

    parser.add_argument('--eor_reg', type=float, default=0.2,
                        help='eor_regularizer hyperparameter')
    parser.add_argument('--adv_reg', type=float, default=0.2,
                        help='eor_regularizer hyperparameter')

    parser.add_argument('--optimizer', type=str, default='SGD',
                        help='optimizer choice')
    parser.add_argument('--gamma', type=float, default=0.1,
                        help='moving average of scraan')

    return parser.parse_args()
