using AnonymousRepo1
using Ipopt, HiGHS, Clarabel

const PM = AnonymousRepo1.PowerModels
const JuMP = AnonymousRepo1.JuMP
const MOI = AnonymousRepo1.JuMP.MOI


function projection(
    OPF::Type{<:AnonymousRepo1.AbstractFormulation},
    data::AnonymousRepo1.OPFData,
    solution,
    optimizer
)
    opf = AnonymousRepo1.build_opf(OPF, data, optimizer)

    obj = 0.0
    for v in VARS_MAP[OPF]
        if haskey(solution, v)
            obj += sum((solution[v] .- opf.model[v]) .^ 2)
        end
    end

    JuMP.set_objective(opf.model, MOI.MIN_SENSE, obj)

    AnonymousRepo1.solve!(opf)

    d = AnonymousRepo1.extract_result(opf)

    return Tuple([
        d["primal"][string(v)] for v in VARS_MAP[OPF]
    ]), nothing
end

VARS_MAP = Dict{Type{<:AnonymousRepo1.AbstractFormulation}, Vector{Symbol}}(
    AnonymousRepo1.ACOPF => [:pg, :qg, :pf, :pt, :qf, :qt, :vm, :va],
    AnonymousRepo1.DCOPF => [:pg, :pf, :va],
    AnonymousRepo1.SOCOPF => [:pg, :qg, :pf, :pt, :qf, :qt, :w, :wr, :wi],
)


function ac_projection(pd, qd, pg, qg, vm, va)
    data = deepcopy(base_data)
    data.pd .= pd
    data.qd .= qd
    return projection(
        AnonymousRepo1.ACOPF,
        data,
        Dict(
            :pg => pg,
            :qg => qg,
            :vm => vm,
            :va => va
        ),
        Ipopt.Optimizer
    )
end


function dc_projection(pd, pg, pf, va)
    data = deepcopy(base_data)
    data.pd .= pd
    return projection(
        AnonymousRepo1.DCOPF,
        data,
        Dict(
            :pg => pg,
            :pf => pf,
            :va => va
        ),
        HiGHS.Optimizer
    )
end


function soc_projection(pd, qd, pg, qg, w, wr, wi)
    data = deepcopy(base_data)
    data.pd .= pd
    data.qd .= qd
    return projection(
        AnonymousRepo1.SOCOPF,
        data,
        Dict(
            :pg => pg,
            :qg => qg,
            :w => w,
            :wr => wr,
            :wi => wi
        ),
        Clarabel.Optimizer
    )
end


function no_backward(args...)
    throw(ArgumentError("Projection layer does not support backpropagation."))
end