# PGLearn supplemental material

The supplemental material contains anonymized source code for the repositories described in the paper. What follows is a brief tutorial highlighting some of the basic functionality of each repository.

### Dependencies
Install [Julia](https://julialang.org/downloads/) for AnonymousRepo1 and [Python via conda](https://docs.conda.io/projects/conda/en/latest/user-guide/install/index.html) for AnonymousRepo2.

### AnonymousRepo1: Data Generation
Generate a small AC/SOC/DC dataset:

```bash
cd AnonymousRepo1
julia --project=. -e 'using Pkg; Pkg.instantiate()'      # install dependencies
julia --project=. slurm/make_ref.jl exp/config.toml      # solve reference case
julia --project=. exp/sampler.jl exp/config.toml 1 100   # solve 100 samples
julia --project=. slurm/merge.jl exp/config.toml         # post-process into PGLearn format
```

### AnonymousRepo2: Machine Learning
Train and test optimality/violations of a small ACOPF proxy on that dataset:

```bash
cd AnonymousRepo2
conda env create -f environment.yml
pip install -e ".[all]"
ipython
```

```python
from anonymousrepo2 import ACProblem
from anonymousrepo2.models.basic_nn import ACBasicNeuralNet

# load the dataset
problem = ACProblem("../AnonymousRepo1/data/89_pegase")

# initialize the model
config = {
    "optimizer": "adam",
    "learning_rate": 1e-3,
    "loss": "mse",
    "hidden_sizes": [64,32,64],
    "activation": "sigmoid",
    "boundrepair": "sigmoid",
}

model = ACBasicNeuralNet(config, problem)

# run training
model.train(trainer_kwargs={'max_epochs': 10, 'accelerator': 'cpu'})

# run evaluation
evals = model.evaluate_model()

# print statistics
from anonymousrepo2.viz import make_stats_df
print(make_stats_df(evals))
```