# PCFM: Physics-Constrained Flow Matching

This repository contains the code for our NeurIPS submission, *Physics-Constrained Flow Matching (PCFM)*. It builds on pretrained unconditional Functional Flow Matching (FFM) models.

## Overview
- Implements PCFM and other baseline sampling methods on a pretrained FFM model 
- Experiments and constraint residuals for 1D Heat, and 2D Navier-Stokes, 1D Reaction-Diffusion, 1D Burgers (IC) and 1D Burgers (BC)
- Includes dataset generation, model pretraining, sampling, and evaluation.
- Acknowledgements: We adopt code from Cheng et al. for FFM pretraining and loading, and generation of PDE datasets for Heat and Navier-Stokes problems.

## Key folders  
- `configs/`: YAML config files for pretraining FFM models
- `datasets/`: Code to generate and load PDE datasets (`generate_*.py` scripts for solvers and data generation).
- `main.py`: FFM model pretraining script for 1D PDEs.
- `main_lightning.py`: FFM model pretraining script for 2D Navier-Stokes.
- `models/`: FNO-based FFM model (`functional.py`) and core PCFM algorithm (`PCFM_sampling.py`).
- `experiments/`: Main scripts for comparison experiments (e.g., `burgersIC_sampling.py`).

## Environment setup
```bash
conda env create -f pcfm_env.yml
```

## Data generation
Run the scripts in `datasets/` to generate training and sampling datasets. 

```bash
# Burgers
python datasets/generate_burgers1d_data.py

# Reaction-Diffusion
python datasets/generate_RD1d_data.py

# Navier-Stokes
python datasets/generate_ns_2d.py --root datasets/data --s 64 --steps 50 --mu 0.001 --nw 100 --nf 100
```

## FFM model training
Use `main.py` for 1D problems:
```bash
python main.py configs/burgers1d.yml --savename burgers
```

Use `main_lightning.py` for Navier-Stokes:
```bash
python main_lightning.py configs/ns_lightning.yml --savename ns_lightning --devices 4
```

## Running PCFM and baseline sampling comparisons 
Each script in `experiments/` runs a sampling comparison for each PDE problem we investigated in the paper:
```bash
python experiments/heat_sampling.py
python experiments/burgersIC_sampling.py
```

