import argparse 
import sys 

from .import run ,get_trace_formatter 


def main ()->None :
    parser =argparse .ArgumentParser (prog ="pytracify")
    parser .add_argument ("path",help ="path to the Python file to run")
    parser .add_argument (
    "--trace-formatter",
    help ="trace formatter to use",
    choices =["indented","numeric_depth","no_indent"],
    )
    parser .add_argument (
    "--input-data",
    help ="string passed to script via stdin",
    default ="",
    )
    parser .add_argument (
    "--hide-mnemonics",
    help ="hide mnemonic instructions",
    action ="store_true",
    default =False ,
    )
    parser .add_argument (
    "--max-char-length",
    help =(
    "maximum number of characters for Trace. "
    "Note: This counts characters (not tokens); "
    "the default (1,280,000) is set to 10x the Llama3 maximum context length (128K)."
    ),
    type =int ,
    default =128_000 *10 ,
    )
    parser .add_argument (
    "--override",
    help ="Read override definitions from stdin.",
    action ="store_true",
    default =False ,
    )
    args =parser .parse_args ()

    source =open (args .path ).read ()

    override_code_content :str |None =None 
    if args .override :
        override_code_content =sys .stdin .read ()
    result =run (
    source ,
    input_data =args .input_data ,
    max_char_length =args .max_char_length ,
    hide_mnemonics =args .hide_mnemonics ,
    override_code_str =override_code_content ,
    )
    trace_formatter =get_trace_formatter (args .trace_formatter )
    print (trace_formatter (result .trace ))


if __name__ =="__main__":
    main ()
