import dataclasses 
from typing import Callable 


@dataclasses .dataclass 
class TraceEntry :
    depth :int 
    line :str 


Trace =list [TraceEntry ]


TraceFormatter =Callable [[Trace ],str ]


def format_trace_indented (trace :Trace )->str :
    return "\n".join (f"{'| '*entry .depth }{entry .line }"for entry in trace )


def format_trace_numeric_depth (trace :Trace )->str :
    return "\n".join (f"{entry .depth } {entry .line }"for entry in trace )


def format_trace_no_indent (trace :Trace )->str :
    return "\n".join (entry .line for entry in trace )


def get_trace_formatter (
trace_formatter :None |str |TraceFormatter =None ,
)->TraceFormatter :
    if trace_formatter is None :
        return format_trace_indented 

    if isinstance (trace_formatter ,str ):
        if trace_formatter =="indented":
            return format_trace_indented 
        elif trace_formatter =="numeric_depth":
            return format_trace_numeric_depth 
        elif trace_formatter =="no_indent":
            return format_trace_no_indent 
        else :
            raise ValueError (f"Unknown trace formatter: {trace_formatter }")

    if callable (trace_formatter ):
        return trace_formatter 

    raise ValueError (f"Unknown trace formatter: {trace_formatter }")
