# ET-CoT Training Scripts

## Prerequisites

* Update every occurrence of `/path/to/home` in the scripts to match your own environment.
* Create the checkpoint directories in advance, for example:

  * `/path/to/home/checkpoints`
  * `/path/to/home/converted_checkpoint`
* Prepare the ET-CoT dataset beforehand by following the instructions in the `02_codeexec_etcot` README.

## Installation

This package has been tested with Python 3.10 and 3.11.
The recommended environment includes the CUDA Toolkit 12.1.

To install the required packages, simply run:

```bash
pip install -r requirements.txt
```

> **Note:** The `requirements.txt` assumes that CUDA Toolkit 12.1 is already installed on your system.

### Multi-node Support

For multi-node training, make sure the following dependencies are installed:

```bash
module load openmpi/4.x.x
pip install mpi4py
```

### FlashAttention

To enable GPU-accelerated FlashAttention, run:

```bash
pip install ninja packaging wheel
pip install setuptools
pip install flash-attn==2.7.3 --no-build-isolation
```

### Weights & Biases (Optional)

Log in to Weights & Biases if you plan to track experiments:

```bash
wandb login
```

## Running an Experiment

```sh
export CONFIG=/path/to/home/lltm/02_codeexec_etcot/scripts/ET-CoT/configs/qwen3/qwen3-32B-vanilla.sh
./scripts/ET-CoT/run_experiments.sh $CONFIG
```

Create your `$CONFIG` file based on the examples in the `configs` directory.

## Retrieving Results

```sh
cd scripts/ET-CoT
python3 utils/get_latest_results.py --path 'inference_logs/Qwen3-8B/1epoch/some-experiment'
```

---

This version keeps the Markdown structure, technical accuracy, and natural English phrasing for documentation or README use.
