EPOCH=3
NUM_GPUS=8

BASE_MODEL=OLMo-2-1124-7B-Instruct
MODEL_ORG=allenai
TRAIN_DATASET=olmo2-7B-vanilla-ce-oko

CHECK_POINT_ROOT_PATH="/path/to/home/checkpoints"
CONVERTED_CHECK_POINT_ROOT_PATH="/path/to/home/converted_checkpoint"

SYSTEM_PROMPT="You are given a function and an input. Complete the assertion with the output of executing the function on the input. First, reason step by step before arriving at an answer. Then, surround the answer as an assertion with <answer> and </answer> tags." \

LATEST_ITERATION_FILE="${CHECK_POINT_ROOT_PATH}/${BASE_MODEL}/${TRAIN_DATASET}_lr_2e-5-minlr_4e-6_GB_64_${EPOCH}epoch/latest_iteration.txt"

if [ -f "$LATEST_ITERATION_FILE" ]; then
  ITERATION=$(cat "$LATEST_ITERATION_FILE")
else
  ITERATION=0
fi

FORMATTED_ITERATION=$(printf "iter_%07d" "$ITERATION")
INFERENCE_MODEL_PATH="${MODEL_ORG}/${BASE_MODEL}"

USE_GUIDED_DECODING=false
