#!/bin/bash




SCRIPT_DIR="$(cd "$(dirname "$(readlink -f "$0")")" && pwd)"
REPO_ROOT="$(cd "${SCRIPT_DIR}/../.." && pwd)"

CONFIG_FILE=${1:-"${SCRIPT_DIR}/configs/base_config.sh"}
echo "CONFIG_FILE: ${CONFIG_FILE}"

source ${REPO_ROOT}/.venv/bin/activate
source $CONFIG_FILE






${SCRIPT_DIR}/train.sh \
 $EPOCH \
 $TRAIN_DATASET \
 $BASE_MODEL \
 $MODEL_ORG \
 $NUM_GPUS \
 $CHECK_POINT_ROOT_PATH \
 $SYSTEM_PROMPT
python3 ${SCRIPT_DIR}/utils/send_to_slack.py "<!channel> ✅ Train Finished!
> • Model: \`$BASE_MODEL\`
> • Dataset: \`$TRAIN_DATASET\`
> • Epoch: \`$EPOCH\`
> • Config: \`$CONFIG_FILE\`"

source $CONFIG_FILE


${SCRIPT_DIR}/convert_model.sh \
 $EPOCH \
 $TRAIN_DATASET \
 $ITERATION \
 $CHECK_POINT_ROOT_PATH \
 $CONVERTED_CHECK_POINT_ROOT_PATH \
 $BASE_MODEL \
 $MODEL_ORG \
python3 ${SCRIPT_DIR}/utils/send_to_slack.py "<!channel> ✅ Model Conversion Finished!
> • Model: \`$BASE_MODEL\`
> • Dataset: \`$TRAIN_DATASET\`
> • Iteration: \`$ITERATION\`"





declare -a inference_datasets=(
  "LLTM-cruxeval-numeric-depth-val"
  "LLTM-livecodebench-numeric-depth-val"
  "LLTM-livecodebench-all-numeric-depth-val"














)

VAL_DATA_PATH="${REPO_ROOT}/scripts/instruction/convert_datasets"

for i in "${!inference_datasets[@]}"; do
  cuda_device_id=$i
  current_eval_dataset="${inference_datasets[$i]}"
  ${SCRIPT_DIR}/inference.sh \
    "$EPOCH" \
    "$ITERATION" \
    "$NUM_GPUS" \
    "$BASE_MODEL" \
    "$TRAIN_DATASET" \
    "$current_eval_dataset" \
    "$INFERENCE_MODEL_PATH" \
    "$VAL_DATA_PATH" \
    "$SYSTEM_PROMPT"
done

${SCRIPT_DIR}/utils/aggregate_inference_outputs.sh \
    $TRAIN_DATASET \
    $BASE_MODEL \
    $ITERATION \
    $EPOCH \
    $USE_GUIDED_DECODING
