import json 
import sys 

def validate_jsonl (file_path ):
    """
    JSONLファイルを1行ずつ検証し、問題のある箇所を報告する関数
    """
    error_count =0 
    print ("🔍 検証を開始します...")

    with open (file_path ,'r',encoding ='utf-8')as f :





        for i ,line in enumerate (f ):
            line_num =i +1 


            if line_num %100 ==0 :


                print (f"⏳ 検証中: {line_num }行...",end ='\r')



            if not line .strip ():

                print ()
                print (f"⚠️  警告: {line_num }行目は空です。")
                continue 

            try :

                json .loads (line )
            except json .JSONDecodeError as e :

                print ()

                print (f"❌ エラー: {line_num }行目に無効なJSONがあります。")
                print (f"   内容: {line .strip ()}")
                print (f"   詳細: {e }")
                error_count +=1 


    print (" "*40 ,end ="\r")
    print ("-"*20 )
    if error_count ==0 :
        print ("✅ 検証完了: ファイルは有効なJSONL形式です。")
    else :
        print (f"🔥 検証完了: 合計 {error_count } 個のエラーが見つかりました。")

    return error_count ==0 

if __name__ =="__main__":
    if len (sys .argv )!=2 :
        print ("使い方: python check_jsonl.py <ファイル名>")
        sys .exit (1 )

    file_to_check =sys .argv [1 ]
    validate_jsonl (file_to_check )
