
TRAIN_DATASET_NAME=${1:-"LLTM-all-numeric-depth"}
EVAL_DATASET_NAME=${2:-"LLTM-cruxeval-numeric-depth-val"}
MODEL_NAME=${3:-"Meta-Llama-3-8B-Instruct"}
ITERATION=${4:-"7500"}
EPOCH=${5:-"3"}
USE_GUIDED_DECODING=${6:-"false"}

UTILS_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SCRIPT_DIR="$(cd "${UTILS_DIR}/../.." && pwd)"



echo "Total iterations: $ITERATION"

SUFFIX=""
if [ "${USE_GUIDED_DECODING}" = "true" ]; then
  SUFFIX="-guided"
fi

echo "Using suffix: $SUFFIX"

SOURCE_PATH=${SCRIPT_DIR}/instruction/convert_datasets/${EVAL_DATASET_NAME}.jsonl
ls $SOURCE_PATH
TARGET_PATH=${SCRIPT_DIR}/ET-CoT/inference_trace/${MODEL_NAME}/${EPOCH}epoch/${EVAL_DATASET_NAME}/${TRAIN_DATASET_NAME}-iter${ITERATION}${SUFFIX}.jsonl
ls $TARGET_PATH
TRACE_LOG_PATH=${SCRIPT_DIR}/ET-CoT/inference_trace/${MODEL_NAME}/${EPOCH}epoch/${EVAL_DATASET_NAME}/${TRAIN_DATASET_NAME}-iter${ITERATION}${SUFFIX}.csv
mkdir -p "$(dirname "${TRACE_LOG_PATH}")"
mkdir -p "$(dirname "${TRACE_LOG_PATH}")"

INFERENCE_OUTPUT_PATH=${SCRIPT_DIR}/ET-CoT/inference_outputs/${MODEL_NAME}/${EPOCH}epoch/${EVAL_DATASET_NAME}/${TRAIN_DATASET_NAME}/iter${ITERATION}${SUFFIX}.txt
mkdir -p "$(dirname "${INFERENCE_OUTPUT_PATH}")"
mkdir -p "$(dirname "${INFERENCE_OUTPUT_PATH}")"

echo "-----------------------"
echo "Diffing traces:"
echo "SOURCE_PATH: $SOURCE_PATH"
echo "TARGET_PATH: $TARGET_PATH"
echo "TRACE_LOG_PATH: $TRACE_LOG_PATH"
echo "INFERENCE_OUTPUT_PATH: $INFERENCE_OUTPUT_PATH"
echo "-----------------------"

python3 ${UTILS_DIR}/diff_trace.py \
  $SOURCE_PATH \
  $TARGET_PATH \
  $TRACE_LOG_PATH \
  $INFERENCE_OUTPUT_PATH \

echo "CSV diff log saved at $TRACE_LOG_PATH"
