
import sys 
import os 
import json 
import requests 
from dotenv import load_dotenv 


load_dotenv ()

def send_to_slack (message ,webhook_url ,channel ):
    """Slackにメッセージを送信する関数"""
    payload ={
    "channel":channel ,
    "text":message 
    }
    headers ={"Content-Type":"application/json"}
    response =requests .post (webhook_url ,data =json .dumps (payload ),headers =headers )
    return response 

def main ():

    if len (sys .argv )<2 :
        print ("Usage: python send_to_slack.py [Message]")
        sys .exit (1 )


    message =" ".join (sys .argv [1 :])


    webhook_url =os .environ .get ("SLACK_WEBHOOK_URL")
    if not webhook_url :
        print ("Error: Slack webhook URL is not set. Please check your .env file.")
        sys .exit (1 )


    channel =os .environ .get ("SLACK_CHANNEL","#1_general")


    response =send_to_slack (message ,webhook_url ,channel )


    if response .status_code !=200 :
        print ("Failed to send message. Status code:",response .status_code )
        print ("Response:",response .text )
        sys .exit (1 )
    else :
        print ("Message sent successfully.")

if __name__ =='__main__':
    main ()
