set -euo pipefail

SRC=/path/to/home/lltm-h200/data_stable
DST=/path/to/home/lltm/13_msswift/datasets
mkdir -p "$DST"

for f in Pytracify_deleted.jsonl CruxEval.jsonl; do

  cp -n "$SRC/$f" "$SRC/$f.bak" || true


  jq -c 'del(.system)
         | if has("messages") then
             .messages |= map(select(.role != "system"))
           else . end' \
     "$SRC/$f" > "$DST/$f"

  echo "[done] $DST/$f"
done


if grep -n '"role": *"system"' -R "$DST" >/dev/null; then
  echo "[WARN] A system role still remains. Please review the filter."
else
  echo "[OK] System roles have been removed."
fi

echo "---- head -n2 $DST/Pytracify_deleted.jsonl ----"
head -n2 "$DST/Pytracify_deleted.jsonl" || true
echo "---- head -n2 $DST/CruxEval.jsonl ----"
head -n2 "$DST/CruxEval.jsonl" || true
