#!/bin/bash


CUDA_VISIBLE_DEVICES=6,7 \
swift rollout \
    --model Qwen/Qwen2.5-7B-Instruct \
    --model_type 'qwen2_5' \
    --use_hf true \
    --data_parallel_size 1 \
    --tensor_parallel_size 2 \
    > swift_logs/log.out 2>&1 &


CUDA_VISIBLE_DEVICES=6,7 \
swift rollout \
    --model Qwen/Qwen3-8B \
    --model_type 'qwen3' \
    --use_hf true \
    --data_parallel_size 1 \
    --tensor_parallel_size 2 \
    > swift_logs/log.out 2>&1 &



SYS='You are given a Python code and an input. Predict the the output of executing the code on the input. First, reason step by step before arriving at an answer. Then, surround the answer as an assertion with <answer> and </answer> tags.' \
CUDA_VISIBLE_DEVICES=6,7 \
swift rollout \
  --model allenai/OLMo-2-1124-7B-Instruct \
  --use_hf true \
  --model_type olmo2 \
  --template olmo2 \
  --custom_register_path /path/to/home/lltm/13_msswift/custom_register_olmo2.py \
  --data_parallel_size 1 \
  --tensor_parallel_size 2 \
  --log_level debug \
  > swift_logs/olmo2_rollout.out 2>&1 &


