# pytracify

## Quick Start

Install [uv](https://docs.astral.sh/uv/getting-started/installation/), then run:

```bash
# Generate a trace by running `example.py`
uv run pytracify example.py
```

## Development

```bash
uv run ruff check . --fix
uv run ruff format
uv run mypy .
uv run pytest
```

## Function override

1. Prepare a file which contains the function you want to override. For example, `custom_len_def.py`:
    ```python
    def foo():
        print("Hello, world!")
    ```
2. You can override the function with the usage below:
    ```bash
    cat src/pytracify/override_functions.py | uv run pytracify example.py --override
    ```

## Differences from Native Python
- In nested functions, all variables are treated as nonlocal by default in Pytracify.
  - For example, in the following code, the variable `a` inside inner is considered `nonlocal`:
    ```python
    def outer():
        a = 1
        def inner():
            a = 2
        inner()
        print(a)   # This prints 2 in Pytracify, whereas in native Python it would print 1.
    ```
- `Import` and `ImportFrom` are not supported in Pytracify.
