import ast 
import operator 
from typing import Any ,Callable 

_BIN_OPS :dict [type [ast .AST ],tuple [Callable [[Any ,Any ],Any ],str |list ]]={
ast .Add :(operator .add ,"+"),
ast .Sub :(operator .sub ,"-"),
ast .Mult :(operator .mul ,"*"),
ast .Div :(operator .truediv ,"/"),
ast .FloorDiv :(operator .floordiv ,"//"),
ast .Mod :(operator .mod ,"%"),
ast .Pow :(operator .pow ,"**"),
ast .LShift :(operator .lshift ,"<<"),
ast .RShift :(operator .rshift ,">>"),
ast .BitAnd :(operator .and_ ,"&"),
ast .BitOr :(operator .or_ ,"|"),
ast .And :(operator .and_ ,"and"),
ast .Or :(operator .or_ ,"or"),
ast .BitXor :(operator .xor ,"^"),
ast .MatMult :(operator .matmul ,"@"),
}


_CMP_OPS :dict [type [ast .AST ],tuple [Callable [[Any ,Any ],Any ],str ]]={
ast .Eq :(operator .eq ,"=="),
ast .NotEq :(operator .ne ,"!="),
ast .Lt :(operator .lt ,"<"),
ast .LtE :(operator .le ,"<="),
ast .Gt :(operator .gt ,">"),
ast .GtE :(operator .ge ,">="),
ast .Is :(operator .is_ ,"is"),
ast .IsNot :(operator .is_not ,"is not"),
ast .In :(lambda lhs ,rhs :lhs in rhs ,"in"),
ast .NotIn :(lambda lhs ,rhs :lhs not in rhs ,"not in"),
}
