from pytracify import run 


def test_decorator_simple ()->None :
    code ="""
def double_result(func):
    def wrapper():
        result = func()
        return result * 2
    return wrapper

@double_result
def get_number():
    return 5

return get_number()
"""

    assert run (code ).result .value ==10 


def test_decorator_with_args ()->None :
    code ="""
def multiply_by(factor):
    def decorator(func):
        def wrapper(*args, **kwargs):
            result = func(*args, **kwargs)
            return result * factor
        return wrapper
    return decorator

@multiply_by(3)
def add(a, b):
    return a + b

return add(2, 3)
"""

    assert run (code ).result .value ==15 


def test_decorator_modifies_global ()->None :
    code ="""
call_count = 0

def count_calls(func):
    def wrapper(*args, **kwargs):
        global call_count
        call_count += 1
        return func(*args, **kwargs)
    return wrapper

@count_calls
def say_hello():
    return "Hello"

say_hello()
say_hello()

return call_count
"""

    assert run (code ).result .value ==2 


def test_decorator_on_method_in_class ()->None :
    code ="""
def method_decorator(func):
    def wrapper(*args, **kwargs):
        result = func(*args, **kwargs)
        return result + 100
    return wrapper

class AddClass:
    @method_decorator
    def add(x, y):
        return x + y

return AddClass.add(5, 8)
"""

    assert run (code ).result .value ==113 
