import datasets 
import fire 

from common .common_types import Sample 
from common .dataset import create_datasets 


def load_cruxeval ()->list [Sample ]:
    rows =datasets .load_dataset ("cruxeval-org/cruxeval",split ="test")
    return [
    Sample (
    sample_id =row ["id"],
    code =row ["code"],
    input =row ["input"],
    output =row ["output"],
    function_name ="f",
    )
    for row in rows 
    ]


def main (
data_name :str ="cruxeval",
output_dir :str ="/path/to/home/lltm/02_codeexec_etcot/scripts/instruction/convert_datasets"
):
    all_samples =load_cruxeval ()
    create_datasets (
    data_name ,all_samples ,train_ratio =0 ,output_dir =output_dir 
    )


if __name__ =="__main__":
    fire .Fire (main )
