import datasets 
import fire 
import csv 
import sys 
from common .common_types import Sample 


def load_cruxeval ()->list [Sample ]:
    rows =datasets .load_dataset ("cruxeval-org/cruxeval",split ="test")

    writer =csv .writer (sys .stdout ,quoting =csv .QUOTE_MINIMAL )
    writer .writerow (["input","output"])

    for row in rows :
        writer .writerow ([row ["input"],row ["output"]])

    return [
    Sample (
    sample_id =row ["id"],
    code =row ["code"],
    input =row ["input"],
    output =row ["output"],
    function_name ="f",
    )
    for row in rows 
    ]


def main ():
    load_cruxeval ()


if __name__ =="__main__":
    fire .Fire (main )
