EPOCH=4
NUM_GPUS=4

BASE_MODEL=Meta-Llama-3-8B-Instruct
MODEL_ORG="meta-llama"
TRAIN_DATASET=LLTM-all-ab3-numeric-depth-p80

CHECK_POINT_ROOT_PATH="/path/to/home/checkpoints"
CONVERTED_CHECK_POINT_ROOT_PATH="/path/to/home/converted_checkpoint"

SYSTEM_PROMPT="You are a highly capable assistant. Your task is to estimate the output of the given Python code. The reasoning process and output are enclosed within <think> </think> and <answer> </answer> tags, respectively, i.e., <think> reasoning process here </think><answer> output here </answer>"

LATEST_ITERATION_FILE="${CHECK_POINT_ROOT_PATH}/${BASE_MODEL}/${TRAIN_DATASET}_lr_2e-5-minlr_4e-6_GB_64_${EPOCH}epoch/latest_iteration.txt"

if [ -f "$LATEST_ITERATION_FILE" ]; then
  ITERATION=$(cat "$LATEST_ITERATION_FILE")
else
  ITERATION=7500
fi

FORMATTED_ITERATION=$(printf "iter_%07d" "$ITERATION")
INFERENCE_MODEL_PATH="${CONVERTED_CHECK_POINT_ROOT_PATH}/${BASE_MODEL}/${TRAIN_DATASET}_lr_2e-5-minlr_4e-6_GB_64_${EPOCH}epoch/${FORMATTED_ITERATION}"

USE_GUIDED_DECODING=false
