#!/bin/bash

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
CONFIG_DIR="${SCRIPT_DIR}/configs"

declare -a EXPERIMENTS_LIST=(


  "llama3/llama3-8B-etcot-ab2"
  "llama3/llama3-8B-etcot-ab3"
















)

for i in "${!EXPERIMENTS_LIST[@]}"; do
  EXPERIMENT_CONFIG="${EXPERIMENTS_LIST[$i]}"
  ${SCRIPT_DIR}/run_experiments.sh "${CONFIG_DIR}/${EXPERIMENT_CONFIG}.sh"

  python3 ${SCRIPT_DIR}/utils/send_to_slack.py \
    "EXPERIMENT: $EXPERIMENT_CONFIG Finished!"
done
