
TRAIN_DATASET=${1:-"LLTM-all-numeric-depth"}
BASE_MODEL=${2:-"Meta-Llama-3-8B-Instruct"}
ITERATION=${3:-"7500"}
EPOCH=${4:-"3"}

UTILS_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SCRIPT_DIR="$(cd "${UTILS_DIR}/../.." && pwd)"



echo "Total iterations: $ITERATION"

SOURCE_PATH=${SCRIPT_DIR}/ET-CoT/inference_outputs/${BASE_MODEL}/${EPOCH}epoch/

python3 ${UTILS_DIR}/aggregate_inference_outputs.py \
  "$SOURCE_PATH" \
  "$TRAIN_DATASET" \
  "$BASE_MODEL" \
  "$ITERATION" \
  "$USE_GUIDED_DECODING"

python3 ${UTILS_DIR}/send_to_slack.py "<!channel> 🎉 All Inferences Finished & Aggregated!
> • Model: \`$BASE_MODEL\`
> • Train Dataset: \`$TRAIN_DATASET\`
> • Epoch: \`$EPOCH\`
> • Iteration: \`$ITERATION\`
> • Guided Decoding: \`$USE_GUIDED_DECODING\`"
