/rename_inference_logs.sh








BASE_DIR="/path/to/home/lltm/02_codeexec_etcot/scripts/ET-CoT/inference_logs"

find "$BASE_DIR" -type f -name '*.log' | while read -r filepath; do
  dir=$(dirname "$filepath")
  filename=$(basename "$filepath")
  stem="${filename%.log}"


  label=$(grep -o -m1 'iter_[0-9]\+' "$filepath" || true)
  if [[ -n "$label" ]]; then

    newlabel=$(echo "$label" | sed -E 's/iter_0*([0-9]+)/iter\1/')
  else
    newlabel="err"
  fi

  newname="${newlabel}_${stem}.log"

  if [[ "$newname" == "$filename" ]]; then
    echo "スキップ: 変更不要    $filepath"
  else
    echo "リネーム: $filename → $newname"
    mv -i "$filepath" "$dir/$newname"
  fi
done

