#!/bin/bash

# 默认参数值
MAX_OBJNUM=3
MAX_CNUM=3
MAX_PNUM=3
RULE_WINDOW=999
SEED=43
I_START=2
I_END=5
I_ADD_START=5
I_ADD_END=8
GENERATE_NUM=10000

# 解析输入参数
while [[ "$#" -gt 0 ]]; do
    case $1 in
        --max_objnum) MAX_OBJNUM="$2"; shift ;;
        --max_cnum) MAX_CNUM="$2"; shift ;;
        --max_pnum) MAX_PNUM="$2"; shift ;;
        --rule_window) RULE_WINDOW="$2"; shift ;;
        --seed) SEED="$2"; shift ;;
        --i_start) I_START="$2"; shift ;;
        --i_end) I_END="$2"; shift ;;
        --i_add_start) I_ADD_START="$2"; shift ;;
        --i_add_end) I_ADD_END="$2"; shift ;;
        --generate_num) GENERATE_NUM="$2"; shift ;;
        *) echo "Unknown parameter passed: $1"; exit 1 ;;
    esac
    shift
done

# 动态生成 save_path
SAVE_PATH="./logicalDatasets/complex_templates_${MAX_OBJNUM}_c${MAX_CNUM}_p${MAX_PNUM}_rw${RULE_WINDOW}_s${SEED}_i${I_START}-${I_END}_j${I_ADD_START}-${I_ADD_END}.jsonl"

# 运行 Python 脚本
python generate_reasoning_complex_templates.py \
    --max_objnum "$MAX_OBJNUM" \
    --max_cnum "$MAX_CNUM" \
    --max_pnum "$MAX_PNUM" \
    --rule_window "$RULE_WINDOW" \
    --seed "$SEED" \
    --i_start "$I_START" \
    --i_end "$I_END" \
    --i_add_start "$I_ADD_START" \
    --i_add_end "$I_ADD_END" \
    --generate_num "$GENERATE_NUM" \
    --save_path "$SAVE_PATH"
