#!/bin/bash

# Default parameter values
templates_path="logicalDatasets/complex_templates_3_c3_p3_rw999_s43_i2-5_j5-8.jsonl"
generation_path_prefix="logicalDatasets/generation/generated_dataset"
add_fact_range_start=0
add_fact_range_end=10
remove_fact_range_start=0
remove_fact_range_end=10
add_rule_range_start=0
add_rule_range_end=10
p_add_rule_constraints=0.1
remove_rule_range_start=0
remove_rule_range_end=10
p_neg=0.3
p_dneg=0.1
p_add_conclution=0.1
add_conclution_max=1
p_change_variable=0.1
use_word=false
use_related_word=false
generation_num=100
seed=42
selected_num=10000

# Get parameters from command line
while getopts "t:g:a:r:A:R:p:n:d:c:m:v:w:x:G:s:S:" opt; do
  case $opt in
    t) templates_path="$OPTARG" ;;
    g) generation_path_prefix="$OPTARG" ;;
    a) IFS=',' read -r add_fact_range_start add_fact_range_end <<< "$OPTARG" ;;
    r) IFS=',' read -r remove_fact_range_start remove_fact_range_end <<< "$OPTARG" ;;
    A) IFS=',' read -r add_rule_range_start add_rule_range_end <<< "$OPTARG" ;;
    R) IFS=',' read -r remove_rule_range_start remove_rule_range_end <<< "$OPTARG" ;;
    p) p_add_rule_constraints="$OPTARG" ;;
    n) p_neg="$OPTARG" ;;
    d) p_dneg="$OPTARG" ;;
    c) p_add_conclution="$OPTARG" ;;
    m) add_conclution_max="$OPTARG" ;;
    v) p_change_variable="$OPTARG" ;;
    w) use_word=true ;;
    x) use_related_word=true ;;
    G) generation_num="$OPTARG" ;;
    s) seed="$OPTARG" ;;
    S) selected_num="$OPTARG" ;;
    *) echo "Invalid option: -$OPTARG" ;;
  esac
done

# Construct generation_path
generation_path="${generation_path_prefix}_af_${add_fact_range_start}_${add_fact_range_end}_rf_${remove_fact_range_start}_${remove_fact_range_end}_ar_${add_rule_range_start}_${add_rule_range_end}_rr_${remove_rule_range_start}_${remove_rule_range_end}_pac_${p_add_rule_constraints}_pn_${p_neg}_pd_${p_dneg}_pc_${p_add_conclution}_acm_${add_conclution_max}_pcv_${p_change_variable}_gw_${use_word}_grw_${use_related_word}_gn_${generation_num}_s_${seed}_sn_${selected_num}.jsonl"

# Execute command
echo python modify_reasoning_complex_templates.py \
  --templates_path "$templates_path" \
  --generation_path "$generation_path" \
  --add_fact_range $add_fact_range_start $add_fact_range_end \
  --remove_fact_range $remove_fact_range_start $remove_fact_range_end \
  --add_rule_range $add_rule_range_start $add_rule_range_end \
  --p_add_rule_constraints "$p_add_rule_constraints" \
  --remove_rule_range $remove_rule_range_start $remove_rule_range_end \
  --p_neg "$p_neg" \
  --p_dneg "$p_dneg" \
  --p_add_conclution "$p_add_conclution" \
  --add_conclution_max "$add_conclution_max" \
  --p_change_variable "$p_change_variable" \
  $( [ "$use_word" = true ] && echo "--use_word" ) \
  $( [ "$use_related_word" = true ] && echo "--use_related_word" ) \
  --generation_num "$generation_num" \
  --seed "$seed" \
  --selected_num "$selected_num"

python modify_reasoning_complex_templates.py \
  --templates_path "$templates_path" \
  --generation_path "$generation_path" \
  --add_fact_range $add_fact_range_start $add_fact_range_end \
  --remove_fact_range $remove_fact_range_start $remove_fact_range_end \
  --add_rule_range $add_rule_range_start $add_rule_range_end \
  --p_add_rule_constraints "$p_add_rule_constraints" \
  --remove_rule_range $remove_rule_range_start $remove_rule_range_end \
  --p_neg "$p_neg" \
  --p_dneg "$p_dneg" \
  --p_add_conclution "$p_add_conclution" \
  --add_conclution_max "$add_conclution_max" \
  --p_change_variable "$p_change_variable" \
  $( [ "$use_word" = true ] && echo "--use_word" ) \
  $( [ "$use_related_word" = true ] && echo "--use_related_word" ) \
  --generation_num "$generation_num" \
  --seed "$seed" \
  --selected_num "$selected_num"

echo "Generated dataset at: $generation_path"
