# LUSER
This repository is related to the paper "Loop Unrorlled Shallow Equilibrium Regularizer: a Memory-efficient Inverse Problem Solver". It introduces Deep Equilibrium Model (DEQ) as the learned regularizer update. We introduce two variants of LUSER, LUSER-SW for shared-weight and LUSER-DW for different weights for each Loop Unrolling blocks. We demonstrate the idea on three different image tasks: image deblurring (CelebA), CT (lodopab-CT) and MRI (fastMRI). LUSER is compared with Loop Unrolling algorithm with DnCNN as the proximal operator (LU-DnCNN) and Deep Equilibrium for Inverse Problems (DEQ4IP).

## About the Files
Networks folder contains the network definitions, operators folder defines forward operators and DEQ operators, solvers folder contains training and evaluation files for each task, and utils file contains dataloader and other files.

## Pre-requisite
Environment setup:
```
conda install pytorch torchvision torchaudio cudatoolkit=11.3 -c pytorch
conda install matplotlib
pip install ConfigArgParse tqdm fastmri h5py PyYAML numpy
pip install --upgrade pip
pip install opencv-python

# Below: for CT only
conda install -c astra-toolbox astra-toolbox 
pip install dival
conda install astra-toolbox -c astra-toolbox/label/dev
pip install git+https://github.com/ahendriksen/tomosipo@develop 

# make sure orotobuf version is not too recent
pip install -Iv protobuf==3.20.1
# odl version > 1.00
pip install https://github.com/odlgroup/odl/archive/master.zip --upgrade
```

## How to evaluate
To evaluate any solver file, _i.e._ ```luser_dw_celeba.py``` file, ```luser_dw_celeba.py --eval --use_aux_loss --load_path <load_path>```
The LUSER-DW network parameters are saved under ```saved_models``` folder.


Code clean up is on going...
