#!/bin/bash
VS=1

for model in resnet20 resnet32 resnet44 resnet56 resnet110 
do
    echo "IEA Rest"
    CUDA_VISIBLE_DEVICES=0 python -u trainer.py --version=$VS   --arch=$model  --save-dir=./output/resnet_cifar_10/save_$model --model_type iea & 
done

for model in resnet1202
do
    echo "IEA 1202"
    CUDA_VISIBLE_DEVICES=1 python -u trainer.py --version=$VS   --arch=$model  --save-dir=./output/resnet_cifar_10/save_$model --model_type iea & 
done

######## 
for model in resnet20 resnet32 resnet44 resnet56 resnet110 
do
    echo "normal Rest"
    CUDA_VISIBLE_DEVICES=2 python -u trainer.py --version=$VS   --arch=$model  --save-dir=./output/resnet_cifar_10/save_$model --model_type normal & 
done

for model in resnet1202
do
    echo "normal 1202"
    CUDA_VISIBLE_DEVICES=3 python -u trainer.py --version=$VS   --arch=$model  --save-dir=./output/resnet_cifar_10/save_$model --model_type normal & 
done

######## 
for model in resnet20 resnet32 resnet44 resnet56 resnet110 
do
    echo "maxout Rest"
    CUDA_VISIBLE_DEVICES=4 python -u trainer.py --version=$VS   --arch=$model  --save-dir=./output/resnet_cifar_10/save_$model --model_type maxout & 
done

for model in resnet1202
do
    echo "maxout 1202"
    CUDA_VISIBLE_DEVICES=5,6 python -u trainer.py --version=$VS   --arch=$model  --save-dir=./output/resnet_cifar_10/save_$model --model_type maxout & 
done
