
import os 


versions = [0,1,2]
gpus = {0:1,1:1,2:1,3:1,4:1,5: 2}

template = """ #!/bin/bash
#SBATCH -N 1
#SBATCH --partition=batch
#SBATCH --mail-user=user.user@email.com
#SBATCH --mail-type=ALL
#SBATCH --time=72:00:00
#SBATCH --mem=32G
#SBATCH --gres=gpu:{0}
#SBATCH --cpus-per-task=8
#SBATCH --constraint=[v100]

#run the application:

module load pytorch 
cd /home/user/iea_all_exps/resnet_cifar_10  && ./run_{1}_{2}.sh

echo "The job started"
"""


for v in versions:
    for k in range(6):
        with open("srun_{0}_{1}.sh".format(v,k), "w")  as f: 
            f.write(template.format(gpus[k],v,k))
            f.close()
            
    
