import omegaconf
from gym import Env


def fix_env_config(cfg: omegaconf.DictConfig, env: Env) -> omegaconf.DictConfig:
    print("Setting environment details in the config")
    if hasattr(env, "observation_spec"):
        obs_space = env.observation_spec().shape
        act_space = env.action_spec().shape
    else:
        obs_space = env.observation_space.shape
        act_space = env.action_space.shape
    if len(obs_space) == 3:
        setattr(cfg.env, "state_dim", obs_space)  # type: ignore
    else:
        setattr(cfg.env, "state_dim", obs_space[0])  # type: ignore
    setattr(cfg.env, "action_dim", act_space[0])  # type: ignore
    return cfg
