#!/bin/bash
#SBATCH -N 1            # number of nodes on which to run
#SBATCH --gres=gpu:1        # number of gpus
#SBATCH --cpus-per-task=1     # number of cpus required per task
#SBATCH --ntasks=1
#SBATCH --tasks-per-node=1
#SBATCH --time=128:00:00      # time limit
#SBATCH --mem=8GB         # minimum amount of real memory
#SBATCH --array=1-8

module load cuda-11.6

cd ~/latent-value-aware-model-learning

source ~/venv/bin/activate

i=$RANDOM

MUJOCO_GL=egl python lambda_ac/main.py --config-name main \
    log_freq=500 \
    seed=$i \
    name=$1 \
    env=dmc \
    env.kwargs.action_noise=$3 \
    env.env_id=$2 \
    env.kwargs.action_noise_type=$4 \
    env.kwargs.action_noise_level=$5 \
    agent.use_muzero_target=$6 \
    agent.update_encoder_critic=$7 \
    agent.model_losses=$8 \
    agent.use_svg_policy_update=False \
    agent.actor_rollout_depth=0 \
    agent.critic.encoder.feature_dim=$9
