# Mind the Gap: Bridging Train-Test Discrepancies in Differentiable Logic Gate Networks

This repository contains code for our NeurIPS 2025 submission **_Mind the Gap: Bridging Train-Test Discrepancies in Differentiable Logic Gate Networks_**.  
It builds on the original NeurIPS 2022 paper [_Deep Differentiable Logic Gate Networks_](https://proceedings.neurips.cc/paper_files/paper/2022/file/0d3496dd0cec77a999c98d35003203ca-Paper-Conference.pdf).

## 🔬  Running an Experiment

Experiments are configured using `.yaml` files.  
Here is an example configuration:

````yaml
experiment_name: "example_run"
dataset: "CIFAR10"
seed: 42
num_layers: 12
num_neurons: 256000
training_bit_count: 32
grad_factor: 1.0
gumbel_tau: 1.0
stochastic: "gumbel"
batch_size: 128
lr: 0.01
num_iterations: 10000000
tau: 100
save_final_model: true
save_model_per_eval: false
resume_checkpoint: null
````


## 🚀 Launching with Apptainer

We recommend using our provided Apptainer / Singularity container. From the project root, run:


````
apptainer exec --nv \
  --bind $(pwd) \
  container.sif \
  python main.py \
  --config example.yaml
````


Replace example.yaml with the path to your desired config file.


> ⚠️ Note: Running the code requires a compatible GPU setup and the Apptainer runtime installed on your system.
Ensure container.sif is present in the current directory or adjust the path accordingly. Inside container.sif you need to adjust **correct cuda version**, i.e. 'export TORCH_CUDA_ARCH_LIST="7.5"'



### 🛠️ Building the Container

To build the container locally:
<ol>
  <li>Install [Apptainer](https://apptainer.org/docs/)</li>
  <li>Build the container
  
  </li>

  ````
apptainer build container.sif container.def
````


</ol>


