from .bayesian_npe import BayesianNPEFactory
from .bayesian_nre import BayesianNREFactory
from .bnpe import BNPEFactory
from .bnre import BNREFactory
from .dirichlet_model import DirichletFactory
from .discretized_bayesian_npe import DiscretizedBayesianNPEFactory
from .npe import NPEFactory
from .nre import NREFactory
from .nre_c import NRECFactory
from .ratio_bnpe import RatioBNPEFactory
from .ratio_npe import RatioNPEFactory
from .gp_model import GPFactory


def load_model_factory(config, benchmark, simulation_budget):
    if config["method"] == "nre":
        return NREFactory(config, benchmark, simulation_budget)

    elif config["method"] == "bnre":
        return BNREFactory(config, benchmark, simulation_budget)

    elif config["method"] == "npe":
        return NPEFactory(config, benchmark, simulation_budget)

    elif config["method"] == "bnpe":
        return BNPEFactory(config, benchmark, simulation_budget)

    elif config["method"] == "ratio_npe":
        return RatioNPEFactory(config, benchmark, simulation_budget)

    elif config["method"] == "ratio_bnpe":
        return RatioBNPEFactory(config, benchmark, simulation_budget)

    elif config["method"] == "nre_c":
        return NRECFactory(config, benchmark, simulation_budget)

    elif config["method"] == "bayesian_npe":
        return BayesianNPEFactory(config, benchmark, simulation_budget)
    
    elif config["method"] == "bayesian_nre":
        return BayesianNREFactory(config, benchmark, simulation_budget)

    elif config["method"] == "discretized_bayesian_npe":
        return DiscretizedBayesianNPEFactory(config, benchmark, simulation_budget)

    elif config["method"] == "dirichlet":
        return DirichletFactory(config, benchmark, simulation_budget)

    elif config["method"] == "gaussian_process":
        return GPFactory(config, benchmark, simulation_budget)

    else:
        raise NotImplementedError("Model not implemented")
